/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.PartitioningAttributeConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.PartitioningStrategyUtil;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.SqlEndToEndTestSupport;
import com.hazelcast.jet.sql.impl.SqlPlanImpl;
import com.hazelcast.jet.sql.impl.module.Pojo;
import com.hazelcast.jet.sql.impl.module.PortablePojo;
import com.hazelcast.map.IMap;
import com.hazelcast.partition.PartitionAware;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.SqlResult;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class SqlPartitionPruningE2ETest
extends SqlEndToEndTestSupport {
    private String mapName;
    private Tuple2<Set<Address>, Set<Integer>> expectedPartitionsAndMembers;

    @BeforeClass
    public static void beforeClass() throws Exception {
        SqlPartitionPruningE2ETest.initialize((int)5, null);
    }

    @Before
    public void before() throws Exception {
        this.mapName = SqlPartitionPruningE2ETest.randomName();
    }

    @Test
    public void when_scanWithSimplePruningKey_then_prunable() {
        int c = 2;
        String query = "SELECT * FROM " + this.mapName + " WHERE f0 = 2";
        this.preparePrunableMap(Collections.singletonList("f0"), this.mapName, 2);
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Collections.singletonList(new SqlTestSupport.Row(2, 2, 2, "2")), new Object[0]);
        Set partitionsToUse = this.planExecutor.tryUsePrunability(selectPlan, this.eec);
        this.assertPrunability(1, partitionsToUse);
    }

    @Test
    public void when_scanWithSimplePortablePruningKey_then_prunable() {
        int c = 2;
        String query = "SELECT * FROM " + this.mapName + " WHERE f0 = 2";
        this.preparePrunableMap(Collections.singletonList("f0"), this.mapName, SerializationType.PORTABLE, 2);
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Collections.singletonList(new SqlTestSupport.Row(2, 2, 2, "2")), new Object[0]);
        Set partitionsToUse = this.planExecutor.tryUsePrunability(selectPlan, this.eec);
        this.assertPrunability(1, partitionsToUse);
    }

    @Test
    public void when_scanWithSimpleCompactPruningKey_then_prunable() {
        int c = 2;
        String query = "SELECT f0, f5 FROM " + this.mapName + " WHERE f0 = 2";
        this.preparePrunableMap(Collections.singletonList("f0"), this.mapName, SerializationType.COMPACT, 2);
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Collections.singletonList(new SqlTestSupport.Row(2, 2)), new Object[0]);
        Set partitionsToUse = this.planExecutor.tryUsePrunability(selectPlan, this.eec);
        this.assertPrunability(1, partitionsToUse);
    }

    @Test
    public void when_analyzeScanWithSimplePruningKey_then_prunable() {
        int c = 2;
        String query = "ANALYZE SELECT * FROM " + this.mapName + " WHERE f0 = 2";
        this.preparePrunableMap(Collections.singletonList("f0"), this.mapName, 2);
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Collections.singletonList(new SqlTestSupport.Row(2, 2, 2, "2")), new Object[0]);
        Set partitionsToUse = this.planExecutor.tryUsePrunability(selectPlan, this.eec);
        this.assertPrunability(1, partitionsToUse);
    }

    @Test
    public void when_scanWithoutDefinedStrategy_then_nonPrunable() {
        int c = 2;
        String query = "SELECT * FROM " + this.mapName + " WHERE f0 = 2";
        this.preparePrunableMap(Collections.emptyList(), this.mapName, 2);
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        Set partitionsToUse = this.planExecutor.tryUsePrunability(selectPlan, this.eec);
        Assert.assertEquals((long)0L, (long)partitionsToUse.size());
        this.assertQueryResult(selectPlan, Collections.singletonList(new SqlTestSupport.Row(2, 2, 2, "2")), new Object[0]);
    }

    @Test
    public void when_scanWithCompoundPruningKey_then_prunable() {
        int c = 2;
        String query = "SELECT * FROM " + this.mapName + " WHERE f0 = 2 AND f1 = 2";
        this.preparePrunableMap(Arrays.asList("f0", "f1"), this.mapName, 2);
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Collections.singletonList(new SqlTestSupport.Row(2, 2, 2, "2")), new Object[0]);
        Set partitionsToUse = this.planExecutor.tryUsePrunability(selectPlan, this.eec);
        this.assertPrunability(1, partitionsToUse);
    }

    @Test
    public void when_renamingScanWithCompoundPruningKey_then_prunable() {
        int c = 2;
        String query = "SELECT * FROM hazelcast.public." + this.mapName + " WHERE f0 = 2 AND f1 = 2";
        this.preparePrunableMap(Arrays.asList("f0", "f1"), this.mapName, 2);
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Collections.singletonList(new SqlTestSupport.Row(2, 2, 2, "2")), new Object[0]);
        Set partitionsToUse = this.planExecutor.tryUsePrunability(selectPlan, this.eec);
        this.assertPrunability(1, partitionsToUse);
    }

    @Test
    public void when_renamingNonPartitionedScanWithCompoundPruningKey_then_nonPrunable() {
        int c = 2;
        String query = "SELECT * FROM hazelcast.public." + this.mapName + " WHERE f0 = 2 AND f1 = 2";
        this.preparePrunableMap(Collections.emptyList(), this.mapName, 2);
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Collections.singletonList(new SqlTestSupport.Row(2, 2, 2, "2")), new Object[0]);
        Set partitionsToUse = this.planExecutor.tryUsePrunability(selectPlan, this.eec);
        Assert.assertEquals((long)0L, (long)partitionsToUse.size());
    }

    @Test
    public void when_keyWithNestedPartitionAwareKey_then_prunable() {
        long c = 2L;
        PAKey key = new PAKey(2L, "2");
        this.preparePrunableMapWithPartitionAwareKey(Collections.singletonList("nestedKey"), this.mapName, false, key);
        String query = "SELECT this FROM " + this.mapName + " WHERE nestedKey = ?";
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Collections.singletonList(new SqlTestSupport.Row("2")), key);
        Set partitionsToUse = this.planExecutor.tryUsePrunability(selectPlan, this.eec);
        this.assertPrunability(1, partitionsToUse);
    }

    @Test
    public void when_partitionAwareKeyWithNestedPartitionAwareKey_then_prunable() {
        long c = 2L;
        PAKey key = new PAKey(2L, "2");
        this.preparePrunableMapWithPartitionAwareKey(Collections.singletonList("nestedKey"), this.mapName, true, key);
        String query = "SELECT this FROM " + this.mapName + " WHERE nestedKey = ?";
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Collections.singletonList(new SqlTestSupport.Row("2")), key);
        Set partitionsToUse = this.planExecutor.tryUsePrunability(selectPlan, this.eec);
        this.assertPrunability(1, partitionsToUse);
    }

    @Test
    public void when_fullyComparePartitionAwareKeyWithNestedPAKey_then_prunable() {
        long c = 2L;
        PAKey key = new PAKey(2L, "2");
        String query = "SELECT this FROM " + this.mapName + " WHERE __key = ? AND this IS NOT NULL";
        IMap map = SqlPartitionPruningE2ETest.instance().getMap(this.mapName);
        SqlPartitionPruningE2ETest.createMapping(this.mapName, PAKeyWithPAField.class, String.class);
        map.put((Object)new PAKeyWithPAField(key), (Object)"2");
        this.expectedPartitionsAndMembers = this.calculateExpectedPartitionsForNestedKeys(true, 1, key);
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Collections.singletonList(new SqlTestSupport.Row("2")), new PAKeyWithPAField(key));
        Set partitionsToUse = this.planExecutor.tryUsePrunability(selectPlan, this.eec);
        this.assertPrunability(1, partitionsToUse);
    }

    @Test
    public void when_compoundSingleFieldNullKey_nonPrunable() {
        long c = 2L;
        PAKey key = new PAKey(2L, "2");
        this.preparePrunableMapWithPartitionAwareKey(Collections.singletonList("nestedKey"), this.mapName, false, key);
        String query = "SELECT this FROM " + this.mapName + " WHERE nestedKey = ?";
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Collections.emptyList(), new Object[1]);
        Set partitionsToUse = this.planExecutor.tryUsePrunability(selectPlan, this.eec);
        Assert.assertEquals((long)0L, (long)partitionsToUse.size());
    }

    @Test
    public void when_selfUnionAllForOrPredicateAndSimplePruningKey_then_prunable() {
        int[] c = new int[]{2, 3};
        String query = "(SELECT * FROM " + this.mapName + " WHERE f1 = " + c[0] + ") UNION ALL (SELECT * FROM " + this.mapName + " WHERE f1 = " + c[1] + ")";
        this.preparePrunableMap(Collections.singletonList("f1"), this.mapName, c);
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Arrays.asList(new SqlTestSupport.Row(c[0], c[0], c[0], "" + c[0]), new SqlTestSupport.Row(c[1], c[1], c[1], "" + c[1])), new Object[0]);
        Set partitionsToUse = this.planExecutor.tryUsePrunability(selectPlan, this.eec);
        this.assertPrunability(c.length, partitionsToUse);
    }

    @Test
    public void when_selfUnionAllForOrPredicateAndCompoundPruningKey_then_prunable() {
        int[] c = new int[]{2, 3};
        String query = "(SELECT * FROM " + this.mapName + " WHERE f0 = " + c[0] + " AND f1 = " + c[0] + ") UNION ALL (SELECT * FROM " + this.mapName + " WHERE f0 = " + c[1] + " AND f1 = " + c[1] + ")";
        this.preparePrunableMap(Arrays.asList("f0", "f1"), this.mapName, c);
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Arrays.asList(new SqlTestSupport.Row(c[0], c[0], c[0], "" + c[0]), new SqlTestSupport.Row(c[1], c[1], c[1], "" + c[1])), new Object[0]);
        Set partitionsToUse = this.planExecutor.tryUsePrunability(selectPlan, this.eec);
        this.assertPrunability(c.length, partitionsToUse);
    }

    @Test
    public void when_unionAllTwoMapsWithCompoundPruningKey_then_prunable() {
        String secondMapName = SqlPartitionPruningE2ETest.randomName();
        int[] c = new int[]{2, 3};
        String query = "(SELECT f2 FROM " + this.mapName + " WHERE f0 = " + c[0] + " AND f1 = " + c[0] + ") UNION ALL (SELECT f2 FROM " + secondMapName + " WHERE f0 = " + c[1] + " AND f1 = " + c[1] + ")";
        this.preparePrunableMap(Arrays.asList("f0", "f1"), this.mapName, c[0]);
        this.preparePrunableMap(Arrays.asList("f0", "f1"), secondMapName, c[1]);
        this.expectedPartitionsAndMembers = this.calculateExpectedPartitions(2, c);
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Arrays.asList(new SqlTestSupport.Row(c[0]), new SqlTestSupport.Row(c[1])), new Object[0]);
        Set partitionsToUse = this.planExecutor.tryUsePrunability(selectPlan, this.eec);
        this.assertPrunability(2, partitionsToUse);
    }

    @Test
    public void when_unionAllTwoMapsAndOneMapIsNotPrunable_then_nonPrunable() {
        String secondMapName = SqlPartitionPruningE2ETest.randomName();
        int[] c = new int[]{2, 3};
        String query = "(SELECT f2 FROM " + this.mapName + " WHERE f0 = " + c[0] + " AND f1 = " + c[0] + ") UNION ALL (SELECT f2 FROM " + secondMapName + " WHERE f0 = " + c[1] + " AND f1 = " + c[1] + ")";
        this.preparePrunableMap(Arrays.asList("f0", "f1"), this.mapName, c);
        IMap map2 = SqlPartitionPruningE2ETest.instance().getMap(secondMapName);
        SqlPartitionPruningE2ETest.createMapping(secondMapName, Pojo.class, String.class);
        map2.put((Object)new Pojo(c[1], c[1], c[1]), (Object)"3");
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Arrays.asList(new SqlTestSupport.Row(2), new SqlTestSupport.Row(3)), new Object[0]);
        Assert.assertEquals((long)0L, (long)this.planExecutor.tryUsePrunability(selectPlan, this.eec).size());
    }

    @Ignore(value="https://hazelcast.atlassian.net/browse/HZ-2796")
    @Test
    public void when_unionWithSimplePruningKey_then_non_prunable() {
        String mapName = SqlPartitionPruningE2ETest.randomName();
        int c = 2;
        String query = "(SELECT f2 FROM " + mapName + " WHERE f0 = 2) UNION (SELECT f2 FROM " + mapName + " WHERE f0 = 2)";
        this.preparePrunableMap(Collections.emptyList(), mapName, 2);
        SqlPlanImpl.SelectPlan selectPlan = this.assertQueryPlan(query);
        this.assertQueryResult(selectPlan, Collections.singletonList(new SqlTestSupport.Row(2)), new Object[0]);
        Assert.assertEquals((long)0L, (long)this.planExecutor.tryUsePrunability(selectPlan, this.eec).size());
    }

    protected void assertPrunability(int expectedPartitionsCount, Set<Integer> partitionsToUse) {
        Set expectedPartitionsToUsePE = (Set)this.sqlJobInvocationObserver.jobConfig.getArgument("__sql.requiredPartitions");
        Set expectedPartitionsToUseJCS = (Set)this.jobInvocationObserver.jobConfig.getArgument("__sql.requiredPartitions");
        Set expectedPartitionsToParticipate = (Set)this.expectedPartitionsAndMembers.f1();
        Assert.assertEquals((long)expectedPartitionsCount, (long)partitionsToUse.size());
        this.assertRequiredPartitions(expectedPartitionsToParticipate, expectedPartitionsToUsePE);
        this.assertRequiredPartitions(expectedPartitionsToParticipate, expectedPartitionsToUseJCS);
        this.assertRequiredMembers((Set)this.expectedPartitionsAndMembers.f0());
    }

    protected void assertRequiredPartitions(Set<Integer> expectedPartitions, Set<Integer> actualPartitions) {
        Assert.assertNotNull(expectedPartitions);
        Assert.assertNotNull(actualPartitions);
        SqlPartitionPruningE2ETest.assertContainsAll(expectedPartitions, actualPartitions);
    }

    protected void assertRequiredMembers(Set<Address> expectedMemberAddresses) {
        Set<Address> actualMemberAddresses = this.jobInvocationObserver.getMembers();
        Assert.assertNotNull(expectedMemberAddresses);
        Assert.assertNotNull(actualMemberAddresses);
        SqlPartitionPruningE2ETest.assertContainsAll(expectedMemberAddresses, actualMemberAddresses);
    }

    private void preparePrunableMap(List<String> attrs, String mapName, int ... constants) {
        this.preparePrunableMap(attrs, mapName, SerializationType.JAVA, constants);
    }

    private void preparePrunableMap(List<String> attrs, String mapName, SerializationType mode, int ... constants) {
        if (!attrs.isEmpty()) {
            this.expectedPartitionsAndMembers = this.calculateExpectedPartitions(attrs.size(), constants);
            List attributes = attrs.stream().map(PartitioningAttributeConfig::new).collect(Collectors.toList());
            SqlPartitionPruningE2ETest.instance().getConfig().addMapConfig(new MapConfig(mapName).setPartitioningAttributeConfigs(attributes));
        }
        switch (mode) {
            case JAVA: {
                IMap map1 = SqlPartitionPruningE2ETest.instance().getMap(mapName);
                SqlPartitionPruningE2ETest.createMapping(mapName, Pojo.class, String.class);
                for (int c : constants) {
                    map1.put((Object)new Pojo(c, c, c), (Object)("" + c));
                }
                return;
            }
            case PORTABLE: {
                IMap map2 = SqlPartitionPruningE2ETest.instance().getMap(mapName);
                try (SqlResult sqlResult = SqlPartitionPruningE2ETest.instance().getSql().execute("CREATE OR REPLACE MAPPING " + mapName + "(f0 INT EXTERNAL NAME  \"__key.f0\", f1 INT EXTERNAL NAME  \"__key.f1\", f2 INT EXTERNAL NAME  \"__key.f2\", this VARCHAR EXTERNAL NAME \"this\") TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='1337', 'keyPortableClassId'='1', 'keyPortableClassVersion'='0', 'valueFormat'='java', 'valueJavaClass'='" + String.class.getName() + "')", new Object[0]);){
                    Assertions.assertThat((long)sqlResult.updateCount()).isEqualTo(0L);
                }
                for (int c : constants) {
                    map2.put((Object)new PortablePojo(c, c, c), (Object)("" + c));
                }
                return;
            }
            case COMPACT: {
                IMap iMap = SqlPartitionPruningE2ETest.instance().getMap(mapName);
                try (SqlResult result = SqlPartitionPruningE2ETest.instance().getSql().execute("CREATE OR REPLACE MAPPING " + mapName + "(f0 INT EXTERNAL NAME \"__key.f0\", f1 INT EXTERNAL NAME \"__key.f1\", f2 INT EXTERNAL NAME \"__key.f2\", f3 INT EXTERNAL NAME \"this.f0\", f4 INT EXTERNAL NAME \"this.f1\", f5 INT EXTERNAL NAME  \"this.f2\") TYPE IMap OPTIONS ('keyFormat'='compact', 'keyCompactTypeName'='pojo', 'valueFormat'='compact', 'valueCompactTypeName'='string')", new Object[0]);){
                    Assertions.assertThat((long)result.updateCount()).isEqualTo(0L);
                }
                for (int c : constants) {
                    iMap.put((Object)new Pojo(c, c, c), (Object)new Pojo(c, c, c));
                }
                break;
            }
        }
    }

    private Tuple2<Set<Address>, Set<Integer>> calculateExpectedPartitions(boolean shouldUseCoordinator, int arity, int ... partitionedPredicateConstants) {
        return SqlPartitionPruningE2ETest.calculateExpectedPartitions((NodeEngine)this.nodeEngine, SqlPartitionPruningE2ETest.getPartitionAssignment((HazelcastInstance)SqlPartitionPruningE2ETest.instance()), shouldUseCoordinator, arity, partitionedPredicateConstants);
    }

    private Tuple2<Set<Address>, Set<Integer>> calculateExpectedPartitions(int arity, int ... partitionedPredicateConstants) {
        return this.calculateExpectedPartitions(true, arity, partitionedPredicateConstants);
    }

    private void preparePrunableMapWithPartitionAwareKey(List<String> attrs, String mapName, boolean usePartitionAwareKey, PAKey ... keys) {
        if (!attrs.isEmpty()) {
            this.expectedPartitionsAndMembers = this.calculateExpectedPartitionsForNestedKeys(true, attrs.size(), keys);
            List attributes = attrs.stream().map(PartitioningAttributeConfig::new).collect(Collectors.toList());
            SqlPartitionPruningE2ETest.instance().getConfig().addMapConfig(new MapConfig(mapName).setPartitioningAttributeConfigs(attributes));
        }
        IMap map = SqlPartitionPruningE2ETest.instance().getMap(mapName);
        SqlPartitionPruningE2ETest.createMapping(mapName, usePartitionAwareKey ? PAKeyWithPAField.class : KeyWithPAField.class, String.class);
        for (PAKey k : keys) {
            map.put((Object)(usePartitionAwareKey ? new PAKeyWithPAField(k) : new KeyWithPAField(k)), (Object)("" + k.id));
        }
    }

    private Tuple2<Set<Address>, Set<Integer>> calculateExpectedPartitionsForNestedKeys(boolean shouldUseCoordinator, int arity, PAKey ... keys) {
        PartitionService partitionService = SqlPartitionPruningE2ETest.instance().getPartitionService();
        Map partitionAssignment = SqlPartitionPruningE2ETest.getPartitionAssignment((HazelcastInstance)SqlPartitionPruningE2ETest.instance());
        HashMap<Integer, Address> reversedPartitionAssignment = new HashMap<Integer, Address>();
        for (Map.Entry entry : partitionAssignment.entrySet()) {
            for (int partitionId : (int[])entry.getValue()) {
                reversedPartitionAssignment.put(partitionId, (Address)entry.getKey());
            }
        }
        HashSet<Integer> expectedPartitionsToParticipate = new HashSet<Integer>();
        HashSet<Address> expectedMembersToParticipate = new HashSet<Address>();
        for (PAKey key : keys) {
            Object[] paKeys = new PAKey[arity];
            Arrays.fill(paKeys, key);
            Data keyData = this.nodeEngine.getSerializationService().toData(PartitioningStrategyUtil.constructAttributeBasedKey((Object[])paKeys), (PartitioningStrategy & Serializable)v -> v);
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(keyData);
            Assert.assertTrue((boolean)reversedPartitionAssignment.containsKey(partitionId));
            expectedPartitionsToParticipate.add(partitionId);
            expectedMembersToParticipate.add((Address)reversedPartitionAssignment.get(partitionId));
        }
        if (shouldUseCoordinator) {
            expectedMembersToParticipate.add(SqlPartitionPruningE2ETest.instance().getCluster().getLocalMember().getAddress());
            expectedPartitionsToParticipate.add(partitionService.getPartition((Object)"").getPartitionId());
        }
        return Tuple2.tuple2(expectedMembersToParticipate, expectedPartitionsToParticipate);
    }

    static enum SerializationType {
        JAVA,
        PORTABLE,
        COMPACT;

    }

    protected static class PAKey
    implements Serializable,
    PartitionAware<String>,
    Comparable<PAKey> {
        public Long id;
        public String name;

        public PAKey() {
        }

        public PAKey(Long id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getPartitionKey() {
            return "hello";
        }

        @Override
        public int compareTo(@Nonnull PAKey o) {
            return this.hashCode() - o.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PAKey paKey = (PAKey)o;
            return Objects.equals(this.id, paKey.id) && Objects.equals(this.name, paKey.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }
    }

    protected static class PAKeyWithPAField
    implements Serializable,
    PartitionAware<PAKey>,
    Comparable<PAKeyWithPAField> {
        private PAKey nestedKey;

        public PAKeyWithPAField() {
        }

        public PAKeyWithPAField(PAKey nestedKey) {
            this.nestedKey = nestedKey;
        }

        public PAKey getPartitionKey() {
            return this.nestedKey;
        }

        public PAKey getNestedKey() {
            return this.nestedKey;
        }

        public void setNestedKey(PAKey nestedKey) {
            this.nestedKey = nestedKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyWithPAField that = (KeyWithPAField)o;
            return Objects.equals(this.nestedKey, that.nestedKey);
        }

        public int hashCode() {
            return Objects.hash(this.nestedKey);
        }

        @Override
        public int compareTo(PAKeyWithPAField o) {
            return this.nestedKey.compareTo(o.nestedKey);
        }
    }

    protected static class KeyWithPAField
    implements Serializable {
        private PAKey nestedKey;

        public KeyWithPAField() {
        }

        public KeyWithPAField(PAKey nestedKey) {
            this.nestedKey = nestedKey;
        }

        public PAKey getNestedKey() {
            return this.nestedKey;
        }

        public void setNestedKey(PAKey nestedKey) {
            this.nestedKey = nestedKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyWithPAField that = (KeyWithPAField)o;
            return Objects.equals(this.nestedKey, that.nestedKey);
        }

        public int hashCode() {
            return Objects.hash(this.nestedKey);
        }
    }
}

