/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.PartitioningAttributeConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.PartitioningStrategyUtil;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.JobInvocationObserver;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.PlanExecutor;
import com.hazelcast.jet.sql.impl.SqlJobInvocationObserver;
import com.hazelcast.jet.sql.impl.SqlPlanImpl;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.SqlExpectedResultType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.SqlServiceImpl;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.security.NoOpSqlSecurityContext;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import com.hazelcast.test.Accessors;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public abstract class SqlEndToEndTestSupport
extends SqlTestSupport {
    protected ExpressionEvalContext eec;
    protected NodeEngineImpl nodeEngine;
    protected SqlServiceImpl sqlService;
    protected PlanExecutor planExecutor;
    protected JobCoordinationService jobCoordinationService;
    protected SqlJobInvocationObserverImpl sqlJobInvocationObserver;
    protected JobInvocationObserverImpl jobInvocationObserver;

    @Before
    public void setUp() throws Exception {
        this.nodeEngine = Accessors.getNodeEngineImpl((HazelcastInstance)SqlEndToEndTestSupport.instance());
        this.sqlJobInvocationObserver = new SqlJobInvocationObserverImpl();
        this.jobInvocationObserver = new JobInvocationObserverImpl();
        this.sqlService = (SqlServiceImpl)SqlEndToEndTestSupport.instance().getSql();
        this.planExecutor = this.sqlService.getOptimizer().getPlanExecutor();
        this.jobCoordinationService = SqlEndToEndTestSupport.getJetServiceBackend((HazelcastInstance)SqlEndToEndTestSupport.instance()).getJobCoordinationService();
        this.planExecutor.registerJobInvocationObserver((SqlJobInvocationObserver)this.sqlJobInvocationObserver);
        this.jobCoordinationService.registerInvocationObserver((JobInvocationObserver)this.jobInvocationObserver);
        this.eec = ExpressionEvalContext.createContext(Collections.emptyList(), (HazelcastInstance)SqlEndToEndTestSupport.instance(), (InternalSerializationService)Util.getSerializationService((HazelcastInstance)SqlEndToEndTestSupport.instance()), null);
    }

    @After
    public void teardown() {
        this.jobCoordinationService.unregisterInvocationObserver((JobInvocationObserver)this.jobInvocationObserver);
    }

    SqlPlanImpl.SelectPlan assertQueryPlan(String query) {
        SqlStatement sql = new SqlStatement(query);
        SqlPlan plan = this.sqlService.prepare(sql.getSchema(), query, sql.getParameters(), SqlExpectedResultType.ROWS, (SqlSecurityContext)NoOpSqlSecurityContext.INSTANCE);
        SqlEndToEndTestSupport.assertInstanceOf(SqlPlanImpl.SelectPlan.class, (Object)plan);
        return (SqlPlanImpl.SelectPlan)plan;
    }

    SqlPlanImpl.DmlPlan assertDmlQueryPlan(String query) {
        SqlStatement sql = new SqlStatement(query);
        SqlPlan plan = this.sqlService.prepare(sql.getSchema(), query, sql.getParameters(), SqlExpectedResultType.UPDATE_COUNT, (SqlSecurityContext)NoOpSqlSecurityContext.INSTANCE);
        SqlEndToEndTestSupport.assertInstanceOf(SqlPlanImpl.DmlPlan.class, (Object)plan);
        return (SqlPlanImpl.DmlPlan)plan;
    }

    void assertQueryResult(SqlPlanImpl.SelectPlan selectPlan, Collection<SqlTestSupport.Row> expectedResults, Object ... args) {
        List<Object> arguments = Collections.emptyList();
        if (args.length > 0) {
            arguments = Arrays.asList(args);
            this.eec = ExpressionEvalContext.createContext(arguments, (HazelcastInstance)SqlEndToEndTestSupport.instance(), (InternalSerializationService)Util.getSerializationService((HazelcastInstance)SqlEndToEndTestSupport.instance()), null);
        }
        QueryId queryId = QueryId.create((UUID)UUID.randomUUID());
        SqlResult result = this.planExecutor.execute(selectPlan, queryId, arguments, 0L, (SqlSecurityContext)NoOpSqlSecurityContext.INSTANCE);
        SqlEndToEndTestSupport.assertCollection(expectedResults, SqlEndToEndTestSupport.collectResult(result));
    }

    @Nonnull
    protected static ArrayList<SqlTestSupport.Row> collectResult(SqlResult result) {
        ArrayList<SqlTestSupport.Row> actualRows = new ArrayList<SqlTestSupport.Row>();
        for (SqlRow r : result) {
            actualRows.add(new SqlTestSupport.Row(r));
        }
        return actualRows;
    }

    @Nonnull
    protected ObjectAssert<DAG> assertThatDag() {
        return Assertions.assertThat((Object)this.sqlJobInvocationObserver.dag);
    }

    protected void assertInvokedOnlyOnMembers(HazelcastInstance ... members) {
        Set expectedMembers = Arrays.stream(members).map(Accessors::getAddress).collect(Collectors.toSet());
        Assert.assertEquals(expectedMembers, this.jobInvocationObserver.getMembers());
    }

    protected void configureMapWithAttributes(String mapName, String ... attributes) {
        MapConfig mc = new MapConfig(mapName);
        for (String attribute : attributes) {
            mc.getPartitioningAttributeConfigs().add(new PartitioningAttributeConfig(attribute));
        }
        SqlEndToEndTestSupport.instance().getConfig().addMapConfig(mc);
    }

    static Tuple2<Set<Address>, Set<Integer>> calculateExpectedPartitions(NodeEngine nodeEngine, Map<Address, int[]> partitionAssignment, boolean shouldUseCoordinator, int arity, int ... partitionedPredicateConstants) {
        HazelcastInstance hz = nodeEngine.getHazelcastInstance();
        PartitionService partitionService = hz.getPartitionService();
        HashMap<Integer, Address> reversedPartitionAssignment = new HashMap<Integer, Address>();
        for (Map.Entry<Address, int[]> entry : partitionAssignment.entrySet()) {
            for (int partitionId : entry.getValue()) {
                reversedPartitionAssignment.put(partitionId, entry.getKey());
            }
        }
        HashSet<Integer> expectedPartitionsToParticipate = new HashSet<Integer>();
        HashSet<Address> expectedMembersToParticipate = new HashSet<Address>();
        for (int equalityConstants : partitionedPredicateConstants) {
            Object[] constants = new Object[arity];
            Arrays.fill(constants, (Object)equalityConstants);
            Data keyData = nodeEngine.getSerializationService().toData(PartitioningStrategyUtil.constructAttributeBasedKey((Object[])constants), (PartitioningStrategy & Serializable)v -> v);
            int partitionId = nodeEngine.getPartitionService().getPartitionId(keyData);
            Assert.assertTrue((boolean)reversedPartitionAssignment.containsKey(partitionId));
            expectedPartitionsToParticipate.add(partitionId);
            expectedMembersToParticipate.add((Address)reversedPartitionAssignment.get(partitionId));
        }
        if (shouldUseCoordinator) {
            expectedMembersToParticipate.add(hz.getCluster().getLocalMember().getAddress());
            expectedPartitionsToParticipate.add(partitionService.getPartition((Object)"").getPartitionId());
        }
        return Tuple2.tuple2(expectedMembersToParticipate, expectedPartitionsToParticipate);
    }

    protected static class SqlJobInvocationObserverImpl
    implements SqlJobInvocationObserver {
        public DAG dag;
        public JobConfig jobConfig;

        protected SqlJobInvocationObserverImpl() {
        }

        public void onJobInvocation(DAG dag, JobConfig config) {
            this.dag = dag;
            this.jobConfig = config;
        }
    }

    protected static class JobInvocationObserverImpl
    implements JobInvocationObserver {
        public long jobId;
        public Set<MemberInfo> members;
        public DAG dag;
        public JobConfig jobConfig;

        protected JobInvocationObserverImpl() {
        }

        public void onJobInvocation(long jobId, Map<MemberInfo, ExecutionPlan> planMap, DAG dag, JobConfig jobConfig) {
            this.jobId = jobId;
            this.members = planMap.keySet();
            this.dag = dag;
            this.jobConfig = jobConfig;
        }

        public void onLightJobInvocation(long jobId, Set<MemberInfo> members, DAG dag, JobConfig jobConfig) {
            this.jobId = jobId;
            this.members = members;
            this.dag = dag;
            this.jobConfig = jobConfig;
        }

        public Set<Address> getMembers() {
            return this.members.stream().map(MemberInfo::getAddress).collect(Collectors.toSet());
        }
    }
}

