/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.SimpleTestInClusterSupport;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.sql.impl.PlanExecutor;
import com.hazelcast.jet.sql.impl.SqlPlanImpl;
import com.hazelcast.jet.sql.impl.schema.TableResolverImpl;
import com.hazelcast.mock.MockUtil;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.optimizer.PlanKey;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.security.NoOpSqlSecurityContext;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import com.hazelcast.sql.impl.state.QueryResultRegistry;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.Subject;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnitParamsRunner.class)
public class PlanExecutorTest
extends SimpleTestInClusterSupport {
    private PlanExecutor planExecutor;
    @Mock
    private TableResolverImpl catalog;
    @Mock
    private HazelcastInstance hazelcastInstance;
    @Mock
    private NodeEngine nodeEngine;
    @Mock
    private AbstractJetInstance<?> jetInstance;
    @Mock
    private DAG dag;
    @Mock
    private Job job;
    private AutoCloseable openMocks;

    @Before
    public void setUp() {
        this.openMocks = MockitoAnnotations.openMocks((Object)((Object)this));
        BDDMockito.given((Object)this.job.getFuture()).willReturn(new CompletableFuture());
        BDDMockito.given((Object)this.nodeEngine.getHazelcastInstance()).willReturn((Object)this.hazelcastInstance);
        this.planExecutor = new PlanExecutor(this.nodeEngine, this.catalog, null, (QueryResultRegistry)Mockito.mock(QueryResultRegistry.class));
    }

    @After
    public void cleanUp() {
        MockUtil.closeMocks((AutoCloseable)this.openMocks);
    }

    @Test
    @Parameters(value={"true, false", "false, true"})
    public void test_createMappingExecution(boolean replace, boolean ifNotExists) {
        Mapping mapping = PlanExecutorTest.mapping();
        SqlPlanImpl.CreateMappingPlan plan = new SqlPlanImpl.CreateMappingPlan(PlanExecutorTest.planKey(), mapping, replace, ifNotExists, this.planExecutor);
        SqlResult result = this.planExecutor.execute(plan, null);
        Assertions.assertThat((long)result.updateCount()).isEqualTo(0L);
        ((TableResolverImpl)Mockito.verify((Object)this.catalog)).createMapping(mapping, replace, ifNotExists, null);
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_dropMappingExecution(boolean ifExists) {
        String name = "name";
        SqlPlanImpl.DropMappingPlan plan = new SqlPlanImpl.DropMappingPlan(PlanExecutorTest.planKey(), name, ifExists, this.planExecutor);
        SqlResult result = this.planExecutor.execute(plan);
        Assertions.assertThat((long)result.updateCount()).isEqualTo(0L);
        ((TableResolverImpl)Mockito.verify((Object)this.catalog)).removeMapping(name, ifExists);
    }

    @Test
    public void test_insertExecution() {
        QueryId queryId = QueryId.create((UUID)UuidUtil.newSecureUUID());
        SqlPlanImpl.DmlPlan plan = new SqlPlanImpl.DmlPlan(TableModify.Operation.INSERT, PlanExecutorTest.planKey(), QueryParameterMetadata.EMPTY, Collections.emptySet(), this.dag, null, false, this.planExecutor, Collections.emptyList(), false, null);
        BDDMockito.given((Object)this.hazelcastInstance.getJet()).willReturn(this.jetInstance);
        BDDMockito.given((Object)this.jetInstance.newLightJob((DAG)ArgumentMatchers.eq((Object)this.dag), (JobConfig)ArgumentMatchers.isA(JobConfig.class), (Subject)ArgumentMatchers.eq(null))).willReturn((Object)this.job);
        SqlResult result = this.planExecutor.execute(plan, queryId, Collections.emptyList(), 0L, (SqlSecurityContext)NoOpSqlSecurityContext.INSTANCE);
        Assertions.assertThat((long)result.updateCount()).isEqualTo(0L);
        ((Job)Mockito.verify((Object)this.job)).join();
    }

    private static PlanKey planKey() {
        return new PlanKey(Collections.emptyList(), "");
    }

    private static Mapping mapping() {
        return new Mapping("name", "name", null, "type", null, Collections.emptyList(), Collections.emptyMap());
    }
}

