/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlViewPlanInvalidationTest
extends SqlTestSupport {
    public static final String FIRST_MAP_NAME = "m_one";
    public static final String SECOND_MAP_NAME = "m_two";
    public static final int FIRST_MAP_VALUE = 1;
    public static final int SECOND_MAP_VALUE = 2;
    public static final String FIRST_LITERAL = "hello";
    public static final String SECOND_LITERAL = "world";

    @BeforeClass
    public static void initialize() {
        SqlViewPlanInvalidationTest.initialize((int)1, null);
    }

    @Test
    public void when_changingViewDefinitionWithLiteral_then_newViewDefinitionIsUsed() {
        SqlViewPlanInvalidationTest.instance().getSql().execute("CREATE OR REPLACE VIEW v1 AS SELECT 'hello'", new Object[0]);
        SqlViewPlanInvalidationTest.assertRowsAnyOrder("SELECT * FROM v1", SqlViewPlanInvalidationTest.rows(1, FIRST_LITERAL));
        SqlViewPlanInvalidationTest.instance().getSql().execute("CREATE OR REPLACE VIEW v1 AS SELECT 'world'", new Object[0]);
        SqlViewPlanInvalidationTest.assertTrueEventually(() -> SqlViewPlanInvalidationTest.assertRowsAnyOrder("SELECT * FROM v1", SqlViewPlanInvalidationTest.rows(1, SECOND_LITERAL)));
    }

    @Test
    public void when_changingViewDefinitionWithIMap_then_newViewDefinitionIsUsed() {
        SqlViewPlanInvalidationTest.instance().getMap(FIRST_MAP_NAME).put((Object)"key", (Object)1);
        SqlViewPlanInvalidationTest.instance().getMap(SECOND_MAP_NAME).put((Object)"key", (Object)2);
        SqlViewPlanInvalidationTest.createMapping(FIRST_MAP_NAME, String.class, Integer.class);
        SqlViewPlanInvalidationTest.createMapping(SECOND_MAP_NAME, String.class, Integer.class);
        SqlViewPlanInvalidationTest.instance().getSql().execute("CREATE OR REPLACE VIEW v1 AS SELECT this from m_one", new Object[0]);
        SqlViewPlanInvalidationTest.assertRowsAnyOrder("SELECT * FROM v1", SqlViewPlanInvalidationTest.rows(1, 1));
        SqlViewPlanInvalidationTest.instance().getSql().execute("CREATE OR REPLACE VIEW v1 AS SELECT this from m_two", new Object[0]);
        SqlViewPlanInvalidationTest.assertTrueEventually(() -> SqlViewPlanInvalidationTest.assertRowsAnyOrder("SELECT * FROM v1", SqlViewPlanInvalidationTest.rows(1, 2)));
    }

    @Test
    public void when_changingInnerViewDefinitionWithNestedViews_then_newViewDefinitionIsUsed() {
        SqlViewPlanInvalidationTest.instance().getSql().execute("CREATE OR REPLACE VIEW v1 AS SELECT 'hello'", new Object[0]);
        SqlViewPlanInvalidationTest.instance().getSql().execute("CREATE OR REPLACE VIEW v2 AS SELECT * FROM v1", new Object[0]);
        SqlViewPlanInvalidationTest.assertRowsAnyOrder("SELECT * FROM v2", SqlViewPlanInvalidationTest.rows(1, FIRST_LITERAL));
        SqlViewPlanInvalidationTest.instance().getSql().execute("CREATE OR REPLACE VIEW v1 AS SELECT 'world'", new Object[0]);
        SqlViewPlanInvalidationTest.assertTrueEventually(() -> SqlViewPlanInvalidationTest.assertRowsAnyOrder("SELECT * FROM v2", SqlViewPlanInvalidationTest.rows(1, SECOND_LITERAL)));
    }

    @Test
    public void when_changingOuterViewDefinitionWithNestedViews_then_newViewDefinitionIsUsed() {
        SqlViewPlanInvalidationTest.instance().getSql().execute("CREATE OR REPLACE VIEW v1 AS SELECT 'hello'", new Object[0]);
        SqlViewPlanInvalidationTest.instance().getSql().execute("CREATE OR REPLACE VIEW v2 AS SELECT 'world'", new Object[0]);
        SqlViewPlanInvalidationTest.instance().getSql().execute("CREATE OR REPLACE VIEW v3 AS SELECT * FROM v1", new Object[0]);
        SqlViewPlanInvalidationTest.assertRowsAnyOrder("SELECT * FROM v3", SqlViewPlanInvalidationTest.rows(1, FIRST_LITERAL));
        SqlViewPlanInvalidationTest.instance().getSql().execute("CREATE OR REPLACE VIEW v3 AS SELECT * FROM v2", new Object[0]);
        SqlViewPlanInvalidationTest.assertTrueEventually(() -> SqlViewPlanInvalidationTest.assertRowsAnyOrder("SELECT * FROM v2", SqlViewPlanInvalidationTest.rows(1, SECOND_LITERAL)));
    }
}

