/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestBatchSqlConnector;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.QueryException;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlUnsupportedFeaturesTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        SqlUnsupportedFeaturesTest.initialize((int)2, null);
        sqlService = SqlUnsupportedFeaturesTest.instance().getSql();
    }

    @Test
    public void test_fullJoin() {
        TestBatchSqlConnector.create(sqlService, "b", 0);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT 1 FROM b AS b1 FULL JOIN b AS b2 ON b1.v = b2.v", new Object[0])).hasCauseInstanceOf(QueryException.class).hasMessageContaining("FULL join not supported");
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT 1 FROM b AS b1 FULL OUTER JOIN b AS b2 ON b1.v = b2.v", new Object[0])).hasCauseInstanceOf(QueryException.class).hasMessageContaining("FULL join not supported");
    }

    @Test
    public void test_multiFullJoin() {
        TestBatchSqlConnector.create(sqlService, "b", 0);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT 1 FROM b AS b1 JOIN b AS b2 ON b1.v = b2.v FULL OUTER JOIN b AS b3 ON b2.v = b3.v", new Object[0])).hasCauseInstanceOf(QueryException.class).hasMessageContaining("FULL join not supported");
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT 1 FROM b AS b1 JOIN b AS b2 ON b1.v = b2.v FULL JOIN b AS b3 ON b2.v = b3.v", new Object[0])).hasCauseInstanceOf(QueryException.class).hasMessageContaining("FULL join not supported");
    }

    @Test
    public void test_mapValueConstructor() {
        TestBatchSqlConnector.create(sqlService, "b", 1);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT MAP[1, 2] FROM b", new Object[0])).hasMessageContaining("MAP VALUE CONSTRUCTOR not supported");
    }

    @Test
    public void test_insert() {
        TestBatchSqlConnector.create(sqlService, "b", 1);
        Assertions.assertThatThrownBy(() -> sqlService.execute("INSERT INTO b VALUES(1)", new Object[0])).hasMessageContaining("INSERT INTO not supported for TestBatch");
    }

    @Test
    public void test_sink() {
        TestBatchSqlConnector.create(sqlService, "b", 1);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SINK INTO b VALUES(1)", new Object[0])).hasMessageContaining("SINK INTO not supported for TestBatch");
    }

    @Test
    public void test_update_noPrimaryKey() {
        TestBatchSqlConnector.create(sqlService, "b", 1);
        Assertions.assertThatThrownBy(() -> sqlService.execute("UPDATE b SET v = 1", new Object[0])).hasMessageContaining("PRIMARY KEY not supported by connector: TestBatch");
    }

    @Test
    public void test_update_fromSelect() {
        SqlUnsupportedFeaturesTest.createMapping("m1", Integer.TYPE, Integer.TYPE);
        SqlUnsupportedFeaturesTest.instance().getMap("m1").put((Object)1, (Object)1);
        SqlUnsupportedFeaturesTest.createMapping("m2", Integer.TYPE, Integer.TYPE);
        SqlUnsupportedFeaturesTest.instance().getMap("m2").put((Object)1, (Object)2);
        Assertions.assertThatThrownBy(() -> sqlService.execute("UPDATE m1 SET __key = (select m2.this from m2 WHERE m1.__key = m2.__key)", new Object[0])).hasMessageContaining("UPDATE FROM SELECT not supported");
    }

    @Test
    public void test_delete_noPrimaryKey() {
        TestBatchSqlConnector.create(sqlService, "b", 1);
        Assertions.assertThatThrownBy(() -> sqlService.execute("DELETE FROM b WHERE v=1", new Object[0])).hasMessageContaining("PRIMARY KEY not supported by connector: TestBatch");
    }

    @Test
    public void test_upsert() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("UPSERT INTO foo VALUES(1, 2, 3)", new Object[0])).hasMessageEndingWith("UPSERT is not supported");
    }
}

