/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlTestSupportTest
extends SqlTestSupport {
    @Parameterized.Parameter
    public boolean useClient;

    @Parameterized.Parameters(name="useClient={0}")
    public static Collection<Object> data() {
        return Arrays.asList(false, true);
    }

    @Before
    public void before() {
        if (this.useClient) {
            SqlTestSupportTest.initializeWithClient((int)1, null, null);
        } else {
            SqlTestSupportTest.initialize((int)1, null);
        }
    }

    @After
    public void after() throws Exception {
        this.tearDown();
        this.supportAfter();
        SqlTestSupportTest.supportAfterClass();
    }

    private HazelcastInstance hz() {
        return this.useClient ? SqlTestSupportTest.client() : SqlTestSupportTest.instance();
    }

    @Test
    public void mappingShouldNotBeVisibleAfterFirstRestart() {
        this.createMapping();
        this.supportAfter();
        this.mappingDoesNotExist();
    }

    @Test
    public void mappingShouldNotBeVisibleAfterSecondRestart() {
        this.createMapping();
        this.supportAfter();
        this.createMapping();
        this.supportAfter();
        this.mappingDoesNotExist();
    }

    private void createMapping() {
        String sqlCreateMapping = String.format("CREATE MAPPING mymap (__key BIGINT, this VARCHAR) TYPE IMap OPTIONS('keyFormat' = 'bigint', 'valueFormat' = 'varchar')", new Object[0]);
        this.hz().getSql().execute(sqlCreateMapping, new Object[0]);
    }

    private void mappingDoesNotExist() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.hz().getSql().execute("select * from mymap", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Object 'mymap' not found, did you forget to CREATE MAPPING?");
    }
}

