/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.util.RuntimeAvailableProcessors;
import com.hazelcast.jet.sql.SqlBasicTest;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlOrderByTest
extends HazelcastTestSupport {
    private static final String MAP_OBJECT = "map_object";
    private static final String MAP_BINARY = "map_binary";
    private static final int DATA_SET_SIZE = 1024;
    private static final int DATA_SET_MAX_POSITIVE = 512;
    private static final int TEST_OFFSET = 1018;
    protected HazelcastInstance[] members;
    @Parameterized.Parameter
    public SqlBasicTest.SerializationMode serializationMode;
    @Parameterized.Parameter(value=1)
    public InMemoryFormat inMemoryFormat;
    @Parameterized.Parameter(value=2)
    public int membersCount;
    private static final int FETCH_SIZE_HINT = 128;
    private static final int BATCH_FETCH_DATA_SIZE = 257;

    @Parameterized.Parameters(name="serializationMode:{0}, inMemoryFormat:{1}, membersCount:{2}")
    public static Collection<Object[]> parameters() {
        return Collections.singletonList(new Object[]{SqlBasicTest.SerializationMode.SERIALIZABLE, InMemoryFormat.OBJECT, 1});
    }

    @Before
    public void before() {
        TestHazelcastInstanceFactory factory = this.createHazelcastInstanceFactory();
        this.members = new HazelcastInstance[this.membersCount];
        for (int i = 0; i < this.membersCount; ++i) {
            this.members[i] = factory.newHazelcastInstance(this.memberConfig());
        }
        if (this.isPortable()) {
            SqlTestSupport.createMapping(this.members[0], this.mapName(), 1, 2, 0, 1, 3, 0);
        } else {
            SqlTestSupport.createMapping(this.members[0], this.mapName(), this.keyClass(), this.valueClass());
        }
        IMap map = this.getTarget().getMap(this.mapName());
        HashMap<SqlBasicTest.AbstractPojoKey, SqlBasicTest.AbstractPojo> data = new HashMap<SqlBasicTest.AbstractPojoKey, SqlBasicTest.AbstractPojo>();
        ThreadLocalRandom r = ThreadLocalRandom.current();
        int nextNullValue = Math.max(1, ((Random)r).nextInt(5));
        int nextSameValues = Math.max(1, ((Random)r).nextInt(5));
        long idx = Math.negateExact(512);
        int skipFirstPositiveEntries = 20;
        while (idx < 512L) {
            if (idx % (long)nextNullValue == 0L && idx >= (long)skipFirstPositiveEntries) {
                data.put(this.key(idx++), this.value());
                nextNullValue = Math.max(1, ((Random)r).nextInt(5));
                continue;
            }
            if (idx % (long)nextSameValues == 0L && idx >= (long)skipFirstPositiveEntries) {
                long value = idx;
                for (int sameValuesCount = ((Random)r).nextInt(5); sameValuesCount > 0 && idx < 512L; --sameValuesCount) {
                    data.put(this.key(idx++), this.value(value));
                }
                nextSameValues = Math.max(1, ((Random)r).nextInt(5));
                continue;
            }
            data.put(this.key(idx), this.value(idx));
            ++idx;
        }
        map.putAll(data);
        HashMap<SqlBasicTest.AbstractPojoKey, SqlBasicTest.AbstractPojo> stableData = new HashMap<SqlBasicTest.AbstractPojoKey, SqlBasicTest.AbstractPojo>();
        for (idx = 0L; idx < 1024L; ++idx) {
            stableData.put(this.key(idx), this.value(idx));
        }
        if (this.isPortable()) {
            SqlTestSupport.createMapping(this.members[0], this.stableMapName(), 1, 3, 0, 1, 3, 0);
        } else {
            SqlTestSupport.createMapping(this.members[0], this.stableMapName(), this.keyClass(), this.valueClass());
        }
        IMap stableMap = this.getTarget().getMap(this.stableMapName());
        stableMap.putAll(stableData);
    }

    protected Config memberConfig() {
        Config config = new Config().setSerializationConfig(SqlBasicTest.serializationConfig());
        config.getJetConfig().setEnabled(true);
        config.addMapConfig(new MapConfig(MAP_OBJECT).setInMemoryFormat(InMemoryFormat.OBJECT)).addMapConfig(new MapConfig(MAP_BINARY).setInMemoryFormat(InMemoryFormat.BINARY));
        return config;
    }

    protected HazelcastInstance getTarget() {
        return this.members[0];
    }

    protected String stableMapName() {
        return this.inMemoryFormat == InMemoryFormat.OBJECT ? "map_object_stable" : "map_binary_stable";
    }

    @Test
    public void testSelectWithOrderByDesc() {
        this.checkSelectWithOrderBy(Collections.singletonList("intVal"), Collections.singletonList("intVal"), Collections.singletonList(true));
    }

    @Test
    public void testSelectWithOrderByAsc() {
        this.checkSelectWithOrderBy(Collections.singletonList("intVal"), Collections.singletonList("intVal"), Collections.singletonList(false));
    }

    @Test
    public void testSelectWithOrderByDefault() {
        this.checkSelectWithOrderBy(Collections.singletonList("intVal"), Collections.singletonList("intVal"), Collections.singletonList(null));
    }

    @Test
    public void testSelectWithOrderByDefaultAllTypes() {
        List<String> fields = Arrays.asList("booleanVal", "tinyIntVal", "smallIntVal", "intVal", "bigIntVal", "realVal", "doubleVal", "decimalBigIntegerVal", "decimalVal", "charVal", "varcharVal");
        ArrayList<Boolean> orderDirections = new ArrayList<Boolean>(fields.size());
        fields.forEach(entry -> orderDirections.add(true));
        this.checkSelectWithOrderBy(fields, fields, orderDirections);
    }

    @Test
    public void testSelectWithOrderByDefaultTemporalTypes() {
        List<String> fields = Arrays.asList("dateVal", "timeVal", "timestampVal", "tsTzOffsetDateTimeVal");
        ArrayList<Boolean> orderDirections = new ArrayList<Boolean>(fields.size());
        fields.forEach(entry -> orderDirections.add(true));
        this.checkSelectWithOrderBy(fields, fields, orderDirections);
    }

    @Test
    public void testSelectWithOrderByDescDesc() {
        this.checkSelectWithOrderBy(Arrays.asList("intVal", "varcharVal"), Arrays.asList("intVal", "varcharVal"), Arrays.asList(true, true));
    }

    @Test
    public void testSelectWithOrderByAscDesc() {
        this.checkSelectWithOrderBy(Arrays.asList("intVal", "varcharVal"), Arrays.asList("intVal", "varcharVal"), Arrays.asList(false, true));
    }

    @Test
    public void testSelectWithOrderByDescDescDesc() {
        this.checkSelectWithOrderBy(Arrays.asList("intVal", "varcharVal", "bigIntVal"), Arrays.asList("intVal", "varcharVal", "bigIntVal"), Arrays.asList(true, true, true));
    }

    @Test
    public void testSelectWithOrderByDescDescAsc() {
        this.checkSelectWithOrderBy(Arrays.asList("intVal", "varcharVal", "bigIntVal"), Arrays.asList("intVal", "varcharVal", "bigIntVal"), Arrays.asList(true, true, false));
    }

    @Test
    public void testSelectWithOrderByAndProject() {
        String sql = this.sqlWithOrderBy(Arrays.asList("intVal", "intVal + bigIntVal"), Arrays.asList("intVal", "bigIntVal"), Arrays.asList(true, true));
        this.checkSelectWithOrderBy(Arrays.asList("intVal", "bigIntVal"), sql, Collections.singletonList("intVal"), Collections.singletonList(true));
    }

    @Test
    public void testSelectWithOrderByAndProject2() {
        String sql = String.format("SELECT a, b FROM (SELECT intVal+bigIntVal a, intVal-bigIntVal b FROM %s) ORDER BY a, b", this.mapName());
        this.checkSelectWithOrderBy(Arrays.asList("intVal", "bigIntVal"), sql, Collections.emptyList(), Collections.emptyList());
    }

    @Test
    public void testSelectWithOrderByAndWhere() {
        this.getTarget().getMap(this.mapName());
        String intValField = "intVal";
        String realValField = "realVal";
        this.addIndex(Collections.singletonList(intValField), IndexType.SORTED);
        this.addIndex(Collections.singletonList(realValField), IndexType.SORTED);
        String sql = "SELECT " + intValField + ", " + realValField + " FROM " + this.mapName() + " WHERE " + intValField + " = 1 ORDER BY " + realValField;
        this.assertSqlResultOrdered(sql, Collections.singletonList(realValField), Collections.singletonList(false), 1);
    }

    @Test
    public void testSelectWithOrderByAndWhereNotIndexedField() {
        this.getTarget().getMap(this.mapName());
        String intValField = "intVal";
        String realValField = "realVal";
        this.addIndex(Collections.singletonList(realValField), IndexType.SORTED);
        String sql = "SELECT " + intValField + ", " + realValField + " FROM " + this.mapName() + " WHERE " + intValField + " = 1 ORDER BY " + realValField;
        this.assertSqlResultOrdered(sql, Collections.singletonList(realValField), Collections.singletonList(false), 1);
    }

    @Test
    public void testSelectWithOrderByAndWhere2Conditions() {
        this.getTarget().getMap(this.mapName());
        String intValField = "intVal";
        String realValField = "realVal";
        this.addIndex(Arrays.asList(intValField, realValField), IndexType.SORTED);
        String sql = "SELECT " + intValField + ", " + realValField + " FROM " + this.mapName() + " WHERE " + intValField + " = 1 AND " + realValField + " = 1 ORDER BY " + intValField;
        this.assertSqlResultOrdered(sql, Collections.singletonList(realValField), Collections.singletonList(false), 1);
    }

    @Test
    public void testSelectWithOrderBy2FieldsAndWhere1Conditions() {
        this.getTarget().getMap(this.mapName());
        String intValField = "intVal";
        String realValField = "realVal";
        this.addIndex(Arrays.asList(intValField, realValField), IndexType.SORTED);
        String sql = "SELECT " + intValField + ", " + realValField + " FROM " + this.mapName() + " WHERE " + intValField + " = 1 ORDER BY " + intValField + ", " + realValField;
        this.assertSqlResultOrdered(sql, Collections.singletonList(realValField), Collections.singletonList(false), 1);
    }

    @Test
    public void testSelectWithOrderBy2FieldsAndWhere2Conditions() {
        this.getTarget().getMap(this.mapName());
        String intValField = "intVal";
        String realValField = "realVal";
        this.addIndex(Arrays.asList(intValField, realValField), IndexType.SORTED);
        String sql = "SELECT " + intValField + ", " + realValField + " FROM " + this.mapName() + " WHERE " + intValField + " = 1 AND " + realValField + " = 1 ORDER BY " + intValField + ", " + realValField;
        this.assertSqlResultOrdered(sql, Collections.singletonList(realValField), Collections.singletonList(false), 1);
    }

    @Test
    public void testSelectWithOrderByAndWhere2ConditionsHashIndex() {
        this.getTarget().getMap(this.mapName());
        String intValField = "intVal";
        String realValField = "realVal";
        this.addIndex(Arrays.asList(intValField, realValField), IndexType.HASH);
        this.addIndex(Collections.singletonList(intValField), IndexType.SORTED);
        String sql = "SELECT " + intValField + ", " + realValField + " FROM " + this.mapName() + " WHERE " + intValField + " = 1 AND " + realValField + " = 1 ORDER BY " + intValField;
        this.assertSqlResultOrdered(sql, Collections.singletonList(realValField), Collections.singletonList(false), 1);
    }

    @Test
    public void testSelectWithOrderByAndFetchOffset() {
        String intValField = "intVal";
        this.addIndex(Collections.singletonList(intValField), IndexType.SORTED, this.stableMapName());
        String sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " ORDER BY " + intValField + " OFFSET 5 ROWS FETCH FIRST 10 ROWS ONLY";
        this.assertSqlResultOrdered(sql, Collections.singletonList(intValField), Collections.singletonList(false), 10, 5, 14);
        String sqlLimit = "SELECT " + intValField + " FROM " + this.stableMapName() + " ORDER BY " + intValField + " LIMIT 10 OFFSET 5 ROWS";
        this.assertSqlResultOrdered(sqlLimit, Collections.singletonList(intValField), Collections.singletonList(false), 10, 5, 14);
    }

    @Test
    public void testSelectWithOrderByAndFetchOffsetNoResult() {
        String intValField = "intVal";
        this.addIndex(Collections.singletonList(intValField), IndexType.SORTED, this.stableMapName());
        String sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " ORDER BY " + intValField + " OFFSET 4096 ROWS FETCH FIRST 10 ROWS ONLY";
        this.assertSqlResultOrdered(sql, Collections.singletonList(intValField), Collections.singletonList(false), 0, 0, 0);
        String sqlLimit = "SELECT " + intValField + " FROM " + this.stableMapName() + " ORDER BY " + intValField + " LIMIT 10 OFFSET 4096 ROWS";
        this.assertSqlResultOrdered(sqlLimit, Collections.singletonList(intValField), Collections.singletonList(false), 0, 0, 0);
    }

    @Test
    public void testSelectWithOrderByAndFetchOffsetTail() {
        String intValField = "intVal";
        this.addIndex(Collections.singletonList(intValField), IndexType.SORTED, this.stableMapName());
        String sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " ORDER BY " + intValField + " OFFSET 1018 ROWS FETCH FIRST 10 ROWS ONLY";
        String sqlLimit = "SELECT " + intValField + " FROM " + this.stableMapName() + " ORDER BY " + intValField + " LIMIT 10 OFFSET 1018  ROWS";
        this.assertSqlResultOrdered(sql, Collections.singletonList(intValField), Collections.singletonList(false), 6, 1018, 1023);
        this.assertSqlResultOrdered(sqlLimit, Collections.singletonList(intValField), Collections.singletonList(false), 6, 1018, 1023);
    }

    @Test
    public void testSelectFetchOffsetOnly() {
        String intValField = "intVal";
        this.addIndex(Collections.singletonList(intValField), IndexType.SORTED, this.stableMapName());
        String sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " OFFSET 1018  ROWS FETCH FIRST 10 ROWS ONLY";
        this.assertSqlResultCount(sql, 6);
        sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " LIMIT 10 OFFSET 1018  ROWS";
        this.assertSqlResultCount(sql, 6);
        sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " OFFSET 10 ROWS FETCH FIRST 10 ROWS ONLY";
        this.assertSqlResultCount(sql, 10);
        sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " LIMIT 10 OFFSET 10 ROWS";
        this.assertSqlResultCount(sql, 10);
        sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " OFFSET 10 ROWS";
        this.assertSqlResultCount(sql, 1014);
        sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " OFFSET 1024 ROWS";
        this.assertSqlResultCount(sql, 0);
        sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " FETCH FIRST 0 ROWS ONLY";
        this.assertSqlResultCount(sql, 0);
        sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " LIMIT 0";
        this.assertSqlResultCount(sql, 0);
        sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " FETCH FIRST 100 ROWS ONLY";
        this.assertSqlResultCount(sql, 100);
        sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " LIMIT 100";
        this.assertSqlResultCount(sql, 100);
        sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " FETCH FIRST 2.9 ROWS ONLY";
        this.assertSqlResultCount(sql, 2);
        sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " LIMIT 2.9";
        this.assertSqlResultCount(sql, 2);
        sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " FETCH FIRST 1.2E2 ROWS ONLY";
        this.assertSqlResultCount(sql, 120);
        sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " LIMIT 1.2E2";
        this.assertSqlResultCount(sql, 120);
        sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " FETCH FIRST 1.2E-2 ROWS ONLY";
        this.assertSqlResultCount(sql, 0);
        sql = "SELECT " + intValField + " FROM " + this.stableMapName() + " LIMIT 1.2E-2";
        this.assertSqlResultCount(sql, 0);
    }

    @Test
    public void testSelectFetchOffsetInvalid() {
        String intValField = "intVal";
        this.addIndex(Collections.singletonList(intValField), IndexType.SORTED, this.stableMapName());
        String sql1 = "SELECT " + intValField + " FROM " + this.stableMapName() + " OFFSET -5 ROWS FETCH FIRST 10 ROWS ONLY";
        SqlOrderByTest.assertThrows(HazelcastSqlException.class, () -> this.query(sql1));
        String sqlLimit1 = "SELECT " + intValField + " FROM " + this.stableMapName() + " LIMIT 10 OFFSET -5 ROWS";
        SqlOrderByTest.assertThrows(HazelcastSqlException.class, () -> this.query(sqlLimit1));
        String sql2 = "SELECT " + intValField + " FROM " + this.stableMapName() + " OFFSET 5 ROWS FETCH FIRST -10 ROWS ONLY";
        SqlOrderByTest.assertThrows(HazelcastSqlException.class, () -> this.query(sql2));
        String sqlLimit2 = "SELECT " + intValField + " FROM " + this.stableMapName() + " LIMIT -10 OFFSET 5 ROWS";
        SqlOrderByTest.assertThrows(HazelcastSqlException.class, () -> this.query(sqlLimit2));
        String sql3 = "SELECT " + intValField + " FROM " + this.stableMapName() + " OFFSET \"\" ROWS";
        SqlOrderByTest.assertThrows(HazelcastSqlException.class, () -> this.query(sql3));
        String sql4 = "SELECT " + intValField + " FROM " + this.stableMapName() + " OFFSET intVal ROWS";
        SqlOrderByTest.assertThrows(HazelcastSqlException.class, () -> this.query(sql4));
        String sql5 = "SELECT " + intValField + " FROM " + this.stableMapName() + " FETCH FIRST \"\" ROWS ONLY";
        SqlOrderByTest.assertThrows(HazelcastSqlException.class, () -> this.query(sql5));
        String sqlLimit5 = "SELECT " + intValField + " FROM " + this.stableMapName() + " LIMIT \"\"";
        SqlOrderByTest.assertThrows(HazelcastSqlException.class, () -> this.query(sqlLimit5));
        String sql6 = "SELECT " + intValField + " FROM " + this.stableMapName() + " FETCH FIRST null ROWS ONLY";
        SqlOrderByTest.assertThrows(HazelcastSqlException.class, () -> this.query(sql6));
        String sqlLimit6 = "SELECT " + intValField + " FROM " + this.stableMapName() + " LIMIT null";
        SqlOrderByTest.assertThrows(HazelcastSqlException.class, () -> this.query(sqlLimit6));
        String sql7 = "SELECT " + intValField + " FROM " + this.stableMapName() + " FETCH FIRST \"abc\" ROWS ONLY";
        SqlOrderByTest.assertThrows(HazelcastSqlException.class, () -> this.query(sql7));
        String sqlLimit7 = "SELECT " + intValField + " FROM " + this.stableMapName() + " LIMIT \"abc\"";
        SqlOrderByTest.assertThrows(HazelcastSqlException.class, () -> this.query(sqlLimit7));
        String sql8 = "SELECT " + intValField + " FROM " + this.stableMapName() + " FETCH FIRST 1 + ? ROWS ONLY";
        SqlOrderByTest.assertThrows(HazelcastSqlException.class, () -> this.query(sql8));
        String sqlLimit8 = "SELECT " + intValField + " FROM " + this.stableMapName() + " LIMIT 1 + ?";
        SqlOrderByTest.assertThrows(HazelcastSqlException.class, () -> this.query(sqlLimit8));
    }

    @Test
    public void testNestedFetchOffsetNotSupported() {
        String sql = "SELECT intVal FROM ( SELECT intVal FROM " + this.stableMapName() + " FETCH FIRST 5 ROWS ONLY)";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.query(sql)).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("FETCH/OFFSET is only supported for the top-level SELECT");
        String sqlLimit = "SELECT intVal FROM ( SELECT intVal FROM " + this.stableMapName() + " LIMIT 1)";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.query(sqlLimit)).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("FETCH/OFFSET is only supported for the top-level SELECT");
    }

    @Test(timeout=600000L)
    public void testConcurrentPutAndOrderbyQueries() {
        IMap map = this.getTarget().getMap(this.stableMapName());
        IndexConfig indexConfig = new IndexConfig().setName("Index_" + SqlOrderByTest.randomName()).setType(IndexType.SORTED);
        indexConfig.addAttribute("intVal");
        map.addIndex(indexConfig);
        int threadsCount = RuntimeAvailableProcessors.get() - 2;
        ExecutorService executor = Executors.newFixedThreadPool(threadsCount);
        int keysPerThread = 5000;
        CountDownLatch latch = new CountDownLatch(threadsCount);
        AtomicReference exception = new AtomicReference();
        int i = 0;
        while (i < threadsCount) {
            int index = i++;
            executor.submit(() -> {
                try {
                    if (index < threadsCount / 2) {
                        int startingIndex = index * keysPerThread;
                        for (int n = 0; n < keysPerThread; ++n) {
                            long keyIndex = startingIndex + n;
                            this.getTarget().getMap(this.stableMapName()).put((Object)this.key(keyIndex), (Object)this.value(keyIndex));
                        }
                    } else {
                        for (int n = 0; n < 10; ++n) {
                            String sql = String.format("SELECT intVal, varcharVal FROM %s ORDER BY intVal", this.stableMapName());
                            this.assertSqlResultOrdered(sql, Collections.singletonList("intVal"), Collections.singletonList(false), -1);
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    exception.compareAndSet(null, t);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        SqlOrderByTest.assertOpenEventually((CountDownLatch)latch, (long)400L);
        Assert.assertNull(exception.get());
        executor.shutdownNow();
    }

    @Test(timeout=600000L)
    public void testConcurrentUpdateAndOrderbyQueries() {
        IMap map = this.getTarget().getMap(this.stableMapName());
        IndexConfig indexConfig = new IndexConfig().setName("Index_" + SqlOrderByTest.randomName()).setType(IndexType.SORTED);
        indexConfig.addAttribute("intVal");
        map.addIndex(indexConfig);
        int threadsCount = RuntimeAvailableProcessors.get() - 2;
        ExecutorService executor = Executors.newFixedThreadPool(threadsCount);
        int keysPerThread = 2500;
        CountDownLatch latch = new CountDownLatch(threadsCount);
        AtomicReference exception = new AtomicReference();
        for (long i = 0L; i < (long)(threadsCount * keysPerThread); ++i) {
            this.getTarget().getMap(this.stableMapName()).put((Object)this.key(i), (Object)this.value(i));
        }
        int i = 0;
        while (i < threadsCount) {
            int index = i++;
            executor.submit(() -> {
                try {
                    if (index < threadsCount / 2) {
                        int startingIndex = index * keysPerThread;
                        for (int n = 0; n < keysPerThread; ++n) {
                            int diff = ThreadLocalRandom.current().nextInt(10);
                            diff = ThreadLocalRandom.current().nextBoolean() ? diff : -diff;
                            long keyIndex = startingIndex + n;
                            long valueIndex = keyIndex + (long)diff;
                            this.getTarget().getMap(this.stableMapName()).put((Object)this.key(keyIndex), (Object)this.value(valueIndex));
                        }
                    } else {
                        for (int n = 0; n < 10; ++n) {
                            String sql = String.format("SELECT intVal, varcharVal FROM %s ORDER BY intVal", this.stableMapName());
                            this.assertSqlResultOrdered(sql, Collections.singletonList("intVal"), Collections.singletonList(false), -1);
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    exception.compareAndSet(null, t);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        SqlOrderByTest.assertOpenEventually((CountDownLatch)latch, (long)400L);
        Assert.assertNull(exception.get());
        executor.shutdownNow();
    }

    @Test
    public void testOrderBy_comparatorLength() {
        SqlTestSupport.createMapping(this.getTarget(), "strange", String.class, String.class);
        IMap map = this.getTarget().getMap("strange");
        map.addIndex(IndexType.SORTED, new String[]{"this"});
        for (int i = 0; i < 257; ++i) {
            char c = (char)(65 + i);
            map.put((Object)String.valueOf(c).repeat(259 - i), (Object)"value");
        }
        this.assertSqlResultUnique("select __key from strange where this='value' order by this", 257, true);
    }

    @Test
    public void testOrderBy_comparatorSerialized() {
        SqlTestSupport.createMapping(this.getTarget(), "strange", this.valueClass(), String.class);
        IMap map = this.getTarget().getMap("strange");
        map.addIndex(IndexType.SORTED, new String[]{"this"});
        for (int i = 0; i < 257; ++i) {
            SqlBasicTest.AbstractPojo key = this.value();
            key.intVal = i;
            key.varcharVal = i % 2 == 0 ? "s" : "llllllllllllllllllll";
            map.put((Object)key, (Object)"value");
        }
        this.assertSqlResultUnique("select intVal from strange where this='value' order by this", 257, true);
    }

    @Test
    public void testOrderBy_comparatorHeterogeneousConvertibleKey() {
        SqlTestSupport.createMapping(this.getTarget(), "strange", Long.class, this.valueClass());
        IMap map = this.getTarget().getMap("strange");
        map.addIndex(IndexType.SORTED, new String[]{"varcharVal"});
        for (int i = 0; i < 257; ++i) {
            SqlBasicTest.AbstractPojo value = this.value(null);
            value.intVal = i;
            value.varcharVal = "value";
            if (i % 2 == 0) {
                map.put((Object)i, (Object)value);
                continue;
            }
            map.put((Object)i, (Object)value);
        }
        this.assertSqlResultUnique("select intVal from strange where varcharVal='value' order by varcharVal", 257, true);
    }

    @Test
    public void testOrderBy_comparatorHeterogeneousObjectKey() {
        SqlTestSupport.createMapping(this.getTarget(), "strange", Object.class, String.class);
        IMap map = this.getTarget().getMap("strange");
        map.addIndex(IndexType.SORTED, new String[]{"this"});
        for (int i = 0; i < 257; ++i) {
            if (i % 2 == 0) {
                map.put((Object)i, (Object)"value");
                continue;
            }
            map.put((Object)i, (Object)"value");
        }
        this.assertSqlResultUnique("select __key from strange where this='value' order by this", 257, true);
    }

    private void addIndex(List<String> fieldNames, IndexType type) {
        this.addIndex(fieldNames, type, this.mapName());
    }

    private void addIndex(List<String> fieldNames, IndexType type, String mapName) {
        IMap map = this.getTarget().getMap(mapName);
        IndexConfig indexConfig = new IndexConfig().setName("Index_" + SqlOrderByTest.randomName()).setType(type);
        for (String fieldName : fieldNames) {
            indexConfig.addAttribute(fieldName);
        }
        map.addIndex(indexConfig);
    }

    protected void checkSelectWithOrderBy(List<String> indexAttrs, List<String> orderFields, List<Boolean> orderDirections) {
        IMap map = this.getTarget().getMap(this.mapName());
        IndexConfig indexConfig = new IndexConfig().setName("Index_" + SqlOrderByTest.randomName()).setType(IndexType.SORTED);
        for (String indexAttr : indexAttrs) {
            indexConfig.addAttribute(indexAttr);
        }
        if (!indexAttrs.isEmpty()) {
            map.addIndex(indexConfig);
        }
        Assert.assertEquals((long)1024L, (long)map.size());
        StringBuilder orders = new StringBuilder();
        for (int i = 0; i < orderFields.size(); ++i) {
            String orderField = orderFields.get(i);
            Boolean descending = orderDirections.get(i);
            orders.append(orderField);
            if (descending != null) {
                orders.append(descending != false ? " DESC " : " ASC ");
            }
            if (i >= orderFields.size() - 1) continue;
            orders.append(", ");
        }
        String sql = this.sqlWithOrderBy(orders.toString());
        this.assertSqlResultOrdered(sql, orderFields, orderDirections, map.size());
    }

    private void assertSqlResultOrdered(String sql, List<String> orderFields, List<Boolean> orderDirections, int expectedCount) {
        this.assertSqlResultOrdered(sql, orderFields, orderDirections, expectedCount, null, null);
    }

    private void assertSqlResultOrdered(String sql, List<String> orderFields, List<Boolean> orderDirections, int expectedCount, Integer low, Integer high) {
        try (SqlResult res = this.query(sql);){
            Object fieldValue;
            String fieldName;
            SqlRowMetadata rowMetadata = res.getRowMetadata();
            Iterator rowIterator = res.iterator();
            SqlRow prevRow = null;
            SqlRow lowRow = null;
            SqlRow highRow = null;
            int count = 0;
            while (rowIterator.hasNext()) {
                SqlRow row = (SqlRow)rowIterator.next();
                this.assertOrdered(prevRow, row, orderFields, orderDirections, rowMetadata);
                prevRow = row;
                if (++count == 1) {
                    lowRow = row;
                }
                if (rowIterator.hasNext()) continue;
                highRow = row;
            }
            if (expectedCount != -1) {
                Assert.assertEquals((long)expectedCount, (long)count);
            }
            if (lowRow != null && low != null) {
                fieldName = orderFields.get(0);
                fieldValue = lowRow.getObject(rowMetadata.findColumn(fieldName));
                Assert.assertEquals((Object)low, (Object)fieldValue);
            }
            if (highRow != null && high != null) {
                fieldName = orderFields.get(0);
                fieldValue = highRow.getObject(rowMetadata.findColumn(fieldName));
                Assert.assertEquals((Object)high, (Object)fieldValue);
            }
            SqlOrderByTest.assertThrows(NoSuchElementException.class, rowIterator::next);
            SqlOrderByTest.assertThrows(IllegalStateException.class, () -> ((SqlResult)res).iterator());
        }
    }

    private void assertSqlResultCount(String sql, int expectedCount) {
        this.assertSqlResultCount(sql, expectedCount, false);
    }

    private void assertSqlResultCount(String sql, int expectedCount, boolean stopEarly) {
        try (SqlResult res = this.query(sql);){
            Iterator rowIterator = res.iterator();
            int count = 0;
            while (rowIterator.hasNext()) {
                rowIterator.next();
                if (!stopEarly || ++count <= expectedCount) continue;
            }
            Assert.assertEquals((String)("Should return expected row count" + (stopEarly ? " (might stop before full result was obtained)" : "")), (long)expectedCount, (long)count);
            SqlOrderByTest.assertThrows(NoSuchElementException.class, rowIterator::next);
            SqlOrderByTest.assertThrows(IllegalStateException.class, () -> ((SqlResult)res).iterator());
        }
    }

    private void assertSqlResultUnique(String sql, int expectedCount, boolean stopEarly) {
        try (SqlResult res = this.query(sql);){
            Iterator rowIterator = res.iterator();
            ArrayList<Object> results = new ArrayList<Object>(expectedCount);
            boolean early = false;
            while (rowIterator.hasNext()) {
                results.add(((SqlRow)rowIterator.next()).getObject(0));
                if (!stopEarly || results.size() <= expectedCount) continue;
                early = true;
                break;
            }
            ((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat(results).as("Should return expected row count" + (early ? " (early stop)" : ""), new Object[0])).hasSize(expectedCount)).as("Should contain only unique elements", new Object[0])).doesNotHaveDuplicates();
        }
    }

    private void checkSelectWithOrderBy(List<String> indexAttrs, String sql, List<String> checkOrderFields, List<Boolean> orderDirections) {
        IMap map = this.getTarget().getMap(this.mapName());
        IndexConfig indexConfig = new IndexConfig().setName("Index_" + SqlOrderByTest.randomName()).setType(IndexType.SORTED);
        for (String indexAttr : indexAttrs) {
            indexConfig.addAttribute(indexAttr);
        }
        map.addIndex(indexConfig);
        Assert.assertEquals((long)1024L, (long)map.size());
        this.assertSqlResultOrdered(sql, checkOrderFields, orderDirections, map.size());
    }

    private void assertOrdered(SqlRow prevRow, SqlRow row, List<String> orderFields, List<Boolean> orderDirections, SqlRowMetadata rowMetadata) {
        if (prevRow == null) {
            return;
        }
        for (int i = 0; i < orderFields.size(); ++i) {
            String fieldName = orderFields.get(i);
            Boolean descending = orderDirections.get(i);
            Object prevFieldValue = prevRow.getObject(rowMetadata.findColumn(fieldName));
            Object fieldValue = row.getObject(rowMetadata.findColumn(fieldName));
            int cmp = 0;
            if (fieldValue == null) {
                cmp = prevFieldValue == null ? 0 : 1;
            } else if (prevFieldValue == null) {
                cmp = fieldValue == null ? 0 : -1;
            } else if (fieldValue instanceof Integer) {
                cmp = ((Integer)prevFieldValue).compareTo((Integer)fieldValue);
            } else if (fieldValue instanceof Long) {
                cmp = ((Long)prevFieldValue).compareTo((Long)fieldValue);
            } else if (fieldValue instanceof Float) {
                cmp = ((Float)prevFieldValue).compareTo((Float)fieldValue);
            } else if (fieldValue instanceof Double) {
                cmp = ((Double)prevFieldValue).compareTo((Double)fieldValue);
            } else if (fieldValue instanceof String) {
                cmp = ((String)prevFieldValue).compareTo((String)fieldValue);
            } else if (fieldValue instanceof Boolean) {
                cmp = ((Boolean)prevFieldValue).compareTo((Boolean)fieldValue);
            } else if (fieldValue instanceof Byte) {
                cmp = ((Byte)prevFieldValue).compareTo((Byte)fieldValue);
            } else if (fieldValue instanceof Short) {
                cmp = ((Short)prevFieldValue).compareTo((Short)fieldValue);
            } else if (fieldValue instanceof BigDecimal) {
                cmp = ((BigDecimal)prevFieldValue).compareTo((BigDecimal)fieldValue);
            } else if (fieldValue instanceof LocalTime) {
                cmp = ((LocalTime)prevFieldValue).compareTo((LocalTime)fieldValue);
            } else if (fieldValue instanceof LocalDate) {
                cmp = ((LocalDate)prevFieldValue).compareTo((LocalDate)fieldValue);
            } else if (fieldValue instanceof LocalDateTime) {
                cmp = ((LocalDateTime)prevFieldValue).compareTo((LocalDateTime)fieldValue);
            } else if (fieldValue instanceof OffsetDateTime) {
                cmp = ((OffsetDateTime)prevFieldValue).compareTo((OffsetDateTime)fieldValue);
            } else {
                Assert.fail((String)("Not supported field type " + String.valueOf(fieldValue.getClass())));
            }
            if (cmp == 0) continue;
            if (cmp < 0) {
                if (descending != null && descending.booleanValue()) {
                    Assert.fail((String)("For field " + fieldName + " the values " + String.valueOf(prevFieldValue) + ", " + String.valueOf(fieldValue) + " are not ordered descending"));
                }
                return;
            }
            if (cmp <= 0) continue;
            if (descending == null || !descending.booleanValue()) {
                Assert.fail((String)("For field " + fieldName + " the values " + String.valueOf(prevFieldValue) + ", " + String.valueOf(fieldValue) + " are not ordered ascending"));
            }
            return;
        }
    }

    protected SqlResult query(String sql) {
        return this.getTarget().getSql().execute(sql, new Object[0]);
    }

    private List<String> fields() {
        if (this.serializationMode == SqlBasicTest.SerializationMode.PORTABLE) {
            return Arrays.asList("key", "booleanVal", "tinyIntVal", "smallIntVal", "intVal", "bigIntVal", "realVal", "doubleVal", "decimalVal", "charVal", "varcharVal", "dateVal", "timeVal", "timestampVal", "tsTzOffsetDateTimeVal", "portableVal", "nullVal");
        }
        return Arrays.asList("key", "booleanVal", "tinyIntVal", "smallIntVal", "intVal", "bigIntVal", "realVal", "doubleVal", "decimalBigIntegerVal", "decimalVal", "charVal", "varcharVal", "dateVal", "timeVal", "timestampVal", "tsTzDateVal", "tsTzCalendarVal", "tsTzInstantVal", "tsTzOffsetDateTimeVal", "tsTzZonedDateTimeVal", "objectVal", "nullVal");
    }

    private String basicSql() {
        List<String> fields = this.fields();
        StringBuilder res = new StringBuilder("SELECT ");
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            if (i != 0) {
                res.append(", ");
            }
            res.append(field);
        }
        res.append(" FROM ").append(this.mapName());
        return res.toString();
    }

    private String sqlWithOrderBy(List<String> projects, List<String> orderFields, List<Boolean> orderDirections) {
        int i;
        StringBuilder res = new StringBuilder("SELECT ");
        for (i = 0; i < projects.size(); ++i) {
            String field = projects.get(i);
            if (i != 0) {
                res.append(", ");
            }
            res.append(field);
        }
        res.append(" FROM ").append(this.mapName());
        res.append(" ORDER BY ");
        for (i = 0; i < orderFields.size(); ++i) {
            String orderField = orderFields.get(i);
            Boolean descending = orderDirections.get(i);
            if (i != 0) {
                res.append(", ");
            }
            res.append(orderField);
            if (descending == null) continue;
            res.append(descending != false ? " DESC " : " ASC ");
        }
        return res.toString();
    }

    private String sqlWithOrderBy(String orderCondition) {
        StringBuilder res = new StringBuilder(this.basicSql());
        res.append(" ORDER BY ").append(orderCondition);
        return res.toString();
    }

    protected String mapName() {
        return this.inMemoryFormat == InMemoryFormat.OBJECT ? MAP_OBJECT : MAP_BINARY;
    }

    private boolean isPortable() {
        return this.serializationMode == SqlBasicTest.SerializationMode.PORTABLE;
    }

    private SqlBasicTest.AbstractPojoKey key(long i) {
        switch (this.serializationMode) {
            case SERIALIZABLE: {
                return new SqlBasicTest.SerializablePojoKey(i);
            }
            case DATA_SERIALIZABLE: {
                return new SqlBasicTest.DataSerializablePojoKey(i);
            }
            case IDENTIFIED_DATA_SERIALIZABLE: {
                return new SqlBasicTest.IdentifiedDataSerializablePojoKey(i);
            }
        }
        return new SqlBasicTest.PortablePojoKey(i);
    }

    private Class<?> keyClass() {
        switch (this.serializationMode) {
            case SERIALIZABLE: {
                return SqlBasicTest.SerializablePojoKey.class;
            }
            case DATA_SERIALIZABLE: {
                return SqlBasicTest.DataSerializablePojoKey.class;
            }
            case IDENTIFIED_DATA_SERIALIZABLE: {
                return SqlBasicTest.IdentifiedDataSerializablePojoKey.class;
            }
        }
        return SqlBasicTest.PortablePojoKey.class;
    }

    private SqlBasicTest.AbstractPojo value() {
        return this.value(null);
    }

    private SqlBasicTest.AbstractPojo value(Long i) {
        switch (this.serializationMode) {
            case SERIALIZABLE: {
                return i == null ? new SqlBasicTest.SerializablePojo() : new SqlBasicTest.SerializablePojo(i);
            }
            case DATA_SERIALIZABLE: {
                return i == null ? new SqlBasicTest.DataSerializablePojo() : new SqlBasicTest.DataSerializablePojo(i);
            }
            case IDENTIFIED_DATA_SERIALIZABLE: {
                return i == null ? new SqlBasicTest.IdentifiedDataSerializablePojo() : new SqlBasicTest.IdentifiedDataSerializablePojo(i);
            }
        }
        return i == null ? new SqlBasicTest.PortablePojo() : new SqlBasicTest.PortablePojo(i);
    }

    private Class<?> valueClass() {
        switch (this.serializationMode) {
            case SERIALIZABLE: {
                return SqlBasicTest.SerializablePojo.class;
            }
            case DATA_SERIALIZABLE: {
                return SqlBasicTest.DataSerializablePojo.class;
            }
            case IDENTIFIED_DATA_SERIALIZABLE: {
                return SqlBasicTest.IdentifiedDataSerializablePojo.class;
            }
        }
        return SqlBasicTest.PortablePojo.class;
    }
}

