/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestBatchSqlConnector;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlLimitTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        SqlLimitTest.initialize((int)2, null);
        sqlService = SqlLimitTest.instance().getSql();
    }

    @Test
    public void limitOverTable() {
        String tableName = SqlLimitTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Joey", "3"});
        SqlLimitTest.assertContainsOnlyOneOfRows("SELECT name FROM " + tableName + " LIMIT 1", Arrays.asList(new SqlTestSupport.Row("Alice"), new SqlTestSupport.Row("Bob"), new SqlTestSupport.Row("Joey")));
        SqlLimitTest.assertContainsSubsetOfRows("SELECT name FROM " + tableName + " LIMIT 2", 2, Arrays.asList(new SqlTestSupport.Row("Alice"), new SqlTestSupport.Row("Bob"), new SqlTestSupport.Row("Joey")));
        SqlLimitTest.assertRowsAnyOrder("SELECT name FROM " + tableName + " LIMIT 5", Arrays.asList(new SqlTestSupport.Row("Alice"), new SqlTestSupport.Row("Bob"), new SqlTestSupport.Row("Joey")));
    }

    @Test
    public void nullLimitValue() {
        String tableName = SqlLimitTest.createTable(new String[][]{{"Alice", "1"}});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT name FROM " + tableName + " LIMIT null", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Encountered \"null\"").extracting(e -> ((HazelcastSqlException)((Object)e)).getCode()).isEqualTo((Object)1008);
    }

    @Test
    public void negativeLimitValue() {
        String tableName = SqlLimitTest.createTable(new String[][]{{"Alice", "1"}});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT name FROM " + tableName + " LIMIT -10", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Encountered \"-\"").extracting(e -> ((HazelcastSqlException)((Object)e)).getCode()).isEqualTo((Object)1008);
    }

    @Test
    public void floatNumber_asLimitValue() {
        String tableName = SqlLimitTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Joey", "3"});
        SqlLimitTest.assertContainsSubsetOfRows("SELECT name FROM " + tableName + " LIMIT 2.99", 2, Arrays.asList(new SqlTestSupport.Row("Alice"), new SqlTestSupport.Row("Bob"), new SqlTestSupport.Row("Joey")));
        SqlLimitTest.assertContainsSubsetOfRows("SELECT name FROM " + tableName + " LIMIT 2.5", 2, Arrays.asList(new SqlTestSupport.Row("Alice"), new SqlTestSupport.Row("Bob"), new SqlTestSupport.Row("Joey")));
        SqlLimitTest.assertContainsSubsetOfRows("SELECT name FROM " + tableName + " LIMIT 2.45", 2, Arrays.asList(new SqlTestSupport.Row("Alice"), new SqlTestSupport.Row("Bob"), new SqlTestSupport.Row("Joey")));
        SqlLimitTest.assertContainsSubsetOfRows("SELECT name FROM " + tableName + " LIMIT 3.1", 3, Arrays.asList(new SqlTestSupport.Row("Alice"), new SqlTestSupport.Row("Bob"), new SqlTestSupport.Row("Joey")));
    }

    @Test
    public void multipleLimitClauses() {
        String tableName = SqlLimitTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Joey", "3"});
        Assertions.assertThatThrownBy(() -> sqlService.execute(" (SELECT distance FROM " + tableName + " LIMIT 2)  UNION  (SELECT distance FROM " + tableName + " LIMIT 2)", new Object[0])).hasMessageContaining("FETCH/OFFSET is only supported for the top-level SELECT");
    }

    private static String createTable(String[] ... values) {
        String name = SqlLimitTest.randomName();
        TestBatchSqlConnector.create(sqlService, name, Arrays.asList("name", "distance"), Arrays.asList(QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.INTEGER), Arrays.asList(values));
        return name;
    }

    @Test
    public void limitOverStream() {
        SqlLimitTest.assertRowsOrdered("SELECT * FROM TABLE(GENERATE_STREAM(5)) LIMIT 1", Collections.singletonList(new SqlTestSupport.Row(0L)));
        SqlLimitTest.assertRowsOrdered("SELECT * FROM TABLE(GENERATE_STREAM(5)) LIMIT 2", Arrays.asList(new SqlTestSupport.Row(0L), new SqlTestSupport.Row(1L)));
        SqlLimitTest.assertRowsOrdered("SELECT * FROM TABLE(GENERATE_STREAM(5)) LIMIT 10", Arrays.asList(new SqlTestSupport.Row(0L), new SqlTestSupport.Row(1L), new SqlTestSupport.Row(2L), new SqlTestSupport.Row(3L), new SqlTestSupport.Row(4L), new SqlTestSupport.Row(5L), new SqlTestSupport.Row(6L), new SqlTestSupport.Row(7L), new SqlTestSupport.Row(8L), new SqlTestSupport.Row(9L)));
    }

    @Test
    public void limitWithDynamicParameter() {
        SqlLimitTest.assertRowsAnyOrder("SELECT * FROM TABLE(GENERATE_STREAM(5)) LIMIT ?", Collections.singletonList(2), Arrays.asList(new SqlTestSupport.Row(0L), new SqlTestSupport.Row(1L)));
    }

    @Test
    public void limitWithNullDynamicParameter() {
        SqlStatement statement = new SqlStatement("SELECT * FROM TABLE(GENERATE_STREAM(5)) LIMIT ?");
        statement.setParameters(Collections.singletonList(null));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute(statement).iterator().next()).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("LIMIT value cannot be null");
    }

    @Test
    public void limitWithNegativeDynamicParameter() {
        SqlStatement statement = new SqlStatement("SELECT * FROM TABLE(GENERATE_STREAM(5)) LIMIT ?");
        statement.setParameters(Collections.singletonList(-1));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute(statement).iterator().next()).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("LIMIT value cannot be negative");
    }

    @Test
    public void limitWithProjection() {
        String sql = "SELECT ABS(v) FROM TABLE (generate_series(-10, -1)) ORDER BY v ASC LIMIT 5";
        SqlLimitTest.assertRowsOrdered("SELECT ABS(v) FROM TABLE (generate_series(-10, -1)) ORDER BY v ASC LIMIT 5", SqlLimitTest.rows(10L, 9L, 8L, 7L, 6L));
    }

    @Test
    public void limitWithFilter() {
        String tableName = SqlLimitTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Joey", "3"});
        String sql = "SELECT name FROM " + tableName + " WHERE distance = 2 LIMIT 3";
        SqlLimitTest.assertRowsOrdered(sql, Collections.singletonList(new SqlTestSupport.Row("Bob")));
    }

    @Test
    public void limitAndOffsetWithProjection() {
        String sql = "SELECT ABS(v) FROM TABLE (generate_series(-10, -1)) ORDER BY v ASC LIMIT 5 OFFSET 2";
        SqlLimitTest.assertRowsOrdered("SELECT ABS(v) FROM TABLE (generate_series(-10, -1)) ORDER BY v ASC LIMIT 5 OFFSET 2", SqlLimitTest.rows(8L, 7L, 6L, 5L, 4L));
    }

    private static void assertContainsOnlyOneOfRows(String sql, Collection<SqlTestSupport.Row> expectedRows) {
        SqlLimitTest.assertContainsSubsetOfRows(sql, 1, expectedRows);
    }

    private static void assertContainsSubsetOfRows(String sql, int subsetSize, Collection<SqlTestSupport.Row> expectedRows) {
        SqlLimitTest.assertContainsSubsetOfRows(sql, Collections.emptyList(), subsetSize, expectedRows);
    }

    private static void assertContainsSubsetOfRows(String sql, List<Object> arguments, int subsetSize, Collection<SqlTestSupport.Row> expectedRows) {
        ArrayList actualRows = new ArrayList();
        SqlStatement statement = new SqlStatement(sql);
        statement.setParameters(arguments);
        sqlService.execute(statement).iterator().forEachRemaining(sqlRow -> {
            int columnCount = sqlRow.getMetadata().getColumnCount();
            Object[] values = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                values[i] = sqlRow.getObject(i);
            }
            actualRows.add(new SqlTestSupport.Row(values));
        });
        ((ListAssert)Assertions.assertThat(actualRows).hasSize(subsetSize)).containsAnyOf((Object[])expectedRows.toArray(new SqlTestSupport.Row[subsetSize]));
    }

    private static List<SqlTestSupport.Row> rows(Long ... rows) {
        return Stream.of(rows).map(xva$0 -> new SqlTestSupport.Row(xva$0)).collect(Collectors.toList());
    }
}

