/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.jet.core.TopologyChangedException;
import com.hazelcast.jet.sql.SqlErrorAbstractTest;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlErrorTest
extends SqlErrorAbstractTest {
    @Test
    public void testTimeout() {
        this.checkTimeout(null);
    }

    @Test
    public void testMemberLeave() throws InterruptedException {
        this.instance1 = this.newHazelcastInstance(false);
        this.instance2 = this.newHazelcastInstance(true);
        String name = SqlErrorTest.createTable(this.instance1.getSql(), SqlErrorTest.row(SqlErrorTest.timestampTz(0L), "Alice", 1), SqlErrorTest.row(SqlErrorTest.timestampTz(1L), null, 1), SqlErrorTest.row(SqlErrorTest.timestampTz(2L), "Alice", 1), SqlErrorTest.row(SqlErrorTest.timestampTz(3L), "Bob", 1), SqlErrorTest.row(SqlErrorTest.timestampTz(4L), "Alice", 1), SqlErrorTest.row(SqlErrorTest.timestampTz(20L), null, null));
        Thread shutdownThread = new Thread(() -> {
            SqlErrorTest.assertTrueEventually(() -> {
                Assert.assertEquals((long)1L, (long)SqlErrorTest.getExecutionContextCount(this.instance1));
                Assert.assertEquals((long)1L, (long)SqlErrorTest.getExecutionContextCount(this.instance2));
            });
            this.instance2.shutdown();
        });
        shutdownThread.start();
        SqlStatement streamingQuery = new SqlStatement("SELECT window_start/*, window_end*/ FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY 1/*, 2*/");
        HazelcastSqlException error = SqlErrorTest.assertSqlException(this.instance1, streamingQuery);
        shutdownThread.join();
        SqlErrorTest.assertInstanceOf(MemberLeftException.class, (Object)SqlErrorTest.findRootCause(error));
        shutdownThread.join();
    }

    private static String createTable(SqlService sqlService, Object[] ... values) {
        String name = SqlErrorTest.randomName();
        TestStreamSqlConnector.create(sqlService, name, Arrays.asList("ts", "name", "distance"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.INTEGER), values);
        return name;
    }

    @Test
    public void testMemberLeaveDuringQueryAfterImmediateShutdown() {
        this.instance1 = this.newHazelcastInstance(false);
        this.instance2 = this.newHazelcastInstance(true);
        SqlStatement streamingQuery = new SqlStatement("SELECT * FROM TABLE(GENERATE_STREAM(1000))");
        HazelcastSqlException error = SqlErrorTest.assertSqlExceptionWithShutdown(this.instance1, streamingQuery);
        Throwable rootCause = SqlErrorTest.findRootCause(error);
        Assert.assertTrue((rootCause instanceof TopologyChangedException || rootCause instanceof HazelcastInstanceNotActiveException ? 1 : 0) != 0);
    }

    @Test
    public void testDataTypeMismatch() {
        this.checkDataTypeMismatch(null);
    }

    @Test
    public void testExecuteOnLiteMember() {
        this.newHazelcastInstance(true);
        HazelcastInstance liteMember = this.factory.newHazelcastInstance(this.getConfig().setLiteMember(true));
        SqlErrorTest.populate(liteMember);
        HazelcastSqlException error = SqlErrorTest.assertSqlException(liteMember, SqlErrorTest.query());
        SqlErrorTest.assertErrorCode(-1, error);
        Assert.assertEquals((Object)"SQL queries cannot be executed on lite members", (Object)error.getMessage());
    }

    @Test
    public void testParsingError() {
        this.checkParsingError(null);
    }

    @Test
    public void testUserCancel() {
        this.checkUserCancel(null);
    }

    private static int getExecutionContextCount(HazelcastInstance instance) {
        return SqlErrorTest.getJetServiceBackend((HazelcastInstance)instance).getJobExecutionService().getExecutionContexts().size();
    }
}

