/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.cluster.Member;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlStatement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.junit.After;
import org.junit.Assert;

public abstract class SqlErrorAbstractTest
extends SqlTestSupport {
    protected static final String MAP_NAME = "map";
    private static final int DATA_SET_SIZE = 100;
    protected final TestHazelcastFactory factory = new TestHazelcastFactory();
    protected HazelcastInstance instance1;
    protected HazelcastInstance instance2;

    @After
    public void after() {
        this.instance1 = null;
        this.instance2 = null;
        this.factory.shutdownAll();
    }

    protected Config getConfig() {
        return SqlErrorAbstractTest.smallInstanceConfig();
    }

    protected void checkTimeout(Supplier<HazelcastInstance> clientSupplier) {
        this.instance1 = this.newHazelcastInstance(false);
        this.instance2 = this.newHazelcastInstance(true);
        SqlStatement query = new SqlStatement("select v from table(generate_stream(1))").setTimeoutMillis(1L);
        HazelcastSqlException error = SqlErrorAbstractTest.assertSqlException(clientSupplier != null ? clientSupplier.get() : this.instance1, query);
        Assert.assertTrue((boolean)error.getMessage().contains("CANCEL_FORCEFUL"));
    }

    protected void checkDataTypeMismatch(Supplier<HazelcastInstance> clientSupplier) {
        this.instance1 = this.newHazelcastInstance(false);
        this.instance2 = this.newHazelcastInstance(true);
        IMap map = this.instance1.getMap(MAP_NAME);
        SqlErrorAbstractTest.createMapping(this.instance1, MAP_NAME, Long.TYPE, Long.TYPE);
        for (long i = 0L; i < 100L; ++i) {
            Object value = i == 0L ? Long.toString(i) : Long.valueOf(i);
            map.put((Object)i, value);
        }
        HazelcastSqlException error = SqlErrorAbstractTest.assertSqlException(clientSupplier != null ? clientSupplier.get() : this.instance1, SqlErrorAbstractTest.query());
        SqlErrorAbstractTest.assertErrorCode(2000, error);
        Assert.assertTrue((boolean)error.getMessage().contains("Failed to extract map entry value because of type mismatch [expectedClass=java.lang.Long, actualClass=java.lang.String]"));
    }

    protected void checkParsingError(Supplier<HazelcastInstance> clientSupplier) {
        this.instance1 = this.newHazelcastInstance(true);
        SqlErrorAbstractTest.createMapping(this.instance1, MAP_NAME, Long.TYPE, Long.TYPE);
        IMap map = this.instance1.getMap(MAP_NAME);
        map.put((Object)1L, (Object)1L);
        HazelcastInstance target = clientSupplier != null ? clientSupplier.get() : this.instance1;
        HazelcastSqlException error = SqlErrorAbstractTest.assertSqlException(target, new SqlStatement("SELECT bad_field FROM map"));
        SqlErrorAbstractTest.assertErrorCode(1008, error);
    }

    protected void checkUserCancel(Supplier<HazelcastInstance> clientSupplier) {
        this.instance1 = this.newHazelcastInstance(true);
        HazelcastInstance target = clientSupplier != null ? clientSupplier.get() : this.instance1;
        try (SqlResult res = target.getSql().execute("select * from table(generate_stream(1))", new Object[0]);){
            SqlErrorAbstractTest.sleepSeconds((int)1);
            res.close();
            try {
                for (SqlRow sqlRow : res) {
                }
                Assert.fail((String)"Exception is not thrown");
            }
            catch (HazelcastSqlException e) {
                SqlErrorAbstractTest.assertErrorCode(1003, e);
            }
        }
    }

    @Nonnull
    protected static HazelcastSqlException assertSqlException(HazelcastInstance instance, SqlStatement query) {
        try {
            SqlErrorAbstractTest.execute(instance, query, false);
            Assert.fail((String)"Exception is not thrown");
            return null;
        }
        catch (HazelcastSqlException e) {
            System.out.println(">>> Caught expected SQL error: " + String.valueOf((Object)e));
            return e;
        }
    }

    @Nonnull
    protected static HazelcastSqlException assertSqlExceptionWithShutdown(HazelcastInstance instance, SqlStatement query) {
        try {
            SqlErrorAbstractTest.execute(instance, query, true);
            Assert.fail((String)"Exception is not thrown");
            return null;
        }
        catch (HazelcastSqlException e) {
            System.out.println(">>> Caught expected SQL error: " + String.valueOf((Object)e));
            return e;
        }
    }

    protected static int execute(HazelcastInstance instance, SqlStatement query, boolean immediateShutdown) {
        try (SqlResult res = instance.getSql().execute(query);){
            int count = 0;
            if (immediateShutdown) {
                instance.shutdown();
            }
            for (SqlRow ignore : res) {
                ++count;
            }
            int n = count;
            return n;
        }
    }

    protected static SqlStatement query() {
        return new SqlStatement("SELECT __key, this FROM map");
    }

    protected static void populate(HazelcastInstance instance) {
        SqlErrorAbstractTest.populate(instance, 100);
    }

    protected static void populate(HazelcastInstance instance, int size) {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (long i = 0L; i < (long)size; ++i) {
            map.put(i, i);
        }
        instance.getMap(MAP_NAME).putAll(map);
    }

    protected static void assertErrorCode(int expected, HazelcastSqlException error) {
        Assert.assertEquals((String)(error.getCode() + ": " + error.getMessage()), (long)expected, (long)error.getCode());
    }

    protected static Throwable findRootCause(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    protected HazelcastInstance newHazelcastInstance(boolean awaitAssignment) {
        HazelcastInstance instance = this.factory.newHazelcastInstance(this.getConfig());
        if (awaitAssignment) {
            SqlErrorAbstractTest.assertTrueEventually(() -> {
                HashSet<UUID> memberIds = new HashSet<UUID>();
                for (Member member : instance.getCluster().getMembers()) {
                    memberIds.add(member.getUuid());
                }
                PartitionService partitionService = instance.getPartitionService();
                HashSet<UUID> assignedMemberIds = new HashSet<UUID>();
                for (Partition partition : partitionService.getPartitions()) {
                    Member owner = partition.getOwner();
                    Assert.assertNotNull((Object)owner);
                    assignedMemberIds.add(owner.getUuid());
                }
                Assert.assertEquals(memberIds, assignedMemberIds);
            });
        }
        return instance;
    }
}

