/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.IndexScanMapPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.SortPhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlCreateIndexTest
extends OptimizerTestSupport {
    private static final String MAP_NAME = "map";
    private IMap<Integer, Integer> map;

    @BeforeClass
    public static void beforeClass() {
        SqlCreateIndexTest.initialize((int)1, null);
    }

    @Before
    public void setUp() throws Exception {
        this.map = SqlCreateIndexTest.instance().getMap(MAP_NAME);
        for (int i = 0; i < 500; ++i) {
            this.map.put((Object)i, (Object)i);
        }
    }

    @Test
    public void when_basicHashIndexCreated_then_succeeds() {
        String indexName = SqlTestSupport.randomName();
        String selectSql = "SELECT * FROM map WHERE this = 100";
        this.checkPlan(false, false, selectSql);
        String sql = "CREATE INDEX IF NOT EXISTS " + indexName + " ON map (this) TYPE HASH";
        SqlCreateIndexTest.instance().getSql().execute(sql, new Object[0]);
        this.checkPlan(true, false, selectSql);
    }

    @Test
    public void when_basicSortedIndexCreated_then_succeeds() {
        String indexName = SqlTestSupport.randomName();
        String selectSql = "SELECT * FROM map ORDER BY this DESC";
        this.checkPlan(false, true, selectSql);
        String sql = "CREATE INDEX IF NOT EXISTS " + indexName + " ON map (this) TYPE SORTED";
        SqlCreateIndexTest.instance().getSql().execute(sql, new Object[0]);
        this.checkPlan(true, true, selectSql);
    }

    @Test
    public void when_basicBitmapIndexCreated_then_succeeds() {
        Assertions.assertThat((Object)SqlCreateIndexTest.mapContainer(this.map).getGlobalIndexRegistry().getIndex(MAP_NAME)).isNull();
        String indexName = SqlTestSupport.randomName();
        String sql = "CREATE INDEX IF NOT EXISTS " + indexName + " ON map (__key) TYPE BITMAP; ";
        SqlCreateIndexTest.instance().getSql().execute(sql, new Object[0]);
        Assertions.assertThat((Object)SqlCreateIndexTest.mapContainer(this.map).getGlobalIndexRegistry().getIndex(indexName)).isNotNull();
    }

    @Test
    public void when_bitmapIndexWithOptionCreated_then_succeeds() {
        Assertions.assertThat((Object)SqlCreateIndexTest.mapContainer(this.map).getGlobalIndexRegistry().getIndex(MAP_NAME)).isNull();
        String indexName = SqlTestSupport.randomName();
        String sql = "CREATE INDEX IF NOT EXISTS " + indexName + " ON map (__key) TYPE BITMAP OPTIONS ('unique_key' = '__key' , 'unique_key_transformation' = 'OBJECT'); ";
        SqlCreateIndexTest.instance().getSql().execute(sql, new Object[0]);
        Assertions.assertThat((Object)SqlCreateIndexTest.mapContainer(this.map).getGlobalIndexRegistry().getIndex(indexName)).isNotNull();
    }

    @Test
    public void when_indexCreatedWithEmptyMap_then_succeeds() {
        String mapName = "map2";
        String indexName = SqlTestSupport.randomName();
        String sql = "CREATE INDEX IF NOT EXISTS " + indexName + " ON " + mapName + " (__key) TYPE SORTED";
        SqlCreateIndexTest.instance().getSql().execute(sql, new Object[0]);
        Assertions.assertThat((Object)SqlCreateIndexTest.mapContainer(SqlCreateIndexTest.instance().getMap(mapName)).getGlobalIndexRegistry().getIndex(indexName)).isNotNull();
    }

    @Test
    public void when_indexCreatedWithDefaultType_then_succeeds() {
        String indexName = SqlTestSupport.randomName();
        String selectSql = "SELECT * FROM map ORDER BY this DESC";
        this.checkPlan(false, true, selectSql);
        String sql = "CREATE INDEX IF NOT EXISTS " + indexName + " ON map (this)";
        SqlCreateIndexTest.instance().getSql().execute(sql, new Object[0]);
        this.checkPlan(true, true, selectSql);
    }

    @Test
    public void when_indexCreatedWithDuplicatedArguments_then_throws() {
        String sql = "CREATE INDEX IF NOT EXISTS idx ON map (this, this) TYPE BITMAP";
        Assertions.assertThatThrownBy(() -> SqlCreateIndexTest.instance().getSql().execute(sql, new Object[0])).hasMessageContaining("specified more than once");
    }

    @Test
    public void when_indexCreatedWithDuplicatedOptions_then_throws() {
        String indexName = SqlTestSupport.randomName();
        String sql = "CREATE INDEX IF NOT EXISTS " + indexName + " ON map (__key) TYPE BITMAP OPTIONS ('unique_key' = '__key' , 'unique_key' = 'OBJECT'); ";
        Assertions.assertThatThrownBy(() -> SqlCreateIndexTest.instance().getSql().execute(sql, new Object[0])).hasMessageContaining("Option 'unique_key' specified more than once");
    }

    @Test
    public void when_indexCreatedWithIfNotExistsAndCreatedAgain_then_throws() {
        SqlCreateIndexTest.createMapping(MAP_NAME, Integer.class, Integer.class);
        String indexName = "idx";
        String sql = "CREATE INDEX IF NOT EXISTS " + indexName + " ON map (this) TYPE HASH";
        SqlCreateIndexTest.instance().getSql().execute(sql, new Object[0]);
        String sql2 = "CREATE INDEX " + indexName + " ON map (this) TYPE HASH";
        Assertions.assertThatThrownBy(() -> SqlCreateIndexTest.instance().getSql().execute(sql2, new Object[0])).hasMessageContaining("Can't create index: index 'idx' already exists");
    }

    @Test
    public void when_indexExistsAndCreatedAgainWithIfNotExists_then_succeeds() {
        SqlCreateIndexTest.createMapping(MAP_NAME, Integer.class, Integer.class);
        String indexName = "idx";
        this.map.addIndex(new IndexConfig(IndexType.HASH, new String[]{"this"}).setName(indexName));
        String sql = "CREATE INDEX IF NOT EXISTS " + indexName + " ON map (this) TYPE HASH";
        Assertions.assertThat((Iterable)SqlCreateIndexTest.instance().getSql().execute(sql, new Object[0])).isNotNull();
    }

    @Test
    public void when_hashOrSortedIndexCreatedWithOptions_then_throws() {
        String sql1 = "CREATE INDEX IF NOT EXISTS idx ON map (this) TYPE HASH OPTIONS ('a' = '1')";
        Assertions.assertThatThrownBy(() -> SqlCreateIndexTest.instance().getSql().execute(sql1, new Object[0])).hasMessageContaining("Unknown option for HASH index: a");
        String sql2 = "CREATE INDEX IF NOT EXISTS idx2 ON map (this) TYPE SORTED OPTIONS ('a' = '1')";
        Assertions.assertThatThrownBy(() -> SqlCreateIndexTest.instance().getSql().execute(sql2, new Object[0])).hasMessageContaining("Unknown option for SORTED index: a");
    }

    private void checkPlan(boolean withIndex, boolean sorted, String sql) {
        this.checkPlan(withIndex, sorted, sql, MAP_NAME);
    }

    private void checkPlan(boolean withIndex, boolean sorted, String sql, String mapName) {
        List<QueryDataType> parameterTypes = Arrays.asList(QueryDataType.INT, QueryDataType.INT);
        List<TableField> mapTableFields = Arrays.asList(new MapTableField("__key", QueryDataType.INT, false, QueryPath.KEY_PATH), new MapTableField("this", QueryDataType.INT, false, QueryPath.VALUE_PATH));
        HazelcastTable table = SqlCreateIndexTest.partitionedTable(mapName, mapTableFields, MapTableUtils.getPartitionedMapIndexes((MapContainer)SqlCreateIndexTest.mapContainer(this.map), mapTableFields), this.map.size());
        Assertions.assertThat((int)table.getProjects().size()).isEqualTo(2);
        OptimizerTestSupport.Result optimizationResult = this.optimizePhysical(sql, parameterTypes, table);
        if (sorted) {
            if (withIndex) {
                SqlCreateIndexTest.assertPlan((RelNode)optimizationResult.getPhysical(), SqlCreateIndexTest.plan(SqlCreateIndexTest.planRow(0, IndexScanMapPhysicalRel.class)));
            } else {
                SqlCreateIndexTest.assertPlan((RelNode)optimizationResult.getPhysical(), SqlCreateIndexTest.plan(SqlCreateIndexTest.planRow(0, SortPhysicalRel.class), SqlCreateIndexTest.planRow(1, FullScanPhysicalRel.class)));
            }
        } else {
            SqlCreateIndexTest.assertPlan((RelNode)optimizationResult.getLogical(), SqlCreateIndexTest.plan(SqlCreateIndexTest.planRow(0, FullScanLogicalRel.class)));
            SqlCreateIndexTest.assertPlan((RelNode)optimizationResult.getPhysical(), SqlCreateIndexTest.plan(SqlCreateIndexTest.planRow(0, withIndex ? IndexScanMapPhysicalRel.class : FullScanPhysicalRel.class)));
        }
    }
}

