/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.model.Person;
import com.hazelcast.map.IMap;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlCountDistinctTest
extends SqlTestSupport {
    @BeforeClass
    public static void beforeClass() {
        SqlCountDistinctTest.initialize((int)2, null);
    }

    @Test
    public void test_countDistinct() {
        String key;
        int i;
        String mapName = SqlCountDistinctTest.generateRandomString((int)16);
        SqlCountDistinctTest.createMapping(mapName, Integer.class, Person.class);
        IMap map = SqlCountDistinctTest.instance().getMap(mapName);
        for (i = 0; i < 900; ++i) {
            key = "key" + i;
            map.put((Object)key, (Object)new Person(i, key));
        }
        for (i = 0; i < 100; ++i) {
            key = "key" + i;
            map.put((Object)(key + "_"), (Object)new Person(i, null));
        }
        SqlCountDistinctTest.assertRowsAnyOrder("select count(*) from (select distinct id from " + mapName + ")", SqlCountDistinctTest.rows(1, 900L));
        SqlCountDistinctTest.assertRowsAnyOrder("select count(id) from " + mapName, SqlCountDistinctTest.rows(1, 1000L));
        SqlCountDistinctTest.assertRowsAnyOrder("select count(distinct id) from " + mapName, SqlCountDistinctTest.rows(1, 900L));
        SqlCountDistinctTest.assertRowsAnyOrder("select count(distinct name) from " + mapName, SqlCountDistinctTest.rows(1, 900L));
    }
}

