/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.shaded.com.google.common.collect.Iterators;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.test.HazelcastParallelParametersRunnerFactory;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.test.annotation.ParallelJVMTest;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParallelParametersRunnerFactory.class)
@Category(value={NightlyTest.class, ParallelJVMTest.class})
public class SqlClientPortableQueryTest
extends SqlTestSupport {
    private static final int PORTABLE_FACTORY_ID = 1;
    private static final int PORTABLE_CHILD_CLASS_ID = 1;
    private static final int PORTABLE_PARENT_CLASS_ID = 2;
    @Parameterized.Parameter
    public InMemoryFormat inMemoryFormat;
    @Parameterized.Parameter(value=1)
    public boolean clusterHasPortableConfig;
    public TestHazelcastFactory factory = new TestHazelcastFactory();

    @Parameterized.Parameters(name="inMemoryFormat:{0}, clusterHasPortableConfig:{1}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({InMemoryFormat.BINARY, true}, {InMemoryFormat.BINARY, false}, {InMemoryFormat.OBJECT, true}, {InMemoryFormat.OBJECT, false});
    }

    @Before
    public void setup() {
        MapConfig mapConfig = new MapConfig("default").setInMemoryFormat(this.inMemoryFormat);
        Config config = SqlClientPortableQueryTest.smallInstanceConfig().addMapConfig(mapConfig);
        if (this.clusterHasPortableConfig) {
            config.getSerializationConfig().addPortableFactory(1, (PortableFactory)new TestPortableFactory());
        }
        ClassDefinition childClassDefinition = new ClassDefinitionBuilder(1, 1, 0).addIntField("i").addIntArrayField("ia").build();
        ClassDefinition parentClassDefinition = new ClassDefinitionBuilder(1, 2, 0).addPortableField("child", childClassDefinition).addIntField("id").build();
        config.getSerializationConfig().addClassDefinition(childClassDefinition);
        config.getSerializationConfig().addClassDefinition(parentClassDefinition);
        this.factory.newHazelcastInstance(config);
    }

    @After
    public void cleanup() {
        this.factory.terminateAll();
    }

    @Test
    public void testQueryOnPrimitive() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getSerializationConfig().addPortableFactory(1, (PortableFactory)new TestPortableFactory());
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        SqlClientPortableQueryTest.createMapping(client, "test", Integer.TYPE, 1, 1, 0);
        IMap map = client.getMap("test");
        SqlClientPortableQueryTest.fillMap(map, 50, ChildPortable::new);
        SqlResult result = client.getSql().execute("SELECT * FROM test WHERE i >= 45", new Object[0]);
        Assertions.assertThat((Iterable)result).hasSize(5);
    }

    @Test
    public void testQueryOnObject() {
        Assume.assumeTrue((boolean)this.clusterHasPortableConfig);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getSerializationConfig().addPortableFactory(1, (PortableFactory)new TestPortableFactory());
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        SqlClientPortableQueryTest.createMapping(client, "test", Integer.TYPE, 1, 2, 0);
        IMap map = client.getMap("test");
        SqlClientPortableQueryTest.fillMap(map, 100, ParentPortable::new);
        ChildPortable expected = new ChildPortable(10);
        SqlResult rows = client.getSql().execute("SELECT id FROM test WHERE child = ?", new Object[]{expected});
        SqlRow row = (SqlRow)Iterators.getOnlyElement((Iterator)rows.iterator());
        Assert.assertEquals((Object)10, (Object)row.getObject("id"));
    }

    @Test
    public void testNestedPortableAsColumn() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getSerializationConfig().addPortableFactory(1, (PortableFactory)new TestPortableFactory());
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        SqlClientPortableQueryTest.createMapping(client, "test", Integer.TYPE, 1, 2, 0);
        IMap map = client.getMap("test");
        SqlClientPortableQueryTest.fillMap(map, 100, ParentPortable::new);
        SqlResult result = client.getSql().execute("SELECT id, child FROM test WHERE id = ? ", new Object[]{1});
        SqlRow row = (SqlRow)Iterators.getOnlyElement((Iterator)result.iterator());
        Assert.assertEquals((Object)1, (Object)row.getObject(0));
        Assert.assertEquals((Object)new ChildPortable(1), (Object)row.getObject(1));
    }

    private static <T> void fillMap(IMap<Integer, T> map, int count, Function<Integer, T> constructor) {
        for (int i = 0; i < count; ++i) {
            map.put((Object)i, constructor.apply(i));
        }
    }

    private static class TestPortableFactory
    implements PortableFactory {
        private TestPortableFactory() {
        }

        public Portable create(int classId) {
            if (classId == 1) {
                return new ChildPortable();
            }
            if (classId == 2) {
                return new ParentPortable();
            }
            return null;
        }
    }

    private static class ChildPortable
    implements Portable,
    Comparable<ChildPortable> {
        private int i;
        private int[] ia;

        ChildPortable() {
        }

        ChildPortable(int i) {
            this.i = i;
            this.ia = new int[]{i};
        }

        public int getFactoryId() {
            return 1;
        }

        public int getClassId() {
            return 1;
        }

        public void writePortable(PortableWriter writer) throws IOException {
            writer.writeInt("i", this.i);
            writer.writeIntArray("ia", this.ia);
        }

        public void readPortable(PortableReader reader) throws IOException {
            this.i = reader.readInt("i");
            this.ia = reader.readIntArray("ia");
        }

        @Override
        public int compareTo(ChildPortable o) {
            return this.i - o.i;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChildPortable that = (ChildPortable)o;
            return this.i == that.i && Arrays.equals(this.ia, that.ia);
        }

        public int hashCode() {
            int result = Objects.hash(this.i);
            result = 31 * result + Arrays.hashCode(this.ia);
            return result;
        }
    }

    private static class ParentPortable
    implements Portable,
    Comparable<ParentPortable> {
        private ChildPortable c;
        private int id;

        ParentPortable() {
        }

        ParentPortable(int i) {
            this.c = new ChildPortable(i);
            this.id = i;
        }

        public int getFactoryId() {
            return 1;
        }

        public int getClassId() {
            return 2;
        }

        public void writePortable(PortableWriter writer) throws IOException {
            writer.writePortable("child", (Portable)this.c);
            writer.writeInt("id", this.id);
        }

        public void readPortable(PortableReader reader) throws IOException {
            this.c = (ChildPortable)reader.readPortable("child");
            this.id = reader.readInt("id");
        }

        @Override
        public int compareTo(ParentPortable o) {
            return this.c.compareTo(o.c);
        }
    }
}

