/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.util.FilteringClassLoader;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.test.HazelcastParallelParametersRunnerFactory;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import example.serialization.EmployeeDTO;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParallelParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlClientCompactQueryTest
extends HazelcastTestSupport {
    @Parameterized.Parameter
    public InMemoryFormat inMemoryFormat;
    @Parameterized.Parameter(value=1)
    public boolean clusterHaveUserClasses;
    public TestHazelcastFactory factory = new TestHazelcastFactory();

    @Parameterized.Parameters(name="inMemoryFormat:{0}, clusterHaveUserClasses:{1}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({InMemoryFormat.BINARY, true}, {InMemoryFormat.BINARY, false}, {InMemoryFormat.OBJECT, true}, {InMemoryFormat.OBJECT, false});
    }

    @Before
    public void setup() {
        MapConfig mapConfig = new MapConfig("default").setInMemoryFormat(this.inMemoryFormat);
        Config config = SqlClientCompactQueryTest.smallInstanceConfig().addMapConfig(mapConfig);
        if (!this.clusterHaveUserClasses) {
            List<String> excludes = Collections.singletonList("example.serialization");
            FilteringClassLoader classLoader = new FilteringClassLoader(excludes, null);
            config.setClassLoader((ClassLoader)classLoader);
        }
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
    }

    @After
    public void cleanup() {
        this.factory.terminateAll();
    }

    @Test
    public void testQueryOnPrimitive() {
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap("test");
        for (int i = 0; i < 10; ++i) {
            map.put((Object)i, (Object)new EmployeeDTO(i, (long)i));
        }
        client.getSql().execute("CREATE MAPPING test(__key INTEGER, age INTEGER, \"rank\" INTEGER, id BIGINT, isHired BOOLEAN, isFired BOOLEAN) TYPE IMap OPTIONS ('keyFormat'='int', 'valueFormat'='compact', 'valueCompactTypeName'='" + EmployeeDTO.class.getName() + "')", new Object[0]);
        SqlResult result = client.getSql().execute("SELECT * FROM test WHERE age >= 5", new Object[0]);
        Assertions.assertThat((Iterable)result).hasSize(5);
    }

    @Test
    public void testQueryOnPrimitive_selectValue() {
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap("test");
        for (int i = 0; i < 10; ++i) {
            map.put((Object)i, (Object)new EmployeeDTO(i, (long)i));
        }
        client.getSql().execute("CREATE MAPPING test(__key INTEGER, age INTEGER, \"rank\" INTEGER, id BIGINT, isHired BOOLEAN, isFired BOOLEAN) TYPE IMap OPTIONS ('keyFormat'='int', 'valueFormat'='compact', 'valueCompactTypeName'='" + EmployeeDTO.class.getName() + "')", new Object[0]);
        SqlResult result = client.getSql().execute("SELECT this FROM test WHERE age >= 5", new Object[0]);
        Assertions.assertThat((Iterable)result).hasSize(5);
    }
}

