/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.JetTestSupport;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlService;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class LightJobBench
extends JetTestSupport {
    private HazelcastInstance inst;

    @Before
    public void before() {
        this.inst = this.createHazelcastInstance();
    }

    @Test
    public void jetBench() {
        int warmUpIterations = 100;
        int realIterations = 2000;
        DAG dag = new DAG();
        dag.newVertex("v", Processors.noopP());
        this.logger.info("will submit " + warmUpIterations + " jobs");
        for (int i = 0; i < warmUpIterations; ++i) {
            this.inst.getJet().newLightJob(dag).join();
        }
        this.logger.info("warmup jobs done, starting benchmark");
        long start = System.nanoTime();
        for (int i = 0; i < realIterations; ++i) {
            this.inst.getJet().newLightJob(dag).join();
        }
        long elapsedMicros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - start);
        System.out.println(realIterations + " jobs run in " + elapsedMicros / (long)realIterations + " us/job");
    }

    @Test
    public void sqlBench() {
        int warmUpIterations = 100;
        int realIterations = 200;
        SqlService sqlService = this.inst.getSql();
        this.logger.info("will submit " + warmUpIterations + " jobs");
        SqlTestSupport.createMapping(this.inst, "m", Integer.TYPE, Integer.TYPE);
        this.inst.getMap("m").put((Object)1, (Object)1);
        int numRows = 0;
        for (int i = 0; i < warmUpIterations; ++i) {
            for (SqlRow ignored : sqlService.execute("select * from m", new Object[0])) {
                ++numRows;
            }
        }
        this.logger.info("warmup jobs done, starting benchmark");
        long start = System.nanoTime();
        for (int i = 0; i < realIterations; ++i) {
            for (SqlRow ignored : sqlService.execute("select * from m", new Object[0])) {
                ++numRows;
            }
        }
        long elapsedMicros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - start);
        System.out.println(numRows);
        System.out.println(realIterations + " queries run in " + elapsedMicros / (long)realIterations + " us/job");
    }
}

