/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.polygonize;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryComponentFilter;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.operation.polygonize.EdgeRing;
import com.hazelcast.shaded.org.locationtech.jts.operation.polygonize.HoleAssigner;
import com.hazelcast.shaded.org.locationtech.jts.operation.polygonize.PolygonizeGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Polygonizer {
    private LineStringAdder lineStringAdder = new LineStringAdder(this);
    protected PolygonizeGraph graph;
    protected Collection dangles = new ArrayList();
    protected List cutEdges = new ArrayList();
    protected List invalidRingLines = new ArrayList();
    protected List holeList = null;
    protected List shellList = null;
    protected List polyList = null;
    private boolean isCheckingRingsValid = true;
    private boolean extractOnlyPolygonal;
    private GeometryFactory geomFactory = null;

    public Polygonizer() {
        this(false);
    }

    public Polygonizer(boolean extractOnlyPolygonal) {
        this.extractOnlyPolygonal = extractOnlyPolygonal;
    }

    public void add(Collection geomList) {
        for (Geometry geometry : geomList) {
            this.add(geometry);
        }
    }

    public void add(Geometry g2) {
        g2.apply(this.lineStringAdder);
    }

    private void add(LineString line) {
        this.geomFactory = line.getFactory();
        if (this.graph == null) {
            this.graph = new PolygonizeGraph(this.geomFactory);
        }
        this.graph.addEdge(line);
    }

    public void setCheckRingsValid(boolean isCheckingRingsValid) {
        this.isCheckingRingsValid = isCheckingRingsValid;
    }

    public Collection getPolygons() {
        this.polygonize();
        return this.polyList;
    }

    public Geometry getGeometry() {
        if (this.geomFactory == null) {
            this.geomFactory = new GeometryFactory();
        }
        this.polygonize();
        if (this.extractOnlyPolygonal) {
            return this.geomFactory.buildGeometry(this.polyList);
        }
        return this.geomFactory.createGeometryCollection(GeometryFactory.toGeometryArray(this.polyList));
    }

    public Collection getDangles() {
        this.polygonize();
        return this.dangles;
    }

    public Collection getCutEdges() {
        this.polygonize();
        return this.cutEdges;
    }

    public Collection getInvalidRingLines() {
        this.polygonize();
        return this.invalidRingLines;
    }

    private void polygonize() {
        if (this.polyList != null) {
            return;
        }
        this.polyList = new ArrayList();
        if (this.graph == null) {
            return;
        }
        this.dangles = this.graph.deleteDangles();
        this.cutEdges = this.graph.deleteCutEdges();
        List edgeRingList = this.graph.getEdgeRings();
        List validEdgeRingList = new ArrayList();
        this.invalidRingLines = new ArrayList();
        if (this.isCheckingRingsValid) {
            this.findValidRings(edgeRingList, validEdgeRingList, this.invalidRingLines);
        } else {
            validEdgeRingList = edgeRingList;
        }
        this.findShellsAndHoles(validEdgeRingList);
        HoleAssigner.assignHolesToShells(this.holeList, this.shellList);
        Collections.sort(this.shellList, new EdgeRing.EnvelopeComparator());
        boolean includeAll = true;
        if (this.extractOnlyPolygonal) {
            Polygonizer.findDisjointShells(this.shellList);
            includeAll = false;
        }
        this.polyList = Polygonizer.extractPolygons(this.shellList, includeAll);
    }

    private void findValidRings(List edgeRingList, List validEdgeRingList, List invalidRingList) {
        for (EdgeRing er : edgeRingList) {
            if (er.isValid()) {
                validEdgeRingList.add(er);
                continue;
            }
            invalidRingList.add(er.getLineString());
        }
    }

    private void findShellsAndHoles(List edgeRingList) {
        this.holeList = new ArrayList();
        this.shellList = new ArrayList();
        for (EdgeRing er : edgeRingList) {
            er.computeHole();
            if (er.isHole()) {
                this.holeList.add(er);
                continue;
            }
            this.shellList.add(er);
        }
    }

    private static void findDisjointShells(List shellList) {
        boolean isMoreToScan;
        Polygonizer.findOuterShells(shellList);
        do {
            isMoreToScan = false;
            for (EdgeRing er : shellList) {
                if (er.isIncludedSet()) continue;
                er.updateIncluded();
                if (er.isIncludedSet()) continue;
                isMoreToScan = true;
            }
        } while (isMoreToScan);
    }

    private static void findOuterShells(List shellList) {
        for (EdgeRing er : shellList) {
            EdgeRing outerHoleER = er.getOuterHole();
            if (outerHoleER == null || outerHoleER.isProcessed()) continue;
            er.setIncluded(true);
            outerHoleER.setProcessed(true);
        }
    }

    private static List extractPolygons(List shellList, boolean includeAll) {
        ArrayList<Polygon> polyList = new ArrayList<Polygon>();
        for (EdgeRing er : shellList) {
            if (!includeAll && !er.isIncluded()) continue;
            polyList.add(er.getPolygon());
        }
        return polyList;
    }

    private static class LineStringAdder
    implements GeometryComponentFilter {
        Polygonizer p;

        LineStringAdder(Polygonizer p) {
            this.p = p;
        }

        @Override
        public void filter(Geometry g2) {
            if (g2 instanceof LineString) {
                this.p.add((LineString)g2);
            }
        }
    }
}

