/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.linearref;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.Lineal;
import com.hazelcast.shaded.org.locationtech.jts.linearref.LinearLocation;

public class LinearIterator {
    private Geometry linearGeom;
    private final int numLines;
    private LineString currentLine;
    private int componentIndex = 0;
    private int vertexIndex = 0;

    private static int segmentEndVertexIndex(LinearLocation loc) {
        if (loc.getSegmentFraction() > 0.0) {
            return loc.getSegmentIndex() + 1;
        }
        return loc.getSegmentIndex();
    }

    public LinearIterator(Geometry linear) {
        this(linear, 0, 0);
    }

    public LinearIterator(Geometry linear, LinearLocation start) {
        this(linear, start.getComponentIndex(), LinearIterator.segmentEndVertexIndex(start));
    }

    public LinearIterator(Geometry linearGeom, int componentIndex, int vertexIndex) {
        if (!(linearGeom instanceof Lineal)) {
            throw new IllegalArgumentException("Lineal geometry is required");
        }
        this.linearGeom = linearGeom;
        this.numLines = linearGeom.getNumGeometries();
        this.componentIndex = componentIndex;
        this.vertexIndex = vertexIndex;
        this.loadCurrentLine();
    }

    private void loadCurrentLine() {
        if (this.componentIndex >= this.numLines) {
            this.currentLine = null;
            return;
        }
        this.currentLine = (LineString)this.linearGeom.getGeometryN(this.componentIndex);
    }

    public boolean hasNext() {
        if (this.componentIndex >= this.numLines) {
            return false;
        }
        return this.componentIndex != this.numLines - 1 || this.vertexIndex < this.currentLine.getNumPoints();
    }

    public void next() {
        if (!this.hasNext()) {
            return;
        }
        ++this.vertexIndex;
        if (this.vertexIndex >= this.currentLine.getNumPoints()) {
            ++this.componentIndex;
            this.loadCurrentLine();
            this.vertexIndex = 0;
        }
    }

    public boolean isEndOfLine() {
        if (this.componentIndex >= this.numLines) {
            return false;
        }
        return this.vertexIndex >= this.currentLine.getNumPoints() - 1;
    }

    public int getComponentIndex() {
        return this.componentIndex;
    }

    public int getVertexIndex() {
        return this.vertexIndex;
    }

    public LineString getLine() {
        return this.currentLine;
    }

    public Coordinate getSegmentStart() {
        return this.currentLine.getCoordinateN(this.vertexIndex);
    }

    public Coordinate getSegmentEnd() {
        if (this.vertexIndex < this.getLine().getNumPoints() - 1) {
            return this.currentLine.getCoordinateN(this.vertexIndex + 1);
        }
        return null;
    }
}

