/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.io.kml;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.io.ParseException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class KMLReader {
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private final GeometryFactory geometryFactory;
    private final Set<String> attributeNames;
    private static final String POINT = "Point";
    private static final String LINESTRING = "LineString";
    private static final String POLYGON = "Polygon";
    private static final String MULTIGEOMETRY = "MultiGeometry";
    private static final String COORDINATES = "coordinates";
    private static final String OUTER_BOUNDARY_IS = "outerBoundaryIs";
    private static final String INNER_BOUNDARY_IS = "innerBoundaryIs";
    private static final String NO_ELEMENT_ERROR = "No element %s found in %s";

    public KMLReader() {
        this(new GeometryFactory(), Collections.emptyList());
    }

    public KMLReader(GeometryFactory geometryFactory) {
        this(geometryFactory, Collections.emptyList());
    }

    public KMLReader(Collection<String> attributeNames) {
        this(new GeometryFactory(), attributeNames);
    }

    public KMLReader(GeometryFactory geometryFactory, Collection<String> attributeNames) {
        this.geometryFactory = geometryFactory;
        this.attributeNames = attributeNames == null ? Collections.emptySet() : new HashSet<String>(attributeNames);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Geometry read(String kmlGeometryString) throws ParseException {
        try (StringReader sr = new StringReader(kmlGeometryString);){
            XMLStreamReader xmlSr = this.inputFactory.createXMLStreamReader(sr);
            Geometry geometry = this.parseKML(xmlSr);
            return geometry;
        }
        catch (XMLStreamException e) {
            throw new ParseException(e);
        }
    }

    private Coordinate[] parseKMLCoordinates(XMLStreamReader xmlStreamReader) throws XMLStreamException, ParseException {
        String coordinates = xmlStreamReader.getElementText();
        if (coordinates.isEmpty()) {
            this.raiseParseError("Empty coordinates", new Object[0]);
        }
        double[] parsedOrdinates = new double[]{Double.NaN, Double.NaN, Double.NaN};
        ArrayList<Coordinate> coordinateList = new ArrayList<Coordinate>();
        int spaceIdx = coordinates.indexOf(32);
        int currentIdx = 0;
        while (currentIdx < coordinates.length()) {
            String coordinate;
            int yOrdinateComma;
            if (spaceIdx == -1) {
                spaceIdx = coordinates.length();
            }
            if ((yOrdinateComma = (coordinate = coordinates.substring(currentIdx, spaceIdx)).indexOf(44)) == -1 || yOrdinateComma == coordinate.length() - 1 || yOrdinateComma == 0) {
                this.raiseParseError("Invalid coordinate format", new Object[0]);
            }
            parsedOrdinates[0] = Double.parseDouble(coordinate.substring(0, yOrdinateComma));
            int zOrdinateComma = coordinate.indexOf(44, yOrdinateComma + 1);
            if (zOrdinateComma == -1) {
                parsedOrdinates[1] = Double.parseDouble(coordinate.substring(yOrdinateComma + 1));
            } else {
                parsedOrdinates[1] = Double.parseDouble(coordinate.substring(yOrdinateComma + 1, zOrdinateComma));
                parsedOrdinates[2] = Double.parseDouble(coordinate.substring(zOrdinateComma + 1));
            }
            Coordinate crd = new Coordinate(parsedOrdinates[0], parsedOrdinates[1], parsedOrdinates[2]);
            this.geometryFactory.getPrecisionModel().makePrecise(crd);
            coordinateList.add(crd);
            currentIdx = spaceIdx + 1;
            spaceIdx = coordinates.indexOf(32, currentIdx);
            parsedOrdinates[2] = Double.NaN;
            parsedOrdinates[1] = Double.NaN;
            parsedOrdinates[0] = Double.NaN;
        }
        return coordinateList.toArray(new Coordinate[0]);
    }

    private KMLCoordinatesAndAttributes parseKMLCoordinatesAndAttributes(XMLStreamReader xmlStreamReader, String objectNodeName) throws XMLStreamException, ParseException {
        Coordinate[] coordinates = null;
        HashMap<String, String> attributes = null;
        while (!(!xmlStreamReader.hasNext() || xmlStreamReader.isEndElement() && xmlStreamReader.getLocalName().equals(objectNodeName))) {
            if (xmlStreamReader.isStartElement()) {
                String elementName = xmlStreamReader.getLocalName();
                if (elementName.equals(COORDINATES)) {
                    coordinates = this.parseKMLCoordinates(xmlStreamReader);
                } else if (this.attributeNames.contains(elementName)) {
                    if (attributes == null) {
                        attributes = new HashMap<String, String>();
                    }
                    attributes.put(elementName, xmlStreamReader.getElementText());
                }
            }
            xmlStreamReader.next();
        }
        if (coordinates == null) {
            this.raiseParseError(NO_ELEMENT_ERROR, COORDINATES, objectNodeName);
        }
        return new KMLCoordinatesAndAttributes(coordinates, attributes);
    }

    private Geometry parseKMLPoint(XMLStreamReader xmlStreamReader) throws XMLStreamException, ParseException {
        KMLCoordinatesAndAttributes kmlCoordinatesAndAttributes = this.parseKMLCoordinatesAndAttributes(xmlStreamReader, POINT);
        Point point = this.geometryFactory.createPoint(kmlCoordinatesAndAttributes.coordinates[0]);
        point.setUserData(kmlCoordinatesAndAttributes.attributes);
        return point;
    }

    private Geometry parseKMLLineString(XMLStreamReader xmlStreamReader) throws XMLStreamException, ParseException {
        KMLCoordinatesAndAttributes kmlCoordinatesAndAttributes = this.parseKMLCoordinatesAndAttributes(xmlStreamReader, LINESTRING);
        LineString lineString = this.geometryFactory.createLineString(kmlCoordinatesAndAttributes.coordinates);
        lineString.setUserData(kmlCoordinatesAndAttributes.attributes);
        return lineString;
    }

    private Geometry parseKMLPolygon(XMLStreamReader xmlStreamReader) throws XMLStreamException, ParseException {
        LinearRing shell = null;
        ArrayList<LinearRing> holes = null;
        HashMap<String, String> attributes = null;
        while (!(!xmlStreamReader.hasNext() || xmlStreamReader.isEndElement() && xmlStreamReader.getLocalName().equals(POLYGON))) {
            if (xmlStreamReader.isStartElement()) {
                String elementName = xmlStreamReader.getLocalName();
                if (elementName.equals(OUTER_BOUNDARY_IS)) {
                    this.moveToElement(xmlStreamReader, COORDINATES, OUTER_BOUNDARY_IS);
                    shell = this.geometryFactory.createLinearRing(this.parseKMLCoordinates(xmlStreamReader));
                } else if (elementName.equals(INNER_BOUNDARY_IS)) {
                    this.moveToElement(xmlStreamReader, COORDINATES, INNER_BOUNDARY_IS);
                    if (holes == null) {
                        holes = new ArrayList<LinearRing>();
                    }
                    holes.add(this.geometryFactory.createLinearRing(this.parseKMLCoordinates(xmlStreamReader)));
                } else if (this.attributeNames.contains(elementName)) {
                    if (attributes == null) {
                        attributes = new HashMap<String, String>();
                    }
                    attributes.put(elementName, xmlStreamReader.getElementText());
                }
            }
            xmlStreamReader.next();
        }
        if (shell == null) {
            this.raiseParseError("No outer boundary for Polygon", new Object[0]);
        }
        Polygon polygon = this.geometryFactory.createPolygon(shell, holes == null ? null : holes.toArray(new LinearRing[0]));
        polygon.setUserData(attributes);
        return polygon;
    }

    private Geometry parseKMLMultiGeometry(XMLStreamReader xmlStreamReader) throws XMLStreamException, ParseException {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        String firstParsedType = null;
        boolean allTypesAreSame = true;
        while (xmlStreamReader.hasNext()) {
            if (xmlStreamReader.isStartElement()) {
                String elementName;
                switch (elementName = xmlStreamReader.getLocalName()) {
                    case "Point": 
                    case "LineString": 
                    case "Polygon": 
                    case "MultiGeometry": {
                        Geometry geometry = this.parseKML(xmlStreamReader);
                        if (firstParsedType == null) {
                            firstParsedType = geometry.getGeometryType();
                        } else if (!firstParsedType.equals(geometry.getGeometryType())) {
                            allTypesAreSame = false;
                        }
                        geometries.add(geometry);
                    }
                }
            }
            xmlStreamReader.next();
        }
        if (geometries.isEmpty()) {
            return null;
        }
        if (geometries.size() == 1) {
            return (Geometry)geometries.get(0);
        }
        if (allTypesAreSame) {
            switch (firstParsedType) {
                case "Point": {
                    return this.geometryFactory.createMultiPoint(this.prepareTypedArray(geometries, Point.class));
                }
                case "LineString": {
                    return this.geometryFactory.createMultiLineString(this.prepareTypedArray(geometries, LineString.class));
                }
                case "Polygon": {
                    return this.geometryFactory.createMultiPolygon(this.prepareTypedArray(geometries, Polygon.class));
                }
            }
            return this.geometryFactory.createGeometryCollection(geometries.toArray(new Geometry[0]));
        }
        return this.geometryFactory.createGeometryCollection(geometries.toArray(new Geometry[0]));
    }

    private Geometry parseKML(XMLStreamReader xmlStreamReader) throws XMLStreamException, ParseException {
        String elementName;
        boolean hasElement = false;
        while (xmlStreamReader.hasNext()) {
            if (xmlStreamReader.isStartElement()) {
                hasElement = true;
                break;
            }
            xmlStreamReader.next();
        }
        if (!hasElement) {
            this.raiseParseError("Invalid KML format", new Object[0]);
        }
        switch (elementName = xmlStreamReader.getLocalName()) {
            case "Point": {
                return this.parseKMLPoint(xmlStreamReader);
            }
            case "LineString": {
                return this.parseKMLLineString(xmlStreamReader);
            }
            case "Polygon": {
                return this.parseKMLPolygon(xmlStreamReader);
            }
            case "MultiGeometry": {
                xmlStreamReader.next();
                return this.parseKMLMultiGeometry(xmlStreamReader);
            }
        }
        this.raiseParseError("Unknown KML geometry type %s", elementName);
        return null;
    }

    private void moveToElement(XMLStreamReader xmlStreamReader, String elementName, String endElementName) throws XMLStreamException, ParseException {
        boolean elementFound = false;
        while (!(!xmlStreamReader.hasNext() || xmlStreamReader.isEndElement() && xmlStreamReader.getLocalName().equals(endElementName))) {
            if (xmlStreamReader.isStartElement() && xmlStreamReader.getLocalName().equals(elementName)) {
                elementFound = true;
                break;
            }
            xmlStreamReader.next();
        }
        if (!elementFound) {
            this.raiseParseError(NO_ELEMENT_ERROR, elementName, endElementName);
        }
    }

    private void raiseParseError(String template, Object ... parameters) throws ParseException {
        throw new ParseException(String.format(template, parameters));
    }

    private <T> T[] prepareTypedArray(List<Geometry> geometryList, Class<T> geomClass) {
        return geometryList.toArray((Object[])Array.newInstance(geomClass, geometryList.size()));
    }

    private static class KMLCoordinatesAndAttributes {
        private final Coordinate[] coordinates;
        private final Map<String, String> attributes;

        public KMLCoordinatesAndAttributes(Coordinate[] coordinates, Map<String, String> attributes) {
            this.coordinates = coordinates;
            this.attributes = attributes;
        }
    }
}

