/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.io;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequenceFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateXY;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateXYM;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateXYZM;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryCollection;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiLineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiPoint;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiPolygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import com.hazelcast.shaded.org.locationtech.jts.io.Ordinate;
import com.hazelcast.shaded.org.locationtech.jts.io.ParseException;
import com.hazelcast.shaded.org.locationtech.jts.util.Assert;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;

public class WKTReader {
    private static final String COMMA = ",";
    private static final String L_PAREN = "(";
    private static final String R_PAREN = ")";
    private static final String NAN_SYMBOL = "NaN";
    private GeometryFactory geometryFactory;
    private CoordinateSequenceFactory csFactory;
    private static CoordinateSequenceFactory csFactoryXYZM = CoordinateArraySequenceFactory.instance();
    private PrecisionModel precisionModel;
    private static final boolean ALLOW_OLD_JTS_COORDINATE_SYNTAX = true;
    private boolean isAllowOldJtsCoordinateSyntax = true;
    private static final boolean ALLOW_OLD_JTS_MULTIPOINT_SYNTAX = true;
    private boolean isAllowOldJtsMultipointSyntax = true;
    private boolean isFixStructure = false;

    public WKTReader() {
        this(new GeometryFactory());
    }

    public WKTReader(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.csFactory = geometryFactory.getCoordinateSequenceFactory();
        this.precisionModel = geometryFactory.getPrecisionModel();
    }

    public void setIsOldJtsCoordinateSyntaxAllowed(boolean value) {
        this.isAllowOldJtsCoordinateSyntax = value;
    }

    public void setIsOldJtsMultiPointSyntaxAllowed(boolean value) {
        this.isAllowOldJtsMultipointSyntax = value;
    }

    public void setFixStructure(boolean isFixStructure) {
        this.isFixStructure = isFixStructure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Geometry read(String wellKnownText) throws ParseException {
        try (StringReader reader = new StringReader(wellKnownText);){
            Geometry geometry = this.read(reader);
            return geometry;
        }
    }

    public Geometry read(Reader reader) throws ParseException {
        StreamTokenizer tokenizer = WKTReader.createTokenizer(reader);
        try {
            return this.readGeometryTaggedText(tokenizer);
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    private static StreamTokenizer createTokenizer(Reader reader) {
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.resetSyntax();
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(160, 255);
        tokenizer.wordChars(48, 57);
        tokenizer.wordChars(45, 45);
        tokenizer.wordChars(43, 43);
        tokenizer.wordChars(46, 46);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.commentChar(35);
        return tokenizer;
    }

    private Coordinate getCoordinate(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags, boolean tryParen) throws IOException, ParseException {
        boolean opened = false;
        if (tryParen && WKTReader.isOpenerNext(tokenizer)) {
            tokenizer.nextToken();
            opened = true;
        }
        int offsetM = ordinateFlags.contains((Object)Ordinate.Z) ? 1 : 0;
        Coordinate coord = this.createCoordinate(ordinateFlags);
        coord.setOrdinate(0, this.precisionModel.makePrecise(this.getNextNumber(tokenizer)));
        coord.setOrdinate(1, this.precisionModel.makePrecise(this.getNextNumber(tokenizer)));
        if (ordinateFlags.contains((Object)Ordinate.Z)) {
            coord.setOrdinate(2, this.getNextNumber(tokenizer));
        }
        if (ordinateFlags.contains((Object)Ordinate.M)) {
            coord.setOrdinate(2 + offsetM, this.getNextNumber(tokenizer));
        }
        if (ordinateFlags.size() == 2 && this.isAllowOldJtsCoordinateSyntax && WKTReader.isNumberNext(tokenizer)) {
            coord.setOrdinate(2, this.getNextNumber(tokenizer));
        }
        if (opened) {
            this.getNextCloser(tokenizer);
        }
        return coord;
    }

    private Coordinate createCoordinate(EnumSet<Ordinate> ordinateFlags) {
        boolean hasZ = ordinateFlags.contains((Object)Ordinate.Z);
        boolean hasM = ordinateFlags.contains((Object)Ordinate.M);
        if (hasZ && hasM) {
            return new CoordinateXYZM();
        }
        if (hasM) {
            return new CoordinateXYM();
        }
        if (hasZ || this.isAllowOldJtsCoordinateSyntax) {
            return new Coordinate();
        }
        return new CoordinateXY();
    }

    private CoordinateSequence getCoordinateSequence(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags, int minSize, boolean isRing) throws IOException, ParseException {
        if (WKTReader.getNextEmptyOrOpener(tokenizer).equals("EMPTY")) {
            return this.createCoordinateSequenceEmpty(ordinateFlags);
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        do {
            coordinates.add(this.getCoordinate(tokenizer, ordinateFlags, false));
        } while (WKTReader.getNextCloserOrComma(tokenizer).equals(COMMA));
        if (this.isFixStructure) {
            WKTReader.fixStructure(coordinates, minSize, isRing);
        }
        Coordinate[] coordArray = coordinates.toArray(new Coordinate[0]);
        return this.csFactory.create(coordArray);
    }

    private static void fixStructure(List<Coordinate> coords, int minSize, boolean isRing) {
        if (coords.size() == 0) {
            return;
        }
        if (isRing && !WKTReader.isClosed(coords)) {
            coords.add(coords.get(0).copy());
        }
        while (coords.size() < minSize) {
            coords.add(coords.get(coords.size() - 1).copy());
        }
    }

    private static boolean isClosed(List<Coordinate> coords) {
        if (coords.size() == 0) {
            return true;
        }
        return coords.size() != 1 && coords.get(0).equals2D(coords.get(coords.size() - 1));
    }

    private CoordinateSequence createCoordinateSequenceEmpty(EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        return this.csFactory.create(0, this.toDimension(ordinateFlags), ordinateFlags.contains((Object)Ordinate.M) ? 1 : 0);
    }

    private CoordinateSequence getCoordinateSequenceOldMultiPoint(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        do {
            coordinates.add(this.getCoordinate(tokenizer, ordinateFlags, true));
        } while (WKTReader.getNextCloserOrComma(tokenizer).equals(COMMA));
        Coordinate[] coordArray = coordinates.toArray(new Coordinate[0]);
        return this.csFactory.create(coordArray);
    }

    private int toDimension(EnumSet<Ordinate> ordinateFlags) {
        int dimension = 2;
        if (ordinateFlags.contains((Object)Ordinate.Z)) {
            ++dimension;
        }
        if (ordinateFlags.contains((Object)Ordinate.M)) {
            ++dimension;
        }
        if (dimension == 2 && this.isAllowOldJtsCoordinateSyntax) {
            ++dimension;
        }
        return dimension;
    }

    private static boolean isNumberNext(StreamTokenizer tokenizer) throws IOException {
        int type = tokenizer.nextToken();
        tokenizer.pushBack();
        return type == -3;
    }

    private static boolean isOpenerNext(StreamTokenizer tokenizer) throws IOException {
        int type = tokenizer.nextToken();
        tokenizer.pushBack();
        return type == 40;
    }

    private double getNextNumber(StreamTokenizer tokenizer) throws IOException, ParseException {
        int type = tokenizer.nextToken();
        switch (type) {
            case -3: {
                if (tokenizer.sval.equalsIgnoreCase(NAN_SYMBOL)) {
                    return Double.NaN;
                }
                try {
                    return Double.parseDouble(tokenizer.sval);
                }
                catch (NumberFormatException ex) {
                    throw WKTReader.parseErrorWithLine(tokenizer, "Invalid number: " + tokenizer.sval);
                }
            }
        }
        throw WKTReader.parseErrorExpected(tokenizer, "number");
    }

    private static String getNextEmptyOrOpener(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextWord = WKTReader.getNextWord(tokenizer);
        if (nextWord.equalsIgnoreCase("Z")) {
            nextWord = WKTReader.getNextWord(tokenizer);
        } else if (nextWord.equalsIgnoreCase("M")) {
            nextWord = WKTReader.getNextWord(tokenizer);
        } else if (nextWord.equalsIgnoreCase("ZM")) {
            nextWord = WKTReader.getNextWord(tokenizer);
        }
        if (nextWord.equals("EMPTY") || nextWord.equals(L_PAREN)) {
            return nextWord;
        }
        throw WKTReader.parseErrorExpected(tokenizer, "EMPTY or (");
    }

    private static EnumSet<Ordinate> getNextOrdinateFlags(StreamTokenizer tokenizer) throws IOException, ParseException {
        EnumSet<Ordinate> result = EnumSet.of(Ordinate.X, Ordinate.Y);
        String nextWord = WKTReader.lookAheadWord(tokenizer).toUpperCase(Locale.ROOT);
        if (nextWord.equalsIgnoreCase("Z")) {
            tokenizer.nextToken();
            result.add(Ordinate.Z);
        } else if (nextWord.equalsIgnoreCase("M")) {
            tokenizer.nextToken();
            result.add(Ordinate.M);
        } else if (nextWord.equalsIgnoreCase("ZM")) {
            tokenizer.nextToken();
            result.add(Ordinate.Z);
            result.add(Ordinate.M);
        }
        return result;
    }

    private static String lookAheadWord(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextWord = WKTReader.getNextWord(tokenizer);
        tokenizer.pushBack();
        return nextWord;
    }

    private static String getNextCloserOrComma(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextWord = WKTReader.getNextWord(tokenizer);
        if (nextWord.equals(COMMA) || nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        throw WKTReader.parseErrorExpected(tokenizer, ", or )");
    }

    private String getNextCloser(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextWord = WKTReader.getNextWord(tokenizer);
        if (nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        throw WKTReader.parseErrorExpected(tokenizer, R_PAREN);
    }

    private static String getNextWord(StreamTokenizer tokenizer) throws IOException, ParseException {
        int type = tokenizer.nextToken();
        switch (type) {
            case -3: {
                String word = tokenizer.sval;
                if (word.equalsIgnoreCase("EMPTY")) {
                    return "EMPTY";
                }
                return word;
            }
            case 40: {
                return L_PAREN;
            }
            case 41: {
                return R_PAREN;
            }
            case 44: {
                return COMMA;
            }
        }
        throw WKTReader.parseErrorExpected(tokenizer, "word");
    }

    private static ParseException parseErrorExpected(StreamTokenizer tokenizer, String expected) {
        if (tokenizer.ttype == -2) {
            Assert.shouldNeverReachHere("Unexpected NUMBER token");
        }
        if (tokenizer.ttype == 10) {
            Assert.shouldNeverReachHere("Unexpected EOL token");
        }
        String tokenStr = WKTReader.tokenString(tokenizer);
        return WKTReader.parseErrorWithLine(tokenizer, "Expected " + expected + " but found " + tokenStr);
    }

    private static ParseException parseErrorWithLine(StreamTokenizer tokenizer, String msg) {
        return new ParseException(msg + " (line " + tokenizer.lineno() + R_PAREN);
    }

    private static String tokenString(StreamTokenizer tokenizer) {
        switch (tokenizer.ttype) {
            case -2: {
                return "<NUMBER>";
            }
            case 10: {
                return "End-of-Line";
            }
            case -1: {
                return "End-of-Stream";
            }
            case -3: {
                return "'" + tokenizer.sval + "'";
            }
        }
        return "'" + (char)tokenizer.ttype + "'";
    }

    private Geometry readGeometryTaggedText(StreamTokenizer tokenizer) throws IOException, ParseException {
        EnumSet<Ordinate> ordinateFlags = EnumSet.of(Ordinate.X, Ordinate.Y);
        String type = WKTReader.getNextWord(tokenizer).toUpperCase(Locale.ROOT);
        if (type.endsWith("ZM")) {
            ordinateFlags.add(Ordinate.Z);
            ordinateFlags.add(Ordinate.M);
        } else if (type.endsWith("Z")) {
            ordinateFlags.add(Ordinate.Z);
        } else if (type.endsWith("M")) {
            ordinateFlags.add(Ordinate.M);
        }
        return this.readGeometryTaggedText(tokenizer, type, ordinateFlags);
    }

    private Geometry readGeometryTaggedText(StreamTokenizer tokenizer, String type, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        if (ordinateFlags.size() == 2) {
            ordinateFlags = WKTReader.getNextOrdinateFlags(tokenizer);
        }
        try {
            this.csFactory.create(0, this.toDimension(ordinateFlags), ordinateFlags.contains((Object)Ordinate.M) ? 1 : 0);
        }
        catch (Exception e) {
            this.geometryFactory = new GeometryFactory(this.geometryFactory.getPrecisionModel(), this.geometryFactory.getSRID(), csFactoryXYZM);
        }
        if (this.isTypeName(tokenizer, type, "POINT")) {
            return this.readPointText(tokenizer, ordinateFlags);
        }
        if (this.isTypeName(tokenizer, type, "LINESTRING")) {
            return this.readLineStringText(tokenizer, ordinateFlags);
        }
        if (this.isTypeName(tokenizer, type, "LINEARRING")) {
            return this.readLinearRingText(tokenizer, ordinateFlags);
        }
        if (this.isTypeName(tokenizer, type, "POLYGON")) {
            return this.readPolygonText(tokenizer, ordinateFlags);
        }
        if (this.isTypeName(tokenizer, type, "MULTIPOINT")) {
            return this.readMultiPointText(tokenizer, ordinateFlags);
        }
        if (this.isTypeName(tokenizer, type, "MULTILINESTRING")) {
            return this.readMultiLineStringText(tokenizer, ordinateFlags);
        }
        if (this.isTypeName(tokenizer, type, "MULTIPOLYGON")) {
            return this.readMultiPolygonText(tokenizer, ordinateFlags);
        }
        if (this.isTypeName(tokenizer, type, "GEOMETRYCOLLECTION")) {
            return this.readGeometryCollectionText(tokenizer, ordinateFlags);
        }
        throw WKTReader.parseErrorWithLine(tokenizer, "Unknown geometry type: " + type);
    }

    private boolean isTypeName(StreamTokenizer tokenizer, String type, String typeName) throws ParseException {
        boolean isValidMod;
        if (!type.startsWith(typeName)) {
            return false;
        }
        String modifiers = type.substring(typeName.length());
        boolean bl = isValidMod = modifiers.length() <= 2 && (modifiers.length() == 0 || modifiers.equals("Z") || modifiers.equals("M") || modifiers.equals("ZM"));
        if (!isValidMod) {
            throw WKTReader.parseErrorWithLine(tokenizer, "Invalid dimension modifiers: " + type);
        }
        return true;
    }

    private Point readPointText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        Point point = this.geometryFactory.createPoint(this.getCoordinateSequence(tokenizer, ordinateFlags, 1, false));
        return point;
    }

    private LineString readLineStringText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        return this.geometryFactory.createLineString(this.getCoordinateSequence(tokenizer, ordinateFlags, 2, false));
    }

    private LinearRing readLinearRingText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        return this.geometryFactory.createLinearRing(this.getCoordinateSequence(tokenizer, ordinateFlags, 3, true));
    }

    private MultiPoint readMultiPointText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        String nextWord;
        String nextToken = WKTReader.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals("EMPTY")) {
            return this.geometryFactory.createMultiPoint(new Point[0]);
        }
        if (this.isAllowOldJtsMultipointSyntax && (nextWord = WKTReader.lookAheadWord(tokenizer)) != L_PAREN && nextWord != "EMPTY") {
            return this.geometryFactory.createMultiPoint(this.getCoordinateSequenceOldMultiPoint(tokenizer, ordinateFlags));
        }
        ArrayList<Point> points = new ArrayList<Point>();
        Point point = this.readPointText(tokenizer, ordinateFlags);
        points.add(point);
        nextToken = WKTReader.getNextCloserOrComma(tokenizer);
        while (nextToken.equals(COMMA)) {
            point = this.readPointText(tokenizer, ordinateFlags);
            points.add(point);
            nextToken = WKTReader.getNextCloserOrComma(tokenizer);
        }
        Point[] array = new Point[points.size()];
        return this.geometryFactory.createMultiPoint(points.toArray(array));
    }

    private Polygon readPolygonText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        String nextToken = WKTReader.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals("EMPTY")) {
            return this.geometryFactory.createPolygon(this.createCoordinateSequenceEmpty(ordinateFlags));
        }
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        LinearRing shell = this.readLinearRingText(tokenizer, ordinateFlags);
        nextToken = WKTReader.getNextCloserOrComma(tokenizer);
        while (nextToken.equals(COMMA)) {
            LinearRing hole = this.readLinearRingText(tokenizer, ordinateFlags);
            holes.add(hole);
            nextToken = WKTReader.getNextCloserOrComma(tokenizer);
        }
        LinearRing[] array = new LinearRing[holes.size()];
        return this.geometryFactory.createPolygon(shell, holes.toArray(array));
    }

    private MultiLineString readMultiLineStringText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        String nextToken = WKTReader.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals("EMPTY")) {
            return this.geometryFactory.createMultiLineString();
        }
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        do {
            LineString lineString = this.readLineStringText(tokenizer, ordinateFlags);
            lineStrings.add(lineString);
        } while ((nextToken = WKTReader.getNextCloserOrComma(tokenizer)).equals(COMMA));
        LineString[] array = new LineString[lineStrings.size()];
        return this.geometryFactory.createMultiLineString(lineStrings.toArray(array));
    }

    private MultiPolygon readMultiPolygonText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        String nextToken = WKTReader.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals("EMPTY")) {
            return this.geometryFactory.createMultiPolygon();
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        do {
            Polygon polygon = this.readPolygonText(tokenizer, ordinateFlags);
            polygons.add(polygon);
        } while ((nextToken = WKTReader.getNextCloserOrComma(tokenizer)).equals(COMMA));
        Polygon[] array = new Polygon[polygons.size()];
        return this.geometryFactory.createMultiPolygon(polygons.toArray(array));
    }

    private GeometryCollection readGeometryCollectionText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        String nextToken = WKTReader.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals("EMPTY")) {
            return this.geometryFactory.createGeometryCollection();
        }
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        do {
            Geometry geometry = this.readGeometryTaggedText(tokenizer);
            geometries.add(geometry);
        } while ((nextToken = WKTReader.getNextCloserOrComma(tokenizer)).equals(COMMA));
        Geometry[] array = new Geometry[geometries.size()];
        return this.geometryFactory.createGeometryCollection(geometries.toArray(array));
    }
}

