/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.integration;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.integration.BaseAbstractUnivariateIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.TooManyEvaluationsException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;

public class TrapezoidIntegrator
extends BaseAbstractUnivariateIntegrator {
    public static final int TRAPEZOID_MAX_ITERATIONS_COUNT = 64;
    private double s;

    public TrapezoidIntegrator(double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) throws NotStrictlyPositiveException, NumberIsTooSmallException, NumberIsTooLargeException {
        super(relativeAccuracy, absoluteAccuracy, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 64) {
            throw new NumberIsTooLargeException(maximalIterationCount, (Number)64, false);
        }
    }

    public TrapezoidIntegrator(int minimalIterationCount, int maximalIterationCount) throws NotStrictlyPositiveException, NumberIsTooSmallException, NumberIsTooLargeException {
        super(minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 64) {
            throw new NumberIsTooLargeException(maximalIterationCount, (Number)64, false);
        }
    }

    public TrapezoidIntegrator() {
        super(3, 64);
    }

    double stage(BaseAbstractUnivariateIntegrator baseIntegrator, int n) throws TooManyEvaluationsException {
        if (n == 0) {
            double max = baseIntegrator.getMax();
            double min2 = baseIntegrator.getMin();
            this.s = 0.5 * (max - min2) * (baseIntegrator.computeObjectiveValue(min2) + baseIntegrator.computeObjectiveValue(max));
            return this.s;
        }
        long np = 1L << n - 1;
        double sum = 0.0;
        double max = baseIntegrator.getMax();
        double min3 = baseIntegrator.getMin();
        double spacing = (max - min3) / (double)np;
        double x = min3 + 0.5 * spacing;
        for (long i = 0L; i < np; ++i) {
            sum += baseIntegrator.computeObjectiveValue(x);
            x += spacing;
        }
        this.s = 0.5 * (this.s + sum * spacing);
        return this.s;
    }

    protected double doIntegrate() throws MathIllegalArgumentException, TooManyEvaluationsException, MaxCountExceededException {
        double oldt = this.stage(this, 0);
        this.incrementCount();
        while (true) {
            double rLimit;
            double delta;
            int i = this.getIterations();
            double t2 = this.stage(this, i);
            if (i >= this.getMinimalIterationCount() && ((delta = FastMath.abs(t2 - oldt)) <= (rLimit = this.getRelativeAccuracy() * (FastMath.abs(oldt) + FastMath.abs(t2)) * 0.5) || delta <= this.getAbsoluteAccuracy())) {
                return t2;
            }
            oldt = t2;
            this.incrementCount();
        }
    }
}

