/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.util;

import com.hazelcast.shaded.org.apache.calcite.util.CaseInsensitiveComparator;
import com.hazelcast.shaded.org.apache.calcite.util.NameMap;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.stream.Collectors;

public class NameMultimap<V> {
    private final NameMap<List<V>> map;

    private NameMultimap(NameMap<List<V>> map) {
        this.map = map;
        assert (map.map().comparator() == CaseInsensitiveComparator.COMPARATOR);
    }

    public NameMultimap() {
        this(new NameMap<List<V>>());
    }

    public String toString() {
        return this.map.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof NameMultimap && this.map.equals(((NameMultimap)obj).map);
    }

    public void put(String name, V v) {
        List list = this.map().computeIfAbsent(name, k -> new ArrayList());
        list.add(v);
    }

    public boolean remove(String key, V value) {
        List list = (List)this.map().get(key);
        if (list == null) {
            return false;
        }
        return list.remove(value);
    }

    public Collection<Map.Entry<String, V>> range(String name, boolean caseSensitive) {
        NavigableMap<String, List<V>> range = this.map.range(name, caseSensitive);
        List result = range.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> Pair.of(e.getKey(), v))).collect(Collectors.toList());
        return Collections.unmodifiableList(result);
    }

    public boolean containsKey(String name, boolean caseSensitive) {
        return this.map.containsKey(name, caseSensitive);
    }

    public NavigableMap<String, List<V>> map() {
        return this.map.map();
    }
}

