/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.tools;

import com.hazelcast.shaded.org.apache.calcite.interpreter.Bindables;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.rel.RelHomogeneousShuttle;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalTableScan;
import com.hazelcast.shaded.org.apache.calcite.tools.RelRunner;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class RelRunners {
    private RelRunners() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PreparedStatement run(RelNode rel) {
        RelHomogeneousShuttle shuttle = new RelHomogeneousShuttle(){

            @Override
            public RelNode visit(TableScan scan) {
                RelOptTable table = scan.getTable();
                if (scan instanceof LogicalTableScan && Bindables.BindableTableScan.canHandle(table)) {
                    return Bindables.BindableTableScan.create(scan.getCluster(), table);
                }
                return super.visit(scan);
            }
        };
        rel = rel.accept(shuttle);
        try (Connection connection = DriverManager.getConnection("jdbc:calcite:");){
            RelRunner runner = connection.unwrap(RelRunner.class);
            PreparedStatement preparedStatement = runner.prepareStatement(rel);
            return preparedStatement;
        }
        catch (SQLException e) {
            throw Util.throwAsRuntime(e);
        }
    }
}

