/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.validate;

import com.hazelcast.shaded.com.google.common.collect.Iterables;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWindow;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlBasicVisitor;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.AggregatingScope;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.AggregatingSelectScope;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SelectScope;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlQualified;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.util.Litmus;
import com.hazelcast.shaded.org.apache.calcite.util.Static;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Objects;

class AggChecker
extends SqlBasicVisitor<Void> {
    private final Deque<SqlValidatorScope> scopes = new ArrayDeque<SqlValidatorScope>();
    private final List<SqlNode> extraExprs;
    private final List<SqlNode> measureExprs;
    private final List<SqlNode> groupExprs;
    private final boolean distinct;
    private final SqlValidatorImpl validator;

    AggChecker(SqlValidatorImpl validator, AggregatingScope scope, List<SqlNode> extraExprs, List<SqlNode> measureExprs, List<SqlNode> groupExprs, boolean distinct) {
        this.validator = validator;
        this.extraExprs = extraExprs;
        this.measureExprs = measureExprs;
        this.groupExprs = groupExprs;
        this.distinct = distinct;
        this.scopes.push(scope);
    }

    boolean isGroupExpr(SqlNode e) {
        for (SqlNode expr : Iterables.concat(this.extraExprs, this.measureExprs, this.groupExprs)) {
            if (!expr.equalsDeep(e, Litmus.IGNORE)) continue;
            return true;
        }
        return false;
    }

    boolean isMeasureExp(SqlNode e) {
        for (SqlNode expr : this.measureExprs) {
            if (!expr.equalsDeep(e, Litmus.IGNORE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Void visit(SqlIdentifier id) {
        if (id.isStar()) {
            return null;
        }
        if (!this.validator.config().nakedMeasures() && this.isMeasureExp(id)) {
            SqlNode originalExpr = this.validator.getOriginal(id);
            throw this.validator.newValidationError(originalExpr, Static.RESOURCE.measureIllegal());
        }
        if (this.isGroupExpr(id)) {
            return null;
        }
        SqlCall call = this.validator.makeNullaryCall(id);
        if (call != null) {
            return call.accept(this);
        }
        SqlQualified fqId = this.scopes.getFirst().fullyQualify(id);
        if (this.isGroupExpr(fqId.identifier)) {
            return null;
        }
        SqlNode originalExpr = this.validator.getOriginal(id);
        String exprString = originalExpr.toString();
        throw this.validator.newValidationError(originalExpr, this.distinct ? Static.RESOURCE.notSelectDistinctExpr(exprString) : Static.RESOURCE.notGroupExpr(exprString));
    }

    @Override
    public Void visit(SqlCall call) {
        SqlValidatorScope scope = Objects.requireNonNull(this.scopes.peek(), () -> "scope for " + call);
        if (call.getOperator().isAggregator()) {
            if (this.distinct) {
                if (scope instanceof AggregatingSelectScope) {
                    SqlSelect select = (SqlSelect)scope.getNode();
                    SelectScope selectScope = Objects.requireNonNull(this.validator.getRawSelectScope(select), () -> "rawSelectScope for " + scope.getNode());
                    List<SqlNode> selectList = Objects.requireNonNull(selectScope.getExpandedSelectList(), () -> "expandedSelectList for " + selectScope);
                    for (SqlNode sqlNode : selectList) {
                        if (sqlNode.getKind() == SqlKind.AS) {
                            sqlNode = ((SqlCall)sqlNode).operand(0);
                        }
                        if (!this.validator.expand(sqlNode, scope).equalsDeep((SqlNode)call, Litmus.IGNORE)) continue;
                        return null;
                    }
                }
                SqlNode originalExpr = this.validator.getOriginal(call);
                String exprString = originalExpr.toString();
                throw this.validator.newValidationError(call, Static.RESOURCE.notSelectDistinctExpr(exprString));
            }
            return null;
        }
        switch (call.getKind()) {
            case FILTER: 
            case WITHIN_GROUP: 
            case RESPECT_NULLS: 
            case IGNORE_NULLS: 
            case WITHIN_DISTINCT: {
                ((SqlNode)call.operand(0)).accept(this);
                return null;
            }
        }
        if (call.getKind() == SqlKind.OVER) {
            for (SqlNode operand : ((SqlCall)call.operand(0)).getOperandList()) {
                operand.accept(this);
            }
            Object over = call.operand(1);
            if (over instanceof SqlCall) {
                ((SqlNode)over).accept(this);
            } else if (over instanceof SqlIdentifier) {
                SqlWindow window = scope.lookupWindow(((SqlIdentifier)over).getSimple());
                Objects.requireNonNull(window, () -> "window for " + call);
                window.getPartitionList().accept(this);
                window.getOrderList().accept(this);
            }
        }
        if (this.isGroupExpr(call)) {
            return null;
        }
        SqlCall groupCall = SqlStdOperatorTable.convertAuxiliaryToGroupCall(call);
        if (groupCall != null) {
            if (this.isGroupExpr(groupCall)) {
                return null;
            }
            throw this.validator.newValidationError(groupCall, Static.RESOURCE.auxiliaryWithoutMatchingGroupCall(call.getOperator().getName(), groupCall.getOperator().getName()));
        }
        if (call.isA(SqlKind.QUERY)) {
            return null;
        }
        SqlValidatorScope newScope = scope.getOperandScope(call);
        this.scopes.push(newScope);
        call.getOperator().acceptCall(this, call, true, SqlBasicVisitor.ArgHandlerImpl.instance());
        this.scopes.pop();
        return null;
    }
}

