/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.util;

import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDataTypeSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlBasicVisitor;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlVisitor;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.List;

public class SqlShuttle
extends SqlBasicVisitor<SqlNode> {
    @Override
    public @Nullable SqlNode visit(SqlLiteral literal) {
        return literal;
    }

    @Override
    public @Nullable SqlNode visit(SqlIdentifier id) {
        return id;
    }

    @Override
    public @Nullable SqlNode visit(SqlDataTypeSpec type) {
        return type;
    }

    @Override
    public @Nullable SqlNode visit(SqlDynamicParam param) {
        return param;
    }

    @Override
    public @Nullable SqlNode visit(SqlIntervalQualifier intervalQualifier) {
        return intervalQualifier;
    }

    @Override
    public @Nullable SqlNode visit(SqlCall call) {
        CallCopyingArgHandler argHandler = new CallCopyingArgHandler(call, false);
        call.getOperator().acceptCall(this, call, false, argHandler);
        return argHandler.result();
    }

    @Override
    public @Nullable SqlNode visit(SqlNodeList nodeList) {
        boolean update = false;
        ArrayList<@Nullable SqlNode> newList = new ArrayList<SqlNode>(nodeList.size());
        for (SqlNode operand : nodeList) {
            SqlNode clonedOperand;
            if (operand == null) {
                clonedOperand = null;
            } else {
                clonedOperand = operand.accept(this);
                if (clonedOperand != operand) {
                    update = true;
                }
            }
            newList.add(clonedOperand);
        }
        if (update) {
            return SqlNodeList.of(nodeList.getParserPosition(), newList);
        }
        return nodeList;
    }

    protected class CallCopyingArgHandler
    implements SqlBasicVisitor.ArgHandler<SqlNode> {
        boolean update;
        @Nullable SqlNode[] clonedOperands;
        private final SqlCall call;
        private final boolean alwaysCopy;

        public CallCopyingArgHandler(SqlCall call, boolean alwaysCopy) {
            this.call = call;
            this.update = false;
            List<@Nullable SqlNode> operands = call.getOperandList();
            this.clonedOperands = operands.toArray(new SqlNode[0]);
            this.alwaysCopy = alwaysCopy;
        }

        @Override
        public SqlNode result() {
            if (this.update || this.alwaysCopy) {
                return this.call.getOperator().createCall(this.call.getFunctionQuantifier(), this.call.getParserPosition(), this.clonedOperands);
            }
            return this.call;
        }

        @Override
        public @Nullable SqlNode visitChild(SqlVisitor<@Nullable SqlNode> visitor, SqlNode expr, int i, @Nullable SqlNode operand) {
            if (operand == null) {
                return null;
            }
            SqlNode newOperand = operand.accept(SqlShuttle.this);
            if (newOperand != operand) {
                this.update = true;
            }
            this.clonedOperands[i] = newOperand;
            return newOperand;
        }
    }
}

