/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql;

import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlInsert;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUpdate;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableNullableList;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.shaded.org.checkerframework.dataflow.qual.Pure;
import java.util.List;

public class SqlMerge
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("MERGE", SqlKind.MERGE);
    SqlNode targetTable;
    SqlNode condition;
    SqlNode source;
    @Nullable SqlUpdate updateCall;
    @Nullable SqlInsert insertCall;
    @Nullable SqlSelect sourceSelect;
    @Nullable SqlIdentifier alias;

    public SqlMerge(SqlParserPos pos, SqlNode targetTable, SqlNode condition, SqlNode source, @Nullable SqlUpdate updateCall, @Nullable SqlInsert insertCall, @Nullable SqlSelect sourceSelect, @Nullable SqlIdentifier alias) {
        super(pos);
        this.targetTable = targetTable;
        this.condition = condition;
        this.source = source;
        this.updateCall = updateCall;
        this.insertCall = insertCall;
        this.sourceSelect = sourceSelect;
        this.alias = alias;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.MERGE;
    }

    @Override
    public List<@Nullable SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.targetTable, this.condition, this.source, this.updateCall, this.insertCall, this.sourceSelect, this.alias);
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                assert (operand instanceof SqlIdentifier);
                this.targetTable = operand;
                break;
            }
            case 1: {
                this.condition = operand;
                break;
            }
            case 2: {
                this.source = operand;
                break;
            }
            case 3: {
                this.updateCall = (SqlUpdate)operand;
                break;
            }
            case 4: {
                this.insertCall = (SqlInsert)operand;
                break;
            }
            case 5: {
                this.sourceSelect = (SqlSelect)operand;
                break;
            }
            case 6: {
                this.alias = (SqlIdentifier)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public SqlNode getTargetTable() {
        return this.targetTable;
    }

    @Pure
    public @Nullable SqlIdentifier getAlias() {
        return this.alias;
    }

    public SqlNode getSourceTableRef() {
        return this.source;
    }

    public void setSourceTableRef(SqlNode tableRef) {
        this.source = tableRef;
    }

    public @Nullable SqlUpdate getUpdateCall() {
        return this.updateCall;
    }

    public @Nullable SqlInsert getInsertCall() {
        return this.insertCall;
    }

    public SqlNode getCondition() {
        return this.condition;
    }

    public @Nullable SqlSelect getSourceSelect() {
        return this.sourceSelect;
    }

    public void setSourceSelect(SqlSelect sourceSelect) {
        this.sourceSelect = sourceSelect;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlInsert insertCall;
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SELECT, "MERGE INTO", "");
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.targetTable.unparse(writer, opLeft, opRight);
        SqlIdentifier alias = this.alias;
        if (alias != null) {
            writer.keyword("AS");
            alias.unparse(writer, opLeft, opRight);
        }
        writer.newlineAndIndent();
        writer.keyword("USING");
        this.source.unparse(writer, opLeft, opRight);
        writer.newlineAndIndent();
        writer.keyword("ON");
        this.condition.unparse(writer, opLeft, opRight);
        SqlUpdate updateCall = this.updateCall;
        if (updateCall != null) {
            writer.newlineAndIndent();
            writer.keyword("WHEN MATCHED THEN UPDATE");
            SqlWriter.Frame setFrame = writer.startList(SqlWriter.FrameTypeEnum.UPDATE_SET_LIST, "SET", "");
            for (Pair<SqlNode, SqlNode> pair : Pair.zip(updateCall.targetColumnList, updateCall.sourceExpressionList)) {
                writer.sep(",");
                SqlIdentifier id = (SqlIdentifier)pair.left;
                id.unparse(writer, opLeft, opRight);
                writer.keyword("=");
                SqlNode sourceExp = (SqlNode)pair.right;
                sourceExp.unparse(writer, opLeft, opRight);
            }
            writer.endList(setFrame);
        }
        if ((insertCall = this.insertCall) != null) {
            writer.newlineAndIndent();
            writer.keyword("WHEN NOT MATCHED THEN INSERT");
            SqlNodeList targetColumnList = insertCall.getTargetColumnList();
            if (targetColumnList != null) {
                targetColumnList.unparse(writer, opLeft, opRight);
            }
            insertCall.getSource().unparse(writer, 0, 0);
            writer.endList(frame);
        }
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateMerge(this);
    }
}

