/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql;

import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlBinaryOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.hazelcast.shaded.org.apache.calcite.util.Static;
import java.util.Objects;

public class SqlFilterOperator
extends SqlBinaryOperator {
    public SqlFilterOperator() {
        super("FILTER", SqlKind.FILTER, 20, true, ReturnTypes.ARG0_FORCE_NULLABLE, null, (SqlOperandTypeChecker)OperandTypes.ANY_ANY);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, this.getLeftPrec());
        writer.sep(this.getName());
        writer.sep("(");
        writer.sep("WHERE");
        ((SqlNode)call.operand(1)).unparse(writer, this.getRightPrec(), rightPrec);
        writer.sep(")");
        writer.endList(frame);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        assert (call.operandCount() == 2);
        SqlValidatorUtil.FlatAggregate flat = SqlValidatorUtil.flatten(call);
        SqlCall aggCall = flat.aggregateCall;
        if (!aggCall.getOperator().isAggregator()) {
            throw validator.newValidationError(aggCall, Static.RESOURCE.filterNonAggregate());
        }
        validator.validateAggregateParams(aggCall, flat.filter, flat.distinctList, flat.orderList, scope);
        SqlNode filter = Objects.requireNonNull(flat.filter);
        RelDataType type = validator.deriveType(scope, filter);
        if (!SqlTypeUtil.inBooleanFamily(type)) {
            throw validator.newValidationError(filter, Static.RESOURCE.condMustBeBoolean("FILTER"));
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        this.validateOperands(validator, scope, call);
        SqlValidatorUtil.FlatAggregate flat = SqlValidatorUtil.flatten(call);
        SqlCall aggCall = flat.aggregateCall;
        SqlCallBinding opBinding = new SqlCallBinding(validator, scope, aggCall){

            @Override
            public int getGroupCount() {
                return 0;
            }
        };
        RelDataType ret = aggCall.getOperator().inferReturnType(opBinding);
        SqlValidatorImpl validator1 = (SqlValidatorImpl)validator;
        validator1.setValidatedNodeType(call, ret);
        validator1.setValidatedNodeType(aggCall, ret);
        if (flat.distinctList != null) {
            validator1.setValidatedNodeType(Objects.requireNonNull(flat.distinctCall), ret);
        }
        if (flat.orderList != null) {
            validator1.setValidatedNodeType(Objects.requireNonNull(flat.orderCall), ret);
        }
        return ret;
    }
}

