/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.type;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.com.google.common.collect.Iterables;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeComparability;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFamily;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelProtoDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.StructKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCollation;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class RelDataTypeImpl
implements RelDataType,
RelDataTypeFamily {
    public static final String NON_NULLABLE_SUFFIX = " NOT NULL";
    protected final @Nullable List<RelDataTypeField> fieldList;
    protected @Nullable String digest;

    protected RelDataTypeImpl(@Nullable List<? extends RelDataTypeField> fieldList) {
        this.fieldList = fieldList != null ? ImmutableList.copyOf(fieldList) : null;
    }

    protected RelDataTypeImpl() {
        this(null);
    }

    @Override
    public @Nullable RelDataTypeField getField(String fieldName, boolean caseSensitive, boolean elideRecord) {
        RelDataTypeField lastField;
        if (this.fieldList == null) {
            throw new IllegalStateException("Trying to access field " + fieldName + " in a type with no fields: " + this);
        }
        Map<String, RelDataTypeField> fieldMap = this.getFieldMap();
        if (caseSensitive && fieldMap != null) {
            RelDataTypeField field = fieldMap.get(fieldName);
            if (field != null) {
                return field;
            }
        } else {
            for (RelDataTypeField relDataTypeField : this.fieldList) {
                if (!Util.matches(caseSensitive, relDataTypeField.getName(), fieldName)) continue;
                return relDataTypeField;
            }
        }
        if (elideRecord) {
            ArrayList<Slot> slots = new ArrayList<Slot>();
            RelDataTypeImpl.getFieldRecurse(slots, this, 0, fieldName, caseSensitive);
            block5: for (Slot slot : slots) {
                switch (slot.count) {
                    case 0: {
                        continue block5;
                    }
                    case 1: {
                        return slot.field;
                    }
                }
                break;
            }
        }
        if (this.fieldList.size() > 0 && (lastField = Iterables.getLast(this.fieldList)).getName().equals("_extra")) {
            return new RelDataTypeFieldImpl(fieldName, -1, lastField.getType());
        }
        if (fieldMap != null) {
            return fieldMap.get("");
        }
        for (RelDataTypeField relDataTypeField : this.fieldList) {
            if (!relDataTypeField.isDynamicStar()) continue;
            return relDataTypeField;
        }
        return null;
    }

    protected @Nullable Map<String, RelDataTypeField> getFieldMap() {
        return null;
    }

    private static void getFieldRecurse(List<Slot> slots, RelDataType type, int depth, String fieldName, boolean caseSensitive) {
        while (slots.size() <= depth) {
            slots.add(new Slot());
        }
        Slot slot = slots.get(depth);
        for (RelDataTypeField field : type.getFieldList()) {
            if (!Util.matches(caseSensitive, field.getName(), fieldName)) continue;
            ++slot.count;
            slot.field = field;
        }
        if (slot.count == 0) {
            for (RelDataTypeField field : type.getFieldList()) {
                if (!field.getType().isStruct()) continue;
                RelDataTypeImpl.getFieldRecurse(slots, field.getType(), depth + 1, fieldName, caseSensitive);
            }
        }
    }

    @Override
    public List<RelDataTypeField> getFieldList() {
        assert (this.fieldList != null) : "fieldList must not be null, type = " + this;
        return this.fieldList;
    }

    @Override
    public List<String> getFieldNames() {
        assert (this.fieldList != null) : "fieldList must not be null, type = " + this;
        return Pair.left(this.fieldList);
    }

    @Override
    public int getFieldCount() {
        assert (this.fieldList != null) : "fieldList must not be null, type = " + this;
        return this.fieldList.size();
    }

    @Override
    public StructKind getStructKind() {
        return this.isStruct() ? StructKind.FULLY_QUALIFIED : StructKind.NONE;
    }

    @Override
    public @Nullable RelDataType getComponentType() {
        return null;
    }

    @Override
    public @Nullable RelDataType getKeyType() {
        return null;
    }

    @Override
    public @Nullable RelDataType getValueType() {
        return null;
    }

    @Override
    public boolean isStruct() {
        return this.fieldList != null;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof RelDataTypeImpl && Objects.equals(this.digest, ((RelDataTypeImpl)obj).digest);
    }

    public int hashCode() {
        return Objects.hashCode(this.digest);
    }

    @Override
    public String getFullTypeString() {
        return Objects.requireNonNull(this.digest, "digest");
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public @Nullable Charset getCharset() {
        return null;
    }

    @Override
    public @Nullable SqlCollation getCollation() {
        return null;
    }

    @Override
    public @Nullable SqlIntervalQualifier getIntervalQualifier() {
        return null;
    }

    @Override
    public int getPrecision() {
        return -1;
    }

    @Override
    public int getScale() {
        return Integer.MIN_VALUE;
    }

    @Override
    public SqlTypeName getSqlTypeName() {
        return Nullness.castNonNull(null);
    }

    @Override
    public @Nullable SqlIdentifier getSqlIdentifier() {
        SqlTypeName typeName = this.getSqlTypeName();
        if (typeName == null) {
            return null;
        }
        return new SqlIdentifier(typeName.name(), SqlParserPos.ZERO);
    }

    @Override
    public RelDataTypeFamily getFamily() {
        return this;
    }

    protected abstract void generateTypeString(StringBuilder var1, boolean var2);

    protected void computeDigest(@UnknownInitialization RelDataTypeImpl this) {
        StringBuilder sb = new StringBuilder();
        this.generateTypeString(sb, true);
        if (!this.isNullable()) {
            sb.append(NON_NULLABLE_SUFFIX);
        }
        this.digest = sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.generateTypeString(sb, false);
        return sb.toString();
    }

    @Override
    public RelDataTypePrecedenceList getPrecedenceList() {
        return new RelDataTypePrecedenceList(){

            @Override
            public boolean containsType(RelDataType type) {
                return RelDataTypeImpl.this.getFamily() == type.getFamily();
            }

            @Override
            public int compareTypePrecedence(RelDataType type1, RelDataType type2) {
                assert (this.containsType(type1));
                assert (this.containsType(type2));
                return 0;
            }
        };
    }

    @Override
    public RelDataTypeComparability getComparability() {
        return RelDataTypeComparability.ALL;
    }

    public static RelProtoDataType proto(RelDataType protoType) {
        assert (protoType != null);
        return typeFactory -> typeFactory.copyType(protoType);
    }

    public static RelProtoDataType proto(SqlTypeName typeName, boolean nullable) {
        assert (typeName != null);
        return typeFactory -> {
            RelDataType type = typeFactory.createSqlType(typeName);
            return typeFactory.createTypeWithNullability(type, nullable);
        };
    }

    public static RelProtoDataType proto(SqlTypeName typeName, int precision, boolean nullable) {
        assert (typeName != null);
        return typeFactory -> {
            RelDataType type = typeFactory.createSqlType(typeName, precision);
            return typeFactory.createTypeWithNullability(type, nullable);
        };
    }

    public static RelProtoDataType proto(SqlTypeName typeName, int precision, int scale, boolean nullable) {
        return typeFactory -> {
            RelDataType type = typeFactory.createSqlType(typeName, precision, scale);
            return typeFactory.createTypeWithNullability(type, nullable);
        };
    }

    public static @Nullable RelDataTypeField extra(RelDataType rowType) {
        return rowType.getField("_extra", true, false);
    }

    @Override
    public boolean isDynamicStruct() {
        return false;
    }

    private static class Slot {
        int count;
        @Nullable RelDataTypeField field;

        private Slot() {
        }
    }
}

