/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.rules;

import com.hazelcast.shaded.com.google.common.collect.ImmutableCollection;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.shaded.org.apache.calcite.rel.core.AggregateCall;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Filter;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.ImmutableAggregateFilterTransposeRule;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlAggFunction;
import com.hazelcast.shaded.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.shaded.org.apache.calcite.util.mapping.Mappings;
import java.util.ArrayList;
import java.util.List;
import org.immutables.value.Value;

@Value.Enclosing
public class AggregateFilterTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected AggregateFilterTransposeRule(Config config) {
        super(config);
    }

    @Deprecated
    public AggregateFilterTransposeRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).withOperandSupplier(b -> b.exactly(operand)).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Filter filter = (Filter)call.rel(1);
        ImmutableBitSet filterColumns = RelOptUtil.InputFinder.bits(filter.getCondition());
        ImmutableBitSet newGroupSet = aggregate.getGroupSet().union(filterColumns);
        RelNode input = filter.getInput();
        RelMetadataQuery mq = call.getMetadataQuery();
        Boolean unique = mq.areColumnsUnique(input, newGroupSet);
        if (unique != null && unique.booleanValue()) {
            return;
        }
        boolean allColumnsInAggregate = aggregate.getGroupSet().contains(filterColumns);
        Aggregate newAggregate = aggregate.copy(aggregate.getTraitSet(), input, newGroupSet, null, aggregate.getAggCallList());
        Mappings.TargetMapping mapping = Mappings.target(newGroupSet::indexOf, input.getRowType().getFieldCount(), newGroupSet.cardinality());
        RexNode newCondition = RexUtil.apply(mapping, filter.getCondition());
        Filter newFilter = filter.copy(filter.getTraitSet(), newAggregate, newCondition);
        if (allColumnsInAggregate && aggregate.getGroupType() == Aggregate.Group.SIMPLE) {
            assert (newGroupSet.equals(aggregate.getGroupSet()));
            call.transformTo(newFilter);
        } else {
            ImmutableBitSet.Builder topGroupSet = ImmutableBitSet.builder();
            for (int c : aggregate.getGroupSet()) {
                topGroupSet.set(newGroupSet.indexOf(c));
            }
            ImmutableCollection newGroupingSets = null;
            if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
                ImmutableList.Builder newGroupingSetsBuilder = ImmutableList.builder();
                for (ImmutableBitSet immutableBitSet : aggregate.getGroupSets()) {
                    ImmutableBitSet.Builder newGroupingSet = ImmutableBitSet.builder();
                    for (int c : immutableBitSet) {
                        newGroupingSet.set(newGroupSet.indexOf(c));
                    }
                    newGroupingSetsBuilder.add(newGroupingSet.build());
                }
                newGroupingSets = newGroupingSetsBuilder.build();
            }
            ArrayList<AggregateCall> topAggCallList = new ArrayList<AggregateCall>();
            int i = newGroupSet.cardinality();
            for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
                SqlAggFunction rollup = aggregateCall.getAggregation().getRollup();
                if (rollup == null) {
                    return;
                }
                if (aggregateCall.isDistinct()) {
                    return;
                }
                topAggCallList.add(AggregateCall.create(rollup, aggregateCall.isDistinct(), aggregateCall.isApproximate(), aggregateCall.ignoreNulls(), aggregateCall.rexList, ImmutableList.of(Integer.valueOf(i++)), -1, aggregateCall.distinctKeys, aggregateCall.collation, aggregateCall.type, aggregateCall.name));
            }
            Aggregate aggregate2 = aggregate.copy(aggregate.getTraitSet(), newFilter, topGroupSet.build(), (List<ImmutableBitSet>)((Object)newGroupingSets), topAggCallList);
            call.transformTo(aggregate2);
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableAggregateFilterTransposeRule.Config.of().withOperandFor(Aggregate.class, Filter.class);

        @Override
        default public AggregateFilterTransposeRule toRule() {
            return new AggregateFilterTransposeRule(this);
        }

        default public Config withOperandFor(Class<? extends Aggregate> aggregateClass, Class<? extends Filter> filterClass) {
            return this.withOperandSupplier(b0 -> b0.operand(aggregateClass).oneInput(b1 -> b1.operand(filterClass).anyInputs())).as(Config.class);
        }

        default public Config withOperandFor(Class<? extends Aggregate> aggregateClass, Class<? extends Filter> filterClass, Class<? extends RelNode> relClass) {
            return this.withOperandSupplier(b0 -> b0.operand(aggregateClass).oneInput(b1 -> b1.operand(filterClass).oneInput(b2 -> b2.operand(relClass).anyInputs()))).as(Config.class);
        }
    }
}

