/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.metadata;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.com.google.common.collect.LinkedListMultimap;
import com.hazelcast.shaded.com.google.common.collect.Ordering;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableCorrelate;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableHashJoin;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableMergeJoin;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableMergeUnion;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableNestedLoopJoin;
import com.hazelcast.shaded.org.apache.calcite.adapter.jdbc.JdbcToEnumerableConverter;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Ord;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.hep.HepRelVertex;
import com.hazelcast.shaded.org.apache.calcite.plan.volcano.RelSubset;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollations;
import com.hazelcast.shaded.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Calc;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Filter;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Match;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Project;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Sort;
import com.hazelcast.shaded.org.apache.calcite.rel.core.SortExchange;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Values;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Window;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.BuiltInMetadata;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.MetadataDef;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.MetadataHandler;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import com.hazelcast.shaded.org.apache.calcite.rex.RexCallBinding;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexProgram;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableIntList;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class RelMdCollation
implements MetadataHandler<BuiltInMetadata.Collation> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(new RelMdCollation(), BuiltInMetadata.Collation.Handler.class);

    private RelMdCollation() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.Collation> getDef() {
        return BuiltInMetadata.Collation.DEF;
    }

    public @Nullable ImmutableList<RelCollation> collations(RelNode rel, RelMetadataQuery mq) {
        return null;
    }

    private static <E> @Nullable ImmutableList<E> copyOf(@Nullable Collection<? extends E> values) {
        return values == null ? null : ImmutableList.copyOf(values);
    }

    public @Nullable ImmutableList<RelCollation> collations(Window rel, RelMetadataQuery mq) {
        return RelMdCollation.copyOf(RelMdCollation.window(mq, rel.getInput(), rel.groups));
    }

    public @Nullable ImmutableList<RelCollation> collations(Match rel, RelMetadataQuery mq) {
        return RelMdCollation.copyOf(RelMdCollation.match(mq, rel.getInput(), rel.getRowType(), rel.getPattern(), rel.isStrictStart(), rel.isStrictEnd(), rel.getPatternDefinitions(), rel.getMeasures(), rel.getAfter(), rel.getSubsets(), rel.isAllRows(), rel.getPartitionKeys(), rel.getOrderKeys(), rel.getInterval()));
    }

    public @Nullable ImmutableList<RelCollation> collations(Filter rel, RelMetadataQuery mq) {
        return mq.collations(rel.getInput());
    }

    public @Nullable ImmutableList<RelCollation> collations(TableModify rel, RelMetadataQuery mq) {
        return mq.collations(rel.getInput());
    }

    public @Nullable ImmutableList<RelCollation> collations(TableScan scan, RelMetadataQuery mq) {
        BuiltInMetadata.Collation.Handler handler = scan.getTable().unwrap(BuiltInMetadata.Collation.Handler.class);
        if (handler != null) {
            return handler.collations(scan, mq);
        }
        return RelMdCollation.copyOf(RelMdCollation.table(scan.getTable()));
    }

    public @Nullable ImmutableList<RelCollation> collations(EnumerableMergeJoin join, RelMetadataQuery mq) {
        return RelMdCollation.copyOf(RelMdCollation.mergeJoin(mq, join.getLeft(), join.getRight(), join.analyzeCondition().leftKeys, join.analyzeCondition().rightKeys, join.getJoinType()));
    }

    public @Nullable ImmutableList<RelCollation> collations(EnumerableHashJoin join, RelMetadataQuery mq) {
        return RelMdCollation.copyOf(RelMdCollation.enumerableHashJoin(mq, join.getLeft(), join.getRight(), join.getJoinType()));
    }

    public @Nullable ImmutableList<RelCollation> collations(EnumerableNestedLoopJoin join, RelMetadataQuery mq) {
        return RelMdCollation.copyOf(RelMdCollation.enumerableNestedLoopJoin(mq, join.getLeft(), join.getRight(), join.getJoinType()));
    }

    public @Nullable ImmutableList<RelCollation> collations(EnumerableMergeUnion mergeUnion, RelMetadataQuery mq) {
        Object collation = mergeUnion.getTraitSet().getCollation();
        if (collation == null) {
            return null;
        }
        return RelMdCollation.copyOf(RelMdCollation.sort(collation));
    }

    public @Nullable ImmutableList<RelCollation> collations(EnumerableCorrelate join, RelMetadataQuery mq) {
        return RelMdCollation.copyOf(RelMdCollation.enumerableCorrelate(mq, join.getLeft(), join.getRight(), join.getJoinType()));
    }

    public @Nullable ImmutableList<RelCollation> collations(Sort sort, RelMetadataQuery mq) {
        return RelMdCollation.copyOf(RelMdCollation.sort(sort.getCollation()));
    }

    public @Nullable ImmutableList<RelCollation> collations(SortExchange sort, RelMetadataQuery mq) {
        return RelMdCollation.copyOf(RelMdCollation.sort(sort.getCollation()));
    }

    public @Nullable ImmutableList<RelCollation> collations(Project project, RelMetadataQuery mq) {
        return RelMdCollation.copyOf(RelMdCollation.project(mq, project.getInput(), project.getProjects()));
    }

    public @Nullable ImmutableList<RelCollation> collations(Calc calc, RelMetadataQuery mq) {
        return RelMdCollation.copyOf(RelMdCollation.calc(mq, calc.getInput(), calc.getProgram()));
    }

    public @Nullable ImmutableList<RelCollation> collations(Values values, RelMetadataQuery mq) {
        return RelMdCollation.copyOf(RelMdCollation.values(mq, values.getRowType(), values.getTuples()));
    }

    public @Nullable ImmutableList<RelCollation> collations(JdbcToEnumerableConverter rel, RelMetadataQuery mq) {
        return mq.collations(rel.getInput());
    }

    public @Nullable ImmutableList<RelCollation> collations(HepRelVertex rel, RelMetadataQuery mq) {
        return mq.collations(rel.stripped());
    }

    public @Nullable ImmutableList<RelCollation> collations(RelSubset rel, RelMetadataQuery mq) {
        return RelMdCollation.copyOf((Collection)Objects.requireNonNull(rel.getTraitSet().getTraits(RelCollationTraitDef.INSTANCE)));
    }

    public static @Nullable List<RelCollation> table(RelOptTable table) {
        return table.getCollationList();
    }

    public static @Nullable List<RelCollation> snapshot(RelMetadataQuery mq, RelNode input) {
        return mq.collations(input);
    }

    public static List<RelCollation> sort(RelCollation collation) {
        return ImmutableList.of(collation);
    }

    public static @Nullable List<RelCollation> filter(RelMetadataQuery mq, RelNode input) {
        return mq.collations(input);
    }

    public static @Nullable List<RelCollation> limit(RelMetadataQuery mq, RelNode input) {
        return mq.collations(input);
    }

    public static @Nullable List<RelCollation> calc(RelMetadataQuery mq, RelNode input, RexProgram program) {
        List projects = program.getProjectList().stream().map(program::expandLocalRef).collect(Collectors.toList());
        return RelMdCollation.project(mq, input, projects);
    }

    public static @Nullable List<RelCollation> project(RelMetadataQuery mq, RelNode input, List<? extends RexNode> projects) {
        TreeSet<RelCollation> collations = new TreeSet<RelCollation>();
        ImmutableList<RelCollation> inputCollations = mq.collations(input);
        if (inputCollations == null || inputCollations.isEmpty()) {
            return ImmutableList.of();
        }
        LinkedListMultimap<Integer, Integer> targets = LinkedListMultimap.create();
        HashMap<Integer, SqlMonotonicity> targetsWithMonotonicity = new HashMap<Integer, SqlMonotonicity>();
        for (Ord<? extends RexNode> ord : Ord.zip(projects)) {
            if (ord.e instanceof RexInputRef) {
                targets.put(((RexInputRef)ord.e).getIndex(), ord.i);
                continue;
            }
            if (!(ord.e instanceof RexCall)) continue;
            RexCall call = (RexCall)ord.e;
            RexCallBinding binding = RexCallBinding.create(input.getCluster().getTypeFactory(), call, inputCollations);
            targetsWithMonotonicity.put(ord.i, call.getOperator().getMonotonicity(binding));
        }
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        block4: for (RelCollation ic : inputCollations) {
            if (ic.getFieldCollations().isEmpty()) continue;
            fieldCollations.clear();
            for (RelFieldCollation ifc : ic.getFieldCollations()) {
                Collection integers = targets.get(ifc.getFieldIndex());
                if (integers.isEmpty()) continue block4;
                fieldCollations.add(ifc.withFieldIndex((Integer)integers.iterator().next()));
            }
            assert (!fieldCollations.isEmpty());
            collations.add(RelCollations.of(fieldCollations));
        }
        ArrayList<RelFieldCollation> arrayList = new ArrayList<RelFieldCollation>();
        block6: for (Map.Entry entry : targetsWithMonotonicity.entrySet()) {
            SqlMonotonicity value = (SqlMonotonicity)((Object)entry.getValue());
            switch (value) {
                case NOT_MONOTONIC: 
                case CONSTANT: {
                    continue block6;
                }
            }
            arrayList.add(new RelFieldCollation((Integer)entry.getKey(), RelFieldCollation.Direction.of(value)));
        }
        if (!arrayList.isEmpty()) {
            collations.add(RelCollations.of(arrayList));
        }
        return RelMdCollation.copyOf(collations);
    }

    public static @Nullable List<RelCollation> window(RelMetadataQuery mq, RelNode input, ImmutableList<Window.Group> groups) {
        return mq.collations(input);
    }

    public static @Nullable List<RelCollation> match(RelMetadataQuery mq, RelNode input, RelDataType rowType, RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Map<String, RexNode> measures, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, ImmutableBitSet partitionKeys, RelCollation orderKeys, @Nullable RexNode interval) {
        return mq.collations(input);
    }

    public static List<RelCollation> values(RelMetadataQuery mq, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        Util.discard(mq);
        ArrayList<RelCollation> list = new ArrayList<RelCollation>();
        int n = rowType.getFieldCount();
        ArrayList<Pair<RelFieldCollation, Ordering<List<RexLiteral>>>> pairs = new ArrayList<Pair<RelFieldCollation, Ordering<List<RexLiteral>>>>();
        block0: for (int i = 0; i < n; ++i) {
            pairs.clear();
            for (int j = i; j < n; ++j) {
                RelFieldCollation fieldCollation = new RelFieldCollation(j);
                Ordering<List<RexLiteral>> comparator = RelMdCollation.comparator(fieldCollation);
                Ordering<List<RexLiteral>> ordering = pairs.isEmpty() ? comparator : ((Ordering)((Pair)Util.last(pairs)).right).compound(comparator);
                pairs.add(Pair.of(fieldCollation, ordering));
                if (ordering.isOrdered(tuples)) continue;
                if (j == i) continue block0;
                pairs.remove(pairs.size() - 1);
            }
            if (pairs.isEmpty()) continue;
            list.add(RelCollations.of(Pair.left(pairs)));
        }
        return list;
    }

    public static Ordering<List<RexLiteral>> comparator(RelFieldCollation fieldCollation) {
        final int nullComparison = fieldCollation.nullDirection.nullComparison;
        final int x = fieldCollation.getFieldIndex();
        switch (fieldCollation.direction) {
            case ASCENDING: {
                return new Ordering<List<RexLiteral>>(){

                    @Override
                    public int compare(List<RexLiteral> o1, List<RexLiteral> o2) {
                        Comparable c1 = o1.get(x).getValueAs(Comparable.class);
                        Comparable c2 = o2.get(x).getValueAs(Comparable.class);
                        return RelFieldCollation.compare(c1, c2, nullComparison);
                    }
                };
            }
        }
        return new Ordering<List<RexLiteral>>(){

            @Override
            public int compare(List<RexLiteral> o1, List<RexLiteral> o2) {
                Comparable c1 = o1.get(x).getValueAs(Comparable.class);
                Comparable c2 = o2.get(x).getValueAs(Comparable.class);
                return RelFieldCollation.compare(c2, c1, -nullComparison);
            }
        };
    }

    @Deprecated
    public static @Nullable List<RelCollation> mergeJoin(RelMetadataQuery mq, RelNode left, RelNode right, ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        return RelMdCollation.mergeJoin(mq, left, right, leftKeys, rightKeys, JoinRelType.INNER);
    }

    public static @Nullable List<RelCollation> mergeJoin(RelMetadataQuery mq, RelNode left, RelNode right, ImmutableIntList leftKeys, ImmutableIntList rightKeys, JoinRelType joinType) {
        assert (EnumerableMergeJoin.isMergeJoinSupported(joinType)) : "EnumerableMergeJoin unsupported for join type " + (Object)((Object)joinType);
        ImmutableList<RelCollation> leftCollations = mq.collations(left);
        if (!joinType.projectsRight()) {
            return leftCollations;
        }
        if (leftCollations == null) {
            return null;
        }
        ImmutableList<RelCollation> rightCollations = mq.collations(right);
        if (rightCollations == null) {
            return leftCollations;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(leftCollations);
        int leftFieldCount = left.getRowType().getFieldCount();
        for (RelCollation collation : rightCollations) {
            builder.add(RelCollations.shift(collation, leftFieldCount));
        }
        return builder.build();
    }

    public static @Nullable List<RelCollation> enumerableHashJoin(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType) {
        if (joinType == JoinRelType.SEMI) {
            return RelMdCollation.enumerableSemiJoin(mq, left, right);
        }
        return RelMdCollation.enumerableJoin0(mq, left, right, joinType);
    }

    public static @Nullable List<RelCollation> enumerableNestedLoopJoin(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType) {
        return RelMdCollation.enumerableJoin0(mq, left, right, joinType);
    }

    public static @Nullable List<RelCollation> enumerableCorrelate(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType) {
        return mq.collations(left);
    }

    public static @Nullable List<RelCollation> enumerableSemiJoin(RelMetadataQuery mq, RelNode left, RelNode right) {
        return mq.collations(left);
    }

    public static @Nullable List<RelCollation> enumerableBatchNestedLoopJoin(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType) {
        return mq.collations(left);
    }

    private static @Nullable List<RelCollation> enumerableJoin0(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType) {
        ImmutableList<RelCollation> leftCollations = mq.collations(left);
        if (leftCollations == null) {
            return null;
        }
        switch (joinType) {
            case SEMI: 
            case ANTI: 
            case INNER: 
            case LEFT: {
                return leftCollations;
            }
            case RIGHT: 
            case FULL: {
                for (RelCollation collation : leftCollations) {
                    for (RelFieldCollation field : collation.getFieldCollations()) {
                        if (RelFieldCollation.NullDirection.LAST == field.nullDirection) continue;
                        return null;
                    }
                }
                return leftCollations;
            }
        }
        return null;
    }
}

