/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.plan.hep;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.hep.HepMatchOrder;
import com.hazelcast.shaded.org.apache.calcite.plan.hep.HepPlanner;
import com.hazelcast.shaded.org.apache.calcite.plan.hep.HepProgram;
import com.hazelcast.shaded.org.apache.calcite.plan.hep.HepState;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

abstract class HepInstruction {
    HepInstruction() {
    }

    abstract HepState prepare(PrepareContext var1);

    static class PrepareContext {
        final HepPlanner planner;
        final HepProgram.State programState;
        final EndGroup.State endGroupState;

        private PrepareContext(HepPlanner planner, HepProgram.State programState, EndGroup.State endGroupState) {
            this.planner = planner;
            this.programState = programState;
            this.endGroupState = endGroupState;
        }

        static PrepareContext create(HepPlanner planner) {
            return new PrepareContext(planner, Nullness.castNonNull(null), Nullness.castNonNull(null));
        }

        PrepareContext withProgramState(HepProgram.State programState) {
            return new PrepareContext(this.planner, programState, this.endGroupState);
        }

        PrepareContext withEndGroupState(EndGroup.State endGroupState) {
            return new PrepareContext(this.planner, this.programState, endGroupState);
        }
    }

    static class EndGroup
    extends HepInstruction {
        EndGroup() {
        }

        @Override
        State prepare(PrepareContext px) {
            return new State(px);
        }

        class State
        extends HepState {
            final Set<RelOptRule> ruleSet;
            boolean collecting;

            State(PrepareContext px) {
                super(px);
                this.ruleSet = new HashSet<RelOptRule>();
                this.collecting = true;
            }

            @Override
            void execute() {
                this.planner.executeEndGroup(EndGroup.this, this);
            }

            @Override
            void init() {
                this.collecting = true;
            }
        }
    }

    static class Placeholder
    extends HepInstruction {
        Placeholder() {
        }

        @Override
        HepState prepare(PrepareContext px) {
            throw new UnsupportedOperationException();
        }
    }

    static class BeginGroup
    extends HepInstruction {
        final EndGroup endGroup;

        BeginGroup(EndGroup endGroup) {
            this.endGroup = Objects.requireNonNull(endGroup, "endGroup");
        }

        @Override
        State prepare(PrepareContext px) {
            return new State(px);
        }

        class State
        extends HepState {
            final EndGroup.State endGroup;

            State(PrepareContext px) {
                super(px);
                this.endGroup = Objects.requireNonNull(px.endGroupState, "endGroupState");
            }

            @Override
            void execute() {
                this.planner.executeBeginGroup(BeginGroup.this, this);
            }
        }
    }

    static class SubProgram
    extends HepInstruction {
        final HepProgram subProgram;

        SubProgram(HepProgram subProgram) {
            this.subProgram = Objects.requireNonNull(subProgram, "subProgram");
        }

        @Override
        HepProgram.State prepare(PrepareContext px) {
            return this.subProgram.prepare(px);
        }

        class State
        extends HepState {
            final HepProgram.State subProgramState;

            State(PrepareContext px) {
                super(px);
                this.subProgramState = SubProgram.this.subProgram.prepare(px);
            }

            @Override
            void init() {
                this.subProgramState.init();
            }

            @Override
            void execute() {
                this.planner.executeSubProgram(SubProgram.this, this);
            }
        }
    }

    static class MatchLimit
    extends HepInstruction {
        final int limit;

        MatchLimit(int limit) {
            this.limit = limit;
        }

        @Override
        State prepare(PrepareContext px) {
            return new State(px);
        }

        class State
        extends HepState {
            State(PrepareContext px) {
                super(px);
            }

            @Override
            void execute() {
                this.planner.executeMatchLimit(MatchLimit.this, this);
            }
        }
    }

    static class MatchOrder
    extends HepInstruction {
        final HepMatchOrder order;

        MatchOrder(HepMatchOrder order) {
            this.order = Objects.requireNonNull(order, "order");
        }

        @Override
        State prepare(PrepareContext px) {
            return new State(px);
        }

        class State
        extends HepState {
            State(PrepareContext px) {
                super(px);
            }

            @Override
            void execute() {
                this.planner.executeMatchOrder(MatchOrder.this, this);
            }
        }
    }

    static class RuleLookup
    extends HepInstruction {
        final String ruleDescription;

        RuleLookup(String ruleDescription) {
            this.ruleDescription = Objects.requireNonNull(ruleDescription, "ruleDescription");
        }

        @Override
        State prepare(PrepareContext px) {
            return new State(px);
        }

        class State
        extends HepState {
            @Nullable RelOptRule rule;

            State(PrepareContext px) {
                super(px);
            }

            @Override
            void init() {
                this.rule = null;
            }

            @Override
            void execute() {
                this.planner.executeRuleLookup(RuleLookup.this, this);
            }
        }
    }

    static class RuleInstance
    extends HepInstruction {
        final RelOptRule rule;

        RuleInstance(RelOptRule rule) {
            this.rule = Objects.requireNonNull(rule, "rule");
        }

        @Override
        State prepare(PrepareContext px) {
            return new State(px);
        }

        class State
        extends HepState {
            State(PrepareContext px) {
                super(px);
            }

            @Override
            void execute() {
                this.planner.executeRuleInstance(RuleInstance.this, this);
            }
        }
    }

    static class CommonRelSubExprRules
    extends HepInstruction {
        CommonRelSubExprRules() {
        }

        @Override
        State prepare(PrepareContext px) {
            return new State(px);
        }

        class State
        extends HepState {
            @Nullable Set<RelOptRule> ruleSet;

            State(PrepareContext px) {
                super(px);
            }

            @Override
            void execute() {
                this.planner.executeCommonRelSubExprRules(CommonRelSubExprRules.this, this);
            }
        }
    }

    static class ConverterRules
    extends HepInstruction {
        final boolean guaranteed;

        ConverterRules(boolean guaranteed) {
            this.guaranteed = guaranteed;
        }

        @Override
        State prepare(PrepareContext px) {
            return new State(px);
        }

        class State
        extends HepState {
            @MonotonicNonNull Set<RelOptRule> ruleSet;

            State(PrepareContext px) {
                super(px);
            }

            @Override
            void execute() {
                this.planner.executeConverterRules(ConverterRules.this, this);
            }
        }
    }

    static class RuleCollection
    extends HepInstruction {
        final List<RelOptRule> rules;

        RuleCollection(Collection<RelOptRule> rules) {
            this.rules = ImmutableList.copyOf(rules);
        }

        @Override
        State prepare(PrepareContext px) {
            return new State(px);
        }

        class State
        extends HepState {
            State(PrepareContext px) {
                super(px);
            }

            @Override
            void execute() {
                this.planner.executeRuleCollection(RuleCollection.this, this);
            }
        }
    }

    static class RuleClass
    extends HepInstruction {
        final Class<? extends RelOptRule> ruleClass;

        <R extends RelOptRule> RuleClass(Class<R> ruleClass) {
            this.ruleClass = Objects.requireNonNull(ruleClass, "ruleClass");
        }

        @Override
        State prepare(PrepareContext px) {
            return new State(px);
        }

        class State
        extends HepState {
            @Nullable Set<RelOptRule> ruleSet;

            State(PrepareContext px) {
                super(px);
            }

            @Override
            void execute() {
                this.planner.executeRuleClass(RuleClass.this, this);
            }
        }
    }
}

