/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.adapter.enumerable;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableLimit;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableMergeUnion;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.ImmutableEnumerableMergeUnionRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.AbstractRelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Sort;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Union;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalSort;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalUnion;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableBitSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Value;

@Value.Enclosing
public class EnumerableMergeUnionRule
extends RelRule<Config> {
    public EnumerableMergeUnionRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        RelCollation collation = sort.getCollation();
        if (collation == null || collation.getFieldCollations().isEmpty()) {
            return false;
        }
        Union union = (Union)call.rel(1);
        return union.getInputs().size() >= 2;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        RelCollation collation = sort.getCollation();
        Union union = (Union)call.rel(1);
        int unionInputsSize = union.getInputs().size();
        RexNode inputFetch = null;
        if (sort.fetch != null) {
            if (sort.offset == null) {
                inputFetch = sort.fetch;
            } else if (sort.fetch instanceof RexLiteral && sort.offset instanceof RexLiteral) {
                inputFetch = call.builder().literal(RexLiteral.intValue(sort.fetch) + RexLiteral.intValue(sort.offset));
            }
        }
        RelBuilder builder = call.builder();
        List<RelDataTypeField> unionFieldList = union.getRowType().getFieldList();
        ArrayList<RelNode> inputs = new ArrayList<RelNode>(unionInputsSize);
        for (RelNode input : union.getInputs()) {
            RelNode unsortedInput;
            ImmutableBitSet.Builder fieldsRequiringCastBuilder = ImmutableBitSet.builder();
            for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
                int index = fieldCollation.getFieldIndex();
                RelDataType unionType = unionFieldList.get(index).getType();
                RelDataType inputType = input.getRowType().getFieldList().get(index).getType();
                if (Objects.equals(unionType.getCollation(), inputType.getCollation())) continue;
                fieldsRequiringCastBuilder.set(index);
            }
            ImmutableBitSet fieldsRequiringCast = fieldsRequiringCastBuilder.build();
            if (fieldsRequiringCast.isEmpty()) {
                unsortedInput = input;
            } else {
                builder.push(input);
                ImmutableList<RexNode> fields = builder.fields();
                ArrayList<RexNode> projFields = new ArrayList<RexNode>(fields.size());
                for (int i = 0; i < fields.size(); ++i) {
                    RexNode node = (RexNode)fields.get(i);
                    if (fieldsRequiringCast.get(i)) {
                        RelDataType targetType = unionFieldList.get(i).getType();
                        node = builder.getRexBuilder().makeCast(targetType, node);
                    }
                    projFields.add(node);
                }
                builder.project(projFields);
                unsortedInput = builder.build();
            }
            Sort newInput = sort.copy(sort.getTraitSet(), unsortedInput, collation, null, inputFetch);
            inputs.add(EnumerableMergeUnionRule.convert(call.getPlanner(), (RelNode)newInput, newInput.getTraitSet().replace(EnumerableConvention.INSTANCE)));
        }
        AbstractRelNode result = EnumerableMergeUnion.create(sort.getCollation(), inputs, union.all);
        if (sort.offset != null || sort.fetch != null) {
            result = EnumerableLimit.create(result, sort.offset, sort.fetch);
        }
        call.transformTo(result);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT_CONFIG = ImmutableEnumerableMergeUnionRule.Config.of().withDescription("EnumerableMergeUnionRule").withOperandSupplier(b0 -> b0.operand(LogicalSort.class).oneInput(b1 -> b1.operand(LogicalUnion.class).anyInputs()));

        @Override
        default public EnumerableMergeUnionRule toRule() {
            return new EnumerableMergeUnionRule(this);
        }
    }
}

