/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.math;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.operand.NumericOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operand.OperandCheckerProgram;
import com.hazelcast.jet.sql.impl.validate.operand.TypedOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastFunction;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.ReplaceUnknownOperandTypeInference;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.shaded.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastRoundTruncateFunction
extends HazelcastFunction {
    public static final HazelcastRoundTruncateFunction ROUND = new HazelcastRoundTruncateFunction("ROUND");
    public static final HazelcastRoundTruncateFunction TRUNCATE = new HazelcastRoundTruncateFunction("TRUNCATE");

    private HazelcastRoundTruncateFunction(String name) {
        super(name, SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE, new ReplaceUnknownOperandTypeInference(new SqlTypeName[]{SqlTypeName.DECIMAL, SqlTypeName.INTEGER}), SqlFunctionCategory.NUMERIC);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(1, 2);
    }

    @Override
    public boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        if (binding.getOperandCount() == 1) {
            return NumericOperandChecker.INSTANCE.check(binding, throwOnFailure, 0);
        }
        assert (binding.getOperandCount() == 2);
        return new OperandCheckerProgram(NumericOperandChecker.INSTANCE, TypedOperandChecker.INTEGER).check(binding, throwOnFailure);
    }
}

