/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.portable.PortableContext;
import com.hazelcast.jet.sql.impl.connector.file.AvroResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataAvroResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataJavaResolver;
import com.hazelcast.jet.sql.impl.connector.map.MetadataCompactResolver;
import com.hazelcast.jet.sql.impl.connector.map.MetadataPortableResolver;
import com.hazelcast.jet.sql.impl.schema.AbstractRelationsStorage;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.PortableId;
import com.hazelcast.sql.impl.FieldUtils;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.type.Type;
import com.hazelcast.sql.impl.schema.type.TypeKind;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.avro.Schema;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static FieldEnricher<?, ?> getFieldEnricher(String format, InternalSerializationService serializationService, AbstractRelationsStorage relationsStorage) {
        switch (format) {
            case "portable": {
                return new PortableEnricher(relationsStorage, serializationService);
            }
            case "compact": {
                return new CompactEnricher(relationsStorage);
            }
            case "java": {
                return new JavaEnricher(relationsStorage);
            }
            case "avro": {
                return new AvroEnricher(relationsStorage);
            }
        }
        throw QueryException.error((String)("Unsupported type format: " + format));
    }

    private static class PortableEnricher
    extends FieldEnricher<PortableId, ClassDefinition> {
        private final PortableContext context;

        PortableEnricher(AbstractRelationsStorage relationsStorage, InternalSerializationService serializationService) {
            super(TypeKind.PORTABLE, relationsStorage);
            this.context = serializationService.getPortableContext();
        }

        @Override
        protected String getTypeMetadata(PortableId portableId) {
            return portableId.toString();
        }

        @Override
        protected ClassDefinition getSchema(PortableId portableId) {
            return this.context.lookupClassDefinition(portableId);
        }

        @Override
        protected List<Type.TypeField> resolveFields(ClassDefinition classDef) {
            if (classDef == null) {
                throw QueryException.error((String)"Either a column list must be provided or the class definition must be registered to create Portable-based types");
            }
            return classDef.getFieldNames().stream().map(name -> {
                FieldDefinition field = classDef.getField(name);
                if (field.getType() == FieldType.PORTABLE) {
                    throw QueryException.error((String)"Column list is required to create nested fields");
                }
                return new Type.TypeField((String)name, (QueryDataType)MetadataPortableResolver.PORTABLE_TO_SQL.getOrDefault((Object)field.getType()));
            }).collect(Collectors.toList());
        }

        @Override
        protected PortableId getFieldSchemaId(ClassDefinition classDef, String fieldName, String fieldTypeName) {
            if (classDef == null) {
                throw QueryException.error((String)"Either a portable ID must be provided or the class definition must be registered to create nested fields");
            }
            return classDef.getField(fieldName).getPortableId();
        }

        @Override
        protected PortableId getSchemaId(Map<String, String> mappingOptions, boolean isKey) {
            return MetadataPortableResolver.portableId(mappingOptions, isKey);
        }

        @Override
        protected PortableId getSchemaId(Map<String, String> typeOptions) {
            return MetadataPortableResolver.portableId(typeOptions, "portableFactoryId", "portableClassId", "portableClassVersion");
        }
    }

    private static class CompactEnricher
    extends FieldEnricher<String, Void> {
        CompactEnricher(AbstractRelationsStorage relationsStorage) {
            super(TypeKind.COMPACT, relationsStorage);
        }

        @Override
        protected String getTypeMetadata(String compactTypeName) {
            return compactTypeName;
        }

        @Override
        protected Void getSchema(String schemaId) {
            return null;
        }

        @Override
        protected List<Type.TypeField> resolveFields(Void schema) {
            throw QueryException.error((String)"Column list is required to create Compact-based types");
        }

        @Override
        protected String getFieldSchemaId(Void schema, String fieldName, String fieldTypeName) {
            return fieldTypeName + "CompactType";
        }

        @Override
        protected String getSchemaId(Map<String, String> mappingOptions, boolean isKey) {
            return MetadataCompactResolver.compactTypeName(mappingOptions, isKey);
        }

        @Override
        protected String getSchemaId(Map<String, String> typeOptions) {
            return typeOptions.get("compactTypeName");
        }
    }

    private static class JavaEnricher
    extends FieldEnricher<Class<?>, SortedMap<String, Class<?>>> {
        JavaEnricher(AbstractRelationsStorage relationsStorage) {
            super(TypeKind.JAVA, relationsStorage);
        }

        @Override
        protected String getTypeMetadata(Class<?> typeClass) {
            return typeClass.getName();
        }

        @Override
        protected SortedMap<String, Class<?>> getSchema(Class<?> typeClass) {
            return FieldUtils.resolveClass(typeClass);
        }

        @Override
        protected List<Type.TypeField> resolveFields(SortedMap<String, Class<?>> classFields) {
            return classFields.entrySet().stream().map(e -> {
                if (JavaEnricher.isUserClass((Class)e.getValue())) {
                    throw QueryException.error((String)"Column list is required to create nested fields");
                }
                return new Type.TypeField((String)e.getKey(), QueryDataTypeUtils.resolveTypeForClass((Class)e.getValue()));
            }).collect(Collectors.toList());
        }

        @Override
        protected Class<?> getFieldSchemaId(SortedMap<String, Class<?>> classFields, String fieldName, String fieldTypeName) {
            return (Class)classFields.get(fieldName);
        }

        @Override
        protected Class<?> getSchemaId(Map<String, String> mappingOptions, boolean isKey) {
            return KvMetadataJavaResolver.loadClass(mappingOptions, isKey);
        }

        @Override
        protected Class<?> getSchemaId(Map<String, String> typeOptions) {
            String className = typeOptions.get("javaClass");
            return className != null ? KvMetadataJavaResolver.loadClass(className) : null;
        }

        private static boolean isUserClass(Class<?> clazz) {
            return !clazz.isPrimitive() && !clazz.getPackage().getName().startsWith("java.");
        }
    }

    private static class AvroEnricher
    extends FieldEnricher<Schema, Schema> {
        AvroEnricher(AbstractRelationsStorage relationsStorage) {
            super(TypeKind.AVRO, relationsStorage);
        }

        @Override
        protected String getTypeMetadata(Schema schema) {
            return null;
        }

        @Override
        protected Schema getSchema(Schema schema) {
            return schema;
        }

        @Override
        protected List<Type.TypeField> resolveFields(Schema schema) {
            if (schema == null) {
                throw QueryException.error((String)"Either a column list or an inline schema is required to create Avro-based types");
            }
            return KvMetadataAvroResolver.resolveFields(schema, Type.TypeField::new).collect(Collectors.toList());
        }

        @Override
        protected Schema getFieldSchemaId(Schema schema, String fieldName, String fieldTypeName) {
            return schema != null ? AvroResolver.unwrapNullableType(schema.getField(fieldName).schema()) : null;
        }

        @Override
        protected Schema getSchemaId(Map<String, String> mappingOptions, boolean isKey) {
            return KvMetadataAvroResolver.inlineSchema(mappingOptions, isKey);
        }

        @Override
        protected Schema getSchemaId(Map<String, String> typeOptions) {
            String json = typeOptions.get("avroSchema");
            return json != null ? new Schema.Parser().parse(json) : null;
        }
    }

    public static abstract class FieldEnricher<ID, S> {
        private final TypeKind typeKind;
        private final AbstractRelationsStorage relationsStorage;

        FieldEnricher(TypeKind typeKind, AbstractRelationsStorage relationsStorage) {
            this.typeKind = typeKind;
            this.relationsStorage = relationsStorage;
        }

        public void enrich(MappingField field, Map<String, String> mappingOptions, boolean isKey) {
            String typeName = field.type().getObjectTypeName();
            HashMap<String, QueryDataType> typeMap = new HashMap<String, QueryDataType>();
            field.setType(this.createFieldType(field.name().equals(isKey ? QueryPath.KEY : QueryPath.VALUE) ? () -> this.getSchemaId(mappingOptions, isKey) : () -> this.getFieldSchemaId(this.getSchema(this.getSchemaId(mappingOptions, isKey)), FieldEnricher.plainExternalName(field), typeName), typeName, typeMap));
            typeMap.values().forEach(QueryDataType::finalizeFields);
        }

        protected QueryDataType createFieldType(Supplier<ID> schemaIdSupplier, String typeName, Map<String, QueryDataType> typeMap) {
            QueryDataType convertedType = typeMap.get(typeName);
            if (convertedType != null) {
                return convertedType;
            }
            Type type = this.relationsStorage.getType(typeName);
            if (type == null) {
                throw QueryException.error((String)("Encountered type '" + typeName + "', which doesn't exist"));
            }
            ID schemaId = this.getSchemaId(type.options());
            if (schemaId == null) {
                schemaId = schemaIdSupplier.get();
            }
            S schema = this.getSchema(schemaId);
            if (type.getFields().isEmpty()) {
                type.setFields(this.resolveFields(schema));
                this.relationsStorage.put(typeName, type);
            }
            convertedType = new QueryDataType(typeName, this.typeKind, this.getTypeMetadata(schemaId));
            typeMap.put(typeName, convertedType);
            for (Type.TypeField field : type.getFields()) {
                QueryDataType fieldType = field.getType();
                String fieldTypeName = fieldType.getObjectTypeName();
                if (fieldType.isCustomType()) {
                    fieldType = this.createFieldType(() -> this.getFieldSchemaId(schema, field.getName(), fieldTypeName), fieldTypeName, typeMap);
                }
                convertedType.addField(field.getName(), fieldType);
            }
            return convertedType;
        }

        protected abstract String getTypeMetadata(ID var1);

        protected abstract S getSchema(ID var1);

        protected abstract List<Type.TypeField> resolveFields(S var1);

        protected abstract ID getFieldSchemaId(S var1, String var2, String var3);

        protected abstract ID getSchemaId(Map<String, String> var1, boolean var2);

        protected abstract ID getSchemaId(Map<String, String> var1);

        public static String plainExternalName(MappingField field) {
            return QueryPath.create(field.externalName()).getPath();
        }
    }
}

