/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.jet.sql.impl.schema.AbstractSchemaStorage;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.schema.dataconnection.DataConnectionCatalogEntry;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DataConnectionStorage
extends AbstractSchemaStorage {
    public DataConnectionStorage(NodeEngine nodeEngine) {
        super(nodeEngine);
    }

    public DataConnectionCatalogEntry get(@Nonnull String name) {
        return (DataConnectionCatalogEntry)this.storage().get((Object)QueryUtils.wrapDataConnectionKey(name));
    }

    void put(@Nonnull String name, @Nonnull DataConnectionCatalogEntry dataConnectionCatalogEntry) {
        this.storage().put((Object)QueryUtils.wrapDataConnectionKey(name), (Object)dataConnectionCatalogEntry);
    }

    boolean putIfAbsent(@Nonnull String name, @Nonnull DataConnectionCatalogEntry dataConnectionCatalogEntry) {
        return this.storage().putIfAbsent((Object)QueryUtils.wrapDataConnectionKey(name), (Object)dataConnectionCatalogEntry) == null;
    }

    boolean removeDataConnection(@Nonnull String name) {
        return this.storage().remove((Object)QueryUtils.wrapDataConnectionKey(name)) != null;
    }

    @Nonnull
    Collection<String> dataConnectionNames() {
        return this.storage().values().stream().filter(m4 -> m4 instanceof DataConnectionCatalogEntry).map(m4 -> ((DataConnectionCatalogEntry)m4).name()).collect(Collectors.toList());
    }

    @Nonnull
    List<DataConnectionCatalogEntry> dataConnections() {
        return this.storage().values().stream().filter(obj -> obj instanceof DataConnectionCatalogEntry).map(obj -> (DataConnectionCatalogEntry)obj).collect(Collectors.toList());
    }
}

