/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical.visitor;

import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.sql.impl.expression.Sarg;
import com.hazelcast.jet.sql.impl.expression.UdtObjectToJsonFunction;
import com.hazelcast.jet.sql.impl.expression.json.JsonArrayFunction;
import com.hazelcast.jet.sql.impl.expression.json.JsonObjectFunction;
import com.hazelcast.jet.sql.impl.expression.json.JsonParseFunction;
import com.hazelcast.jet.sql.impl.expression.json.JsonQueryFunction;
import com.hazelcast.jet.sql.impl.expression.json.JsonValueFunction;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlOperatorTable;
import com.hazelcast.jet.sql.impl.validate.operators.json.HazelcastJsonParseFunction;
import com.hazelcast.jet.sql.impl.validate.operators.special.HazelcastUdtObjectToJsonFunction;
import com.hazelcast.jet.sql.impl.validate.operators.string.HazelcastLikeOperator;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.shaded.com.google.common.collect.RangeSet;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.TimeUnitRange;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.rex.RexUnknownAs;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonConstructorNullClause;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlTrimFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.util.DateString;
import com.hazelcast.shaded.org.apache.calcite.util.NlsString;
import com.hazelcast.shaded.org.apache.calcite.util.RangeSets;
import com.hazelcast.shaded.org.apache.calcite.util.TimeString;
import com.hazelcast.shaded.org.apache.calcite.util.TimestampString;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.CaseExpression;
import com.hazelcast.sql.impl.expression.CastExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.RowExpression;
import com.hazelcast.sql.impl.expression.SargExpression;
import com.hazelcast.sql.impl.expression.SymbolExpression;
import com.hazelcast.sql.impl.expression.datetime.ExtractField;
import com.hazelcast.sql.impl.expression.datetime.ExtractFunction;
import com.hazelcast.sql.impl.expression.datetime.ToCharFunction;
import com.hazelcast.sql.impl.expression.datetime.ToEpochMillisFunction;
import com.hazelcast.sql.impl.expression.datetime.ToTimestampTzFunction;
import com.hazelcast.sql.impl.expression.math.AbsFunction;
import com.hazelcast.sql.impl.expression.math.DivideFunction;
import com.hazelcast.sql.impl.expression.math.DoubleBiFunction;
import com.hazelcast.sql.impl.expression.math.DoubleFunction;
import com.hazelcast.sql.impl.expression.math.FloorCeilFunction;
import com.hazelcast.sql.impl.expression.math.MinusFunction;
import com.hazelcast.sql.impl.expression.math.MultiplyFunction;
import com.hazelcast.sql.impl.expression.math.PlusFunction;
import com.hazelcast.sql.impl.expression.math.RandFunction;
import com.hazelcast.sql.impl.expression.math.RemainderFunction;
import com.hazelcast.sql.impl.expression.math.RoundTruncateFunction;
import com.hazelcast.sql.impl.expression.math.SignFunction;
import com.hazelcast.sql.impl.expression.math.UnaryMinusFunction;
import com.hazelcast.sql.impl.expression.predicate.AndPredicate;
import com.hazelcast.sql.impl.expression.predicate.ComparisonMode;
import com.hazelcast.sql.impl.expression.predicate.ComparisonPredicate;
import com.hazelcast.sql.impl.expression.predicate.IsFalsePredicate;
import com.hazelcast.sql.impl.expression.predicate.IsNotFalsePredicate;
import com.hazelcast.sql.impl.expression.predicate.IsNotNullPredicate;
import com.hazelcast.sql.impl.expression.predicate.IsNotTruePredicate;
import com.hazelcast.sql.impl.expression.predicate.IsNullPredicate;
import com.hazelcast.sql.impl.expression.predicate.IsTruePredicate;
import com.hazelcast.sql.impl.expression.predicate.NotPredicate;
import com.hazelcast.sql.impl.expression.predicate.OrPredicate;
import com.hazelcast.sql.impl.expression.predicate.SearchPredicate;
import com.hazelcast.sql.impl.expression.service.GetDdlFunction;
import com.hazelcast.sql.impl.expression.string.AsciiFunction;
import com.hazelcast.sql.impl.expression.string.CharLengthFunction;
import com.hazelcast.sql.impl.expression.string.ConcatFunction;
import com.hazelcast.sql.impl.expression.string.ConcatWSFunction;
import com.hazelcast.sql.impl.expression.string.InitcapFunction;
import com.hazelcast.sql.impl.expression.string.LikeFunction;
import com.hazelcast.sql.impl.expression.string.LowerFunction;
import com.hazelcast.sql.impl.expression.string.PositionFunction;
import com.hazelcast.sql.impl.expression.string.ReplaceFunction;
import com.hazelcast.sql.impl.expression.string.SubstringFunction;
import com.hazelcast.sql.impl.expression.string.TrimFunction;
import com.hazelcast.sql.impl.expression.string.UpperFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.SqlDaySecondInterval;
import com.hazelcast.sql.impl.type.SqlYearMonthInterval;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;

public final class RexToExpression {
    private RexToExpression() {
    }

    public static Expression<?> convertLiteral(RexLiteral literal) {
        RelDataType type = literal.getType();
        SqlTypeName typeName = literal.getTypeName();
        if (literal.getValue() == null) {
            return ConstantExpression.create(null, HazelcastTypeUtils.toHazelcastType(type));
        }
        if (literal.getTypeName() == SqlTypeName.SARG) {
            return RexToExpression.convertSargLiteral(literal, type);
        }
        switch (typeName) {
            case BOOLEAN: {
                return RexToExpression.convertBooleanLiteral(literal, type);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: 
            case REAL: 
            case FLOAT: 
            case DOUBLE: {
                return RexToExpression.convertNumericLiteral(literal, type);
            }
            case CHAR: 
            case VARCHAR: {
                return RexToExpression.convertStringLiteral(literal, type);
            }
            case NULL: {
                return ConstantExpression.create(null, QueryDataType.NULL);
            }
            case SYMBOL: {
                return SymbolExpression.create(literal.getValue());
            }
            case DATE: {
                return RexToExpression.convertDateLiteral(literal);
            }
            case TIME: {
                return RexToExpression.convertTimeLiteral(literal);
            }
            case TIMESTAMP: {
                return RexToExpression.convertTimestamp(literal);
            }
            case INTERVAL_YEAR_MONTH: {
                return RexToExpression.convertIntervalYearMonth(literal);
            }
            case INTERVAL_DAY_SECOND: {
                return RexToExpression.convertIntervalDaySecond(literal);
            }
        }
        throw QueryException.error((String)("Unsupported literal: " + String.valueOf(literal)));
    }

    public static Expression<?> convertCall(RexCall call, Expression<?>[] operands) {
        SqlOperator operator = call.getOperator();
        QueryDataType resultType = HazelcastTypeUtils.toHazelcastType(call.getType());
        switch (operator.getKind()) {
            case DEFAULT: {
                return ConstantExpression.create(null, resultType);
            }
            case CAST: {
                if (operands[0].getType().equals(resultType)) {
                    return operands[0];
                }
                return CastExpression.create(operands[0], resultType);
            }
            case AND: {
                return AndPredicate.create(operands);
            }
            case OR: {
                return OrPredicate.create(operands);
            }
            case NOT: {
                return NotPredicate.create(operands[0]);
            }
            case PLUS: {
                return PlusFunction.create(operands[0], operands[1], resultType);
            }
            case MINUS: {
                return MinusFunction.create(operands[0], operands[1], resultType);
            }
            case TIMES: {
                return MultiplyFunction.create(operands[0], operands[1], resultType);
            }
            case DIVIDE: {
                return DivideFunction.create(operands[0], operands[1], resultType);
            }
            case MOD: {
                return RemainderFunction.create(operands[0], operands[1], resultType);
            }
            case MINUS_PREFIX: {
                return UnaryMinusFunction.create(operands[0], resultType);
            }
            case PLUS_PREFIX: {
                return operands[0];
            }
            case FLOOR: {
                return FloorCeilFunction.create(operands[0], resultType, false);
            }
            case CEIL: {
                return FloorCeilFunction.create(operands[0], resultType, true);
            }
            case EQUALS: {
                return ComparisonPredicate.create(operands[0], operands[1], ComparisonMode.EQUALS);
            }
            case NOT_EQUALS: {
                return ComparisonPredicate.create(operands[0], operands[1], ComparisonMode.NOT_EQUALS);
            }
            case GREATER_THAN: {
                return ComparisonPredicate.create(operands[0], operands[1], ComparisonMode.GREATER_THAN);
            }
            case GREATER_THAN_OR_EQUAL: {
                return ComparisonPredicate.create(operands[0], operands[1], ComparisonMode.GREATER_THAN_OR_EQUAL);
            }
            case LESS_THAN: {
                return ComparisonPredicate.create(operands[0], operands[1], ComparisonMode.LESS_THAN);
            }
            case LESS_THAN_OR_EQUAL: {
                return ComparisonPredicate.create(operands[0], operands[1], ComparisonMode.LESS_THAN_OR_EQUAL);
            }
            case SEARCH: {
                return SearchPredicate.create(operands[0], operands[1]);
            }
            case IS_TRUE: {
                return IsTruePredicate.create(operands[0]);
            }
            case IS_NOT_TRUE: {
                return IsNotTruePredicate.create(operands[0]);
            }
            case IS_FALSE: {
                return IsFalsePredicate.create(operands[0]);
            }
            case IS_NOT_FALSE: {
                return IsNotFalsePredicate.create(operands[0]);
            }
            case IS_NULL: {
                return IsNullPredicate.create(operands[0]);
            }
            case IS_NOT_NULL: {
                return IsNotNullPredicate.create(operands[0]);
            }
            case LIKE: {
                boolean negated = ((HazelcastLikeOperator)operator).isNegated();
                Expression<?> escape1 = operands.length == 2 ? null : operands[2];
                return LikeFunction.create(operands[0], operands[1], escape1, negated);
            }
            case TRIM: {
                assert (operands.length == 3);
                assert (operands[0] instanceof SymbolExpression);
                SqlTrimFunction.Flag trimFlag = (SqlTrimFunction.Flag)((SymbolExpression)operands[0]).getSymbol();
                return TrimFunction.create(operands[2], operands[1], trimFlag.getLeft() == 1, trimFlag.getRight() == 1);
            }
            case EXTRACT: {
                assert (operands.length == 2);
                assert (operands[0] instanceof SymbolExpression);
                TimeUnitRange field = (TimeUnitRange)((Object)((SymbolExpression)operands[0]).getSymbol());
                ExtractField extractField = RexToExpression.convertField(field);
                return ExtractFunction.create(operands[1], extractField);
            }
            case CASE: {
                return CaseExpression.create(operands);
            }
            case COALESCE: {
                return CaseExpression.coalesce(operands);
            }
            case NULLIF: {
                return CaseExpression.nullif(operands[0], operands[1]);
            }
            case OTHER: {
                if (operator == HazelcastSqlOperatorTable.CONCAT) {
                    assert (operands.length == 2);
                    return ConcatFunction.create(operands[0], operands[1]);
                }
                if (operator != HazelcastSqlOperatorTable.NOT_LIKE) break;
                assert (((HazelcastLikeOperator)operator).isNegated());
                Expression<?> escape2 = operands.length == 2 ? null : operands[2];
                return LikeFunction.create(operands[0], operands[1], escape2, true);
            }
            case POSITION: 
            case OTHER_FUNCTION: {
                SqlFunction function = (SqlFunction)operator;
                if (function == HazelcastSqlOperatorTable.POWER) {
                    assert (operands.length == 2);
                    return DoubleBiFunction.create(operands[0], operands[1], 0);
                }
                if (function == HazelcastSqlOperatorTable.SQUARE) {
                    return DoubleFunction.create(operands[0], 12);
                }
                if (function == HazelcastSqlOperatorTable.SQRT) {
                    return DoubleFunction.create(operands[0], 13);
                }
                if (function == HazelcastSqlOperatorTable.CBRT) {
                    return DoubleFunction.create(operands[0], 14);
                }
                if (function == HazelcastSqlOperatorTable.COS) {
                    return DoubleFunction.create(operands[0], 0);
                }
                if (function == HazelcastSqlOperatorTable.SIN) {
                    return DoubleFunction.create(operands[0], 1);
                }
                if (function == HazelcastSqlOperatorTable.TAN) {
                    return DoubleFunction.create(operands[0], 2);
                }
                if (function == HazelcastSqlOperatorTable.COT) {
                    return DoubleFunction.create(operands[0], 3);
                }
                if (function == HazelcastSqlOperatorTable.ACOS) {
                    return DoubleFunction.create(operands[0], 4);
                }
                if (function == HazelcastSqlOperatorTable.ASIN) {
                    return DoubleFunction.create(operands[0], 5);
                }
                if (function == HazelcastSqlOperatorTable.ATAN) {
                    return DoubleFunction.create(operands[0], 6);
                }
                if (function == HazelcastSqlOperatorTable.ATAN2) {
                    assert (operands.length == 2);
                    return DoubleBiFunction.create(operands[0], operands[1], 1);
                }
                if (function == HazelcastSqlOperatorTable.EXP) {
                    return DoubleFunction.create(operands[0], 7);
                }
                if (function == HazelcastSqlOperatorTable.LN) {
                    return DoubleFunction.create(operands[0], 8);
                }
                if (function == HazelcastSqlOperatorTable.LOG10) {
                    return DoubleFunction.create(operands[0], 9);
                }
                if (function == HazelcastSqlOperatorTable.RAND) {
                    return RandFunction.create(operands.length == 0 ? null : operands[0]);
                }
                if (function == HazelcastSqlOperatorTable.ABS) {
                    return AbsFunction.create(operands[0], resultType);
                }
                if (function == SqlStdOperatorTable.PI) {
                    return ConstantExpression.create(Math.PI, resultType);
                }
                if (function == HazelcastSqlOperatorTable.SIGN) {
                    return SignFunction.create(operands[0], resultType);
                }
                if (function == HazelcastSqlOperatorTable.DEGREES) {
                    return DoubleFunction.create(operands[0], 10);
                }
                if (function == HazelcastSqlOperatorTable.RADIANS) {
                    return DoubleFunction.create(operands[0], 11);
                }
                if (function == HazelcastSqlOperatorTable.ROUND) {
                    return RoundTruncateFunction.create(operands[0], operands.length == 1 ? null : operands[1], resultType, false);
                }
                if (function == HazelcastSqlOperatorTable.TRUNCATE) {
                    return RoundTruncateFunction.create(operands[0], operands.length == 1 ? null : operands[1], resultType, true);
                }
                if (function == HazelcastSqlOperatorTable.CHAR_LENGTH || function == HazelcastSqlOperatorTable.CHARACTER_LENGTH || function == HazelcastSqlOperatorTable.LENGTH) {
                    return CharLengthFunction.create(operands[0]);
                }
                if (function == HazelcastSqlOperatorTable.UPPER) {
                    return UpperFunction.create(operands[0]);
                }
                if (function == HazelcastSqlOperatorTable.LOWER) {
                    return LowerFunction.create(operands[0]);
                }
                if (function == HazelcastSqlOperatorTable.INITCAP) {
                    return InitcapFunction.create(operands[0]);
                }
                if (function == HazelcastSqlOperatorTable.ASCII) {
                    return AsciiFunction.create(operands[0]);
                }
                if (function == HazelcastSqlOperatorTable.SUBSTRING) {
                    Expression<?> input = operands[0];
                    Expression<?> start = operands[1];
                    Expression<?> length = operands.length > 2 ? operands[2] : null;
                    return SubstringFunction.create(input, start, length);
                }
                if (function == HazelcastSqlOperatorTable.LTRIM) {
                    return TrimFunction.create(operands[0], null, true, false);
                }
                if (function == HazelcastSqlOperatorTable.RTRIM) {
                    return TrimFunction.create(operands[0], null, false, true);
                }
                if (function == HazelcastSqlOperatorTable.BTRIM) {
                    return TrimFunction.create(operands[0], null, true, true);
                }
                if (function == HazelcastSqlOperatorTable.REPLACE) {
                    return ReplaceFunction.create(operands[0], operands[1], operands[2]);
                }
                if (function == HazelcastSqlOperatorTable.POSITION) {
                    Expression<?> start = operands.length > 2 ? operands[2] : null;
                    return PositionFunction.create(operands[0], operands[1], start);
                }
                if (function == HazelcastSqlOperatorTable.TO_TIMESTAMP_TZ) {
                    return ToTimestampTzFunction.create(operands[0]);
                }
                if (function == HazelcastSqlOperatorTable.TO_EPOCH_MILLIS) {
                    return ToEpochMillisFunction.create(operands[0]);
                }
                if (function == HazelcastSqlOperatorTable.TO_CHAR) {
                    Expression<?> input = operands[0];
                    Expression<?> format = operands[1];
                    Expression<?> locale = operands.length > 2 ? operands[2] : null;
                    return ToCharFunction.create(input, format, locale);
                }
                if (function == HazelcastSqlOperatorTable.GET_DDL) {
                    Expression<?> namespace = operands[0];
                    Expression<?> objectName = operands[1];
                    Expression<?> schema = operands.length > 2 ? operands[2] : null;
                    return GetDdlFunction.create(namespace, objectName, schema);
                }
                if (function == HazelcastSqlOperatorTable.CONCAT_WS) {
                    return ConcatWSFunction.create(operands);
                }
                if (function == HazelcastSqlOperatorTable.JSON_QUERY) {
                    SqlJsonQueryWrapperBehavior wrapperBehavior = (SqlJsonQueryWrapperBehavior)((Object)((SymbolExpression)operands[2]).getSymbol());
                    SqlJsonQueryEmptyOrErrorBehavior onEmpty = (SqlJsonQueryEmptyOrErrorBehavior)((Object)((SymbolExpression)operands[3]).getSymbol());
                    SqlJsonQueryEmptyOrErrorBehavior onError = (SqlJsonQueryEmptyOrErrorBehavior)((Object)((SymbolExpression)operands[4]).getSymbol());
                    return JsonQueryFunction.create(operands[0], operands[1], wrapperBehavior, onEmpty, onError);
                }
                if (function == HazelcastJsonParseFunction.INSTANCE) {
                    return JsonParseFunction.create(operands[0]);
                }
                if (function == HazelcastSqlOperatorTable.JSON_VALUE) {
                    SqlJsonValueEmptyOrErrorBehavior onEmpty = (SqlJsonValueEmptyOrErrorBehavior)((SymbolExpression)operands[4]).getSymbol();
                    SqlJsonValueEmptyOrErrorBehavior onError = (SqlJsonValueEmptyOrErrorBehavior)((SymbolExpression)operands[5]).getSymbol();
                    return JsonValueFunction.create(operands[0], operands[1], operands[2], operands[3], resultType, onEmpty, onError);
                }
                if (function == HazelcastSqlOperatorTable.JSON_OBJECT) {
                    SqlJsonConstructorNullClause nullClause = (SqlJsonConstructorNullClause)((Object)((SymbolExpression)operands[0]).getSymbol());
                    Expression<?>[] fields = Arrays.copyOfRange(operands, 1, operands.length);
                    return JsonObjectFunction.create(fields, nullClause);
                }
                if (function == HazelcastSqlOperatorTable.JSON_ARRAY) {
                    SqlJsonConstructorNullClause nullClause = (SqlJsonConstructorNullClause)((Object)((SymbolExpression)operands[0]).getSymbol());
                    Expression<?>[] fields = Arrays.copyOfRange(operands, 1, operands.length);
                    return JsonArrayFunction.create(fields, nullClause);
                }
                if (function != HazelcastUdtObjectToJsonFunction.INSTANCE) break;
                return UdtObjectToJsonFunction.create(operands[0]);
            }
            case ROW: {
                return RowExpression.create(operands);
            }
        }
        throw QueryException.error((String)("Unsupported operator: " + String.valueOf(operator)));
    }

    public static Tuple2<RangeSet<?>, Boolean> extractRangeSetAndNullAsFromSearch(RexLiteral literal) {
        com.hazelcast.shaded.org.apache.calcite.util.Sarg sarg = literal.getValueAs(com.hazelcast.shaded.org.apache.calcite.util.Sarg.class);
        if (sarg == null) {
            return null;
        }
        RelDataType literalType = literal.getType();
        SqlTypeName sqlType = literalType.getSqlTypeName();
        return Tuple2.tuple2(RangeSets.copy(sarg.rangeSet, value -> RexToExpression.convertSargValue(value, sqlType)), (Object)RexToExpression.convertNullAs(sarg));
    }

    private static <CI extends Comparable<CI>, CO extends Comparable<CO>> Expression<?> convertSargLiteral(RexLiteral literal, RelDataType type) {
        com.hazelcast.shaded.org.apache.calcite.util.Sarg sarg = literal.getValueAs(com.hazelcast.shaded.org.apache.calcite.util.Sarg.class);
        RangeSet<Comparable> mapped = RangeSets.copy(sarg.rangeSet, value -> RexToExpression.convertSargValue(value, type.getSqlTypeName()));
        return SargExpression.create(HazelcastTypeUtils.toHazelcastType(type), new Sarg<Comparable>(mapped, RexToExpression.convertNullAs(sarg)));
    }

    private static Boolean convertNullAs(com.hazelcast.shaded.org.apache.calcite.util.Sarg<?> sarg) {
        return sarg.nullAs == RexUnknownAs.UNKNOWN ? null : Boolean.valueOf(sarg.nullAs.toBoolean());
    }

    private static <CI extends Comparable<CI>> Comparable convertSargValue(Comparable<CI> value, SqlTypeName typeName) {
        switch (typeName) {
            case TINYINT: {
                return Byte.valueOf(((BigDecimal)value).byteValueExact());
            }
            case SMALLINT: {
                return Short.valueOf(((BigDecimal)value).shortValueExact());
            }
            case INTEGER: {
                return Integer.valueOf(((BigDecimal)value).intValueExact());
            }
            case BIGINT: {
                return Long.valueOf(((BigDecimal)value).longValueExact());
            }
            case REAL: 
            case FLOAT: {
                return Float.valueOf(((BigDecimal)value).floatValue());
            }
            case DOUBLE: {
                return Double.valueOf(((BigDecimal)value).doubleValue());
            }
            case CHAR: 
            case VARCHAR: {
                return ((NlsString)value).getValue();
            }
            case TIME: {
                return RexToExpression.toLocalTime((TimeString)value);
            }
            case DATE: {
                return RexToExpression.toLocalDate((DateString)value);
            }
            case TIMESTAMP: {
                return RexToExpression.toLocalDateTime((TimestampString)value);
            }
            case INTERVAL_YEAR_MONTH: {
                return new SqlYearMonthInterval(((BigDecimal)value).intValueExact());
            }
            case INTERVAL_DAY_SECOND: {
                return new SqlDaySecondInterval(((BigDecimal)value).longValueExact());
            }
        }
        return value;
    }

    private static Expression<?> convertBooleanLiteral(RexLiteral literal, RelDataType type) {
        assert (type.getSqlTypeName() == SqlTypeName.BOOLEAN);
        Boolean value = literal.getValueAs(Boolean.class);
        return ConstantExpression.create(value, HazelcastTypeUtils.toHazelcastType(type));
    }

    private static Expression<?> convertNumericLiteral(RexLiteral literal, RelDataType targetType) {
        return ConstantExpression.create(switch (targetType.getSqlTypeName()) {
            case SqlTypeName.TINYINT -> literal.getValueAs(Byte.class);
            case SqlTypeName.SMALLINT -> literal.getValueAs(Short.class);
            case SqlTypeName.INTEGER -> literal.getValueAs(Integer.class);
            case SqlTypeName.BIGINT -> {
                if (literal.getTypeName() == SqlTypeName.DECIMAL) {
                    yield literal.getValueAs(BigDecimal.class).longValue();
                }
                yield literal.getValueAs(Long.class);
            }
            case SqlTypeName.DECIMAL -> literal.getValueAs(BigDecimal.class);
            case SqlTypeName.REAL -> literal.getValueAs(Float.class);
            case SqlTypeName.DOUBLE -> literal.getValueAs(Double.class);
            default -> throw new IllegalArgumentException("Unsupported literal type: " + String.valueOf((Object)targetType.getSqlTypeName()));
        }, HazelcastTypeUtils.toHazelcastType(targetType));
    }

    private static Expression<?> convertStringLiteral(RexLiteral literal, RelDataType type) {
        return ConstantExpression.create(switch (type.getSqlTypeName()) {
            case SqlTypeName.CHAR, SqlTypeName.VARCHAR -> literal.getValueAs(String.class);
            default -> throw new IllegalArgumentException("Unsupported literal type: " + String.valueOf(type));
        }, HazelcastTypeUtils.toHazelcastType(type));
    }

    private static Expression<?> convertTimeLiteral(RexLiteral literal) {
        TimeString string = literal.getValueAs(TimeString.class);
        return ConstantExpression.create(RexToExpression.toLocalTime(string), QueryDataType.TIME);
    }

    private static LocalTime toLocalTime(TimeString string) {
        try {
            return LocalTime.parse(string.toString());
        }
        catch (Exception e) {
            throw QueryException.dataException((String)("Cannot convert literal to " + String.valueOf(SqlColumnType.TIME) + ": " + String.valueOf(string)));
        }
    }

    private static Expression<?> convertDateLiteral(RexLiteral literal) {
        DateString string = literal.getValueAs(DateString.class);
        return ConstantExpression.create(RexToExpression.toLocalDate(string), QueryDataType.DATE);
    }

    private static LocalDate toLocalDate(DateString string) {
        try {
            return LocalDate.parse(string.toString());
        }
        catch (Exception e) {
            throw QueryException.dataException((String)("Cannot convert literal to " + String.valueOf(SqlColumnType.DATE) + ": " + String.valueOf(string)));
        }
    }

    private static Expression<?> convertTimestamp(RexLiteral literal) {
        TimestampString string = literal.getValueAs(TimestampString.class);
        return ConstantExpression.create(RexToExpression.toLocalDateTime(string), QueryDataType.TIMESTAMP);
    }

    private static LocalDateTime toLocalDateTime(TimestampString string) {
        try {
            return LocalDateTime.parse(string.toString().replace(' ', 'T'));
        }
        catch (Exception e) {
            throw QueryException.dataException((String)("Cannot convert literal to " + String.valueOf(SqlColumnType.TIMESTAMP) + ": " + String.valueOf(string)));
        }
    }

    private static Expression<?> convertIntervalYearMonth(RexLiteral literal) {
        SqlYearMonthInterval value = new SqlYearMonthInterval(literal.getValueAs(Integer.class));
        return ConstantExpression.create(value, QueryDataType.INTERVAL_YEAR_MONTH);
    }

    private static Expression<?> convertIntervalDaySecond(RexLiteral literal) {
        SqlDaySecondInterval value = new SqlDaySecondInterval(literal.getValueAs(Long.class));
        return ConstantExpression.create(value, QueryDataType.INTERVAL_DAY_SECOND);
    }

    private static ExtractField convertField(TimeUnitRange field) {
        switch (field) {
            case CENTURY: {
                return ExtractField.CENTURY;
            }
            case DAY: {
                return ExtractField.DAY;
            }
            case DECADE: {
                return ExtractField.DECADE;
            }
            case DOW: {
                return ExtractField.DOW;
            }
            case DOY: {
                return ExtractField.DOY;
            }
            case EPOCH: {
                return ExtractField.EPOCH;
            }
            case HOUR: {
                return ExtractField.HOUR;
            }
            case ISODOW: {
                return ExtractField.ISODOW;
            }
            case ISOYEAR: {
                return ExtractField.ISOYEAR;
            }
            case MICROSECOND: {
                return ExtractField.MICROSECOND;
            }
            case MILLENNIUM: {
                return ExtractField.MILLENNIUM;
            }
            case MILLISECOND: {
                return ExtractField.MILLISECOND;
            }
            case MINUTE: {
                return ExtractField.MINUTE;
            }
            case MONTH: {
                return ExtractField.MONTH;
            }
            case QUARTER: {
                return ExtractField.QUARTER;
            }
            case SECOND: {
                return ExtractField.SECOND;
            }
            case WEEK: {
                return ExtractField.WEEK;
            }
            case YEAR: {
                return ExtractField.YEAR;
            }
        }
        throw new UnsupportedOperationException("Unsupported field " + String.valueOf((Object)field) + " for EXTRACT");
    }
}

