/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.ImmutableIndexScanMapPhysicalRule;
import com.hazelcast.jet.sql.impl.opt.physical.index.IndexResolver;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import org.immutables.value.Value;

@Value.Enclosing
final class IndexScanMapPhysicalRule
extends RelRule<RelRule.Config> {
    static final RelOptRule INSTANCE = new IndexScanMapPhysicalRule(Config.DEFAULT);

    private IndexScanMapPhysicalRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FullScanLogicalRel logicalScan = (FullScanLogicalRel)call.rel(0);
        PartitionedMapTable table = (PartitionedMapTable)IndexScanMapPhysicalRule.table(logicalScan);
        for (RelNode indexScan : IndexResolver.createIndexScans(logicalScan, table.getIndexes())) {
            call.transformTo(indexScan);
        }
    }

    private static <T extends Table> T table(FullScanLogicalRel scan) {
        return OptUtils.extractHazelcastTable(scan).getTarget();
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableIndexScanMapPhysicalRule.Config.builder().description(IndexScanMapPhysicalRule.class.getSimpleName()).operandSupplier(b -> b.operand(FullScanLogicalRel.class).trait(Conventions.LOGICAL).predicate(scan -> OptUtils.hasTableType(scan, PartitionedMapTable.class)).noInputs()).build();

        @Override
        default public RelOptRule toRule() {
            return new IndexScanMapPhysicalRule(this);
        }
    }
}

