/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorUtil;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.ImmutableUpdateWithScanLogicalRule;
import com.hazelcast.jet.sql.impl.opt.logical.TableModifyLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.UpdateByKeyMapLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.UpdateLogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastRelOptTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Value;

@Value.Enclosing
class UpdateWithScanLogicalRule
extends RelRule<RelRule.Config> {
    static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    UpdateWithScanLogicalRule(RelRule.Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelOptTable table;
        RexNode keyCondition;
        TableModifyLogicalRel update = (TableModifyLogicalRel)call.rel(0);
        FullScanLogicalRel scan = (FullScanLogicalRel)call.rel(1);
        boolean isImap = OptUtils.hasTableType(scan, PartitionedMapTable.class);
        if (!OptUtils.requiresJob(update) && isImap && (keyCondition = OptUtils.extractKeyConstantExpression(table = scan.getTable(), update.getCluster().getRexBuilder())) != null) {
            UpdateByKeyMapLogicalRel rel = new UpdateByKeyMapLogicalRel(update.getCluster(), OptUtils.toLogicalConvention(update.getTraitSet()), table, keyCondition, update.getUpdateColumnList(), update.getSourceExpressionList());
            call.transformTo(rel);
            return;
        }
        HazelcastTable hzTable = OptUtils.extractHazelcastTable(scan);
        Object connector = SqlConnectorUtil.getJetSqlConnector(hzTable.getTarget());
        if (connector.dmlSupportsPredicates() && (hzTable.getFilter() == null || connector.supportsExpression(HazelcastRexNode.wrap(hzTable.getFilter())))) {
            UpdateLogicalRel rel = new UpdateLogicalRel(update.getCluster(), OptUtils.toLogicalConvention(update.getTraitSet()), update.getTable(), update.getCatalogReader(), null, Objects.requireNonNull(update.getUpdateColumnList()), Objects.requireNonNull(update.getSourceExpressionList()), update.isFlattened(), hzTable.getFilter());
            call.transformTo(rel);
            return;
        }
        UpdateLogicalRel rel = new UpdateLogicalRel(update.getCluster(), OptUtils.toLogicalConvention(update.getTraitSet()), update.getTable(), update.getCatalogReader(), isImap ? this.rewriteScan(scan) : scan, Objects.requireNonNull(update.getUpdateColumnList()), Objects.requireNonNull(update.getSourceExpressionList()), update.isFlattened(), null);
        call.transformTo(rel);
    }

    private RelNode rewriteScan(FullScanLogicalRel scan) {
        HazelcastRelOptTable relTable = (HazelcastRelOptTable)scan.getTable();
        HazelcastTable hzTable = relTable.unwrap(HazelcastTable.class);
        List<RexNode> keyProjects = this.keyProjects(scan.getCluster().getRexBuilder(), (Table)hzTable.getTarget());
        HazelcastRelOptTable convertedTable = OptUtils.createRelTable(relTable, hzTable.withProject(keyProjects, null), scan.getCluster().getTypeFactory());
        return new FullScanLogicalRel(scan.getCluster(), OptUtils.toLogicalConvention(scan.getTraitSet()), convertedTable, null, -1);
    }

    public List<RexNode> keyProjects(RexBuilder rexBuilder, Table table) {
        List<String> primaryKey = SqlConnectorUtil.getJetSqlConnector(table).getPrimaryKey(table);
        ArrayList<RexNode> res = new ArrayList<RexNode>(primaryKey.size());
        for (int i = 0; i < table.getFieldCount(); ++i) {
            Object field = table.getField(i);
            if (!primaryKey.contains(((TableField)field).getName())) continue;
            RelDataType type = OptUtils.convert(field, HazelcastTypeFactory.INSTANCE);
            res.add(rexBuilder.makeInputRef(type, i));
        }
        return res;
    }

    @Value.Immutable
    static interface Config
    extends RelRule.Config {
        public static final RelRule.Config DEFAULT = ImmutableUpdateWithScanLogicalRule.Config.builder().description(UpdateWithScanLogicalRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(TableModifyLogicalRel.class).predicate(TableModify::isUpdate).inputs(b1 -> b1.operand(FullScanLogicalRel.class).noInputs())).build();

        @Override
        default public RelOptRule toRule() {
            return new UpdateWithScanLogicalRule(this);
        }
    }
}

