/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.sql.impl.schema.MappingField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class Metadata {
    private final List<MappingField> fields;
    private final Map<String, String> options;

    Metadata(Map<String, String> options) {
        this(Collections.emptyList(), options);
    }

    Metadata(List<MappingField> fields, Map<String, String> options) {
        this.fields = fields;
        this.options = options;
    }

    List<MappingField> fields() {
        return this.fields;
    }

    Map<String, String> options() {
        return this.options;
    }

    Metadata merge(Metadata other) {
        ArrayList<MappingField> fields = new ArrayList<MappingField>(Stream.concat(this.fields.stream(), other.fields.stream()).collect(Collectors.toCollection(() -> new TreeSet<MappingField>(Comparator.comparing(MappingField::name)))));
        Map options = Stream.concat(this.options.entrySet().stream(), other.options.entrySet().stream()).collect(LinkedHashMap::new, (map, entry) -> map.putIfAbsent((String)entry.getKey(), (String)entry.getValue()), Map::putAll);
        return new Metadata(fields, options);
    }
}

