/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.impl.connector.WriteJdbcP;
import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractJdbcSqlConnectorProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.SQLExceptionUtils;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.security.impl.function.SecuredFunction;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.sql.CommonDataSource;

public class UpsertProcessorSupplier
extends AbstractJdbcSqlConnectorProcessorSupplier
implements DataSerializable,
SecuredFunction {
    private String query;
    private int batchLimit;

    public UpsertProcessorSupplier() {
    }

    public UpsertProcessorSupplier(String dataConnectionName, String query, int batchLimit) {
        super(dataConnectionName);
        this.query = query;
        this.batchLimit = batchLimit;
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList<WriteJdbcP> processors = new ArrayList<WriteJdbcP>(count);
        for (int i = 0; i < count; ++i) {
            WriteJdbcP processor = new WriteJdbcP(this.query, (CommonDataSource)this.dataSource, (BiConsumerEx & Serializable)(ps, row) -> {
                for (int j = 0; j < row.getFieldCount(); ++j) {
                    ps.setObject(j + 1, row.get(j));
                }
            }, SQLExceptionUtils::isNonTransientException, false, this.batchLimit);
            processors.add(processor);
        }
        return processors;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.dataConnectionName);
        out.writeString(this.query);
        out.writeInt(this.batchLimit);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.dataConnectionName = in.readString();
        this.query = in.readString();
        this.batchLimit = in.readInt();
    }
}

