/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTableField;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class JdbcTable
extends JetTable {
    public static final String OPTION_JDBC_BATCH_LIMIT = "jdbc.batch-limit";
    public static final String JDBC_BATCH_LIMIT_DEFAULT_VALUE = "100";
    private final List<String> dbFieldNames;
    private final List<String> primaryKeyFieldNames;
    private final String[] externalName;
    private final List<String> externalNameList;
    private final String dataConnectionName;
    private final Map<String, String> options;
    private final int batchLimit;

    public JdbcTable(@Nonnull SqlConnector sqlConnector, @Nonnull List<TableField> fields, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull TableStatistics statistics) {
        super(sqlConnector, fields, schemaName, mappingName, statistics, externalResource.objectType(), false);
        ArrayList<String> dbFieldNames = new ArrayList<String>(fields.size());
        ArrayList<String> primaryKeyFieldNames = new ArrayList<String>(1);
        for (TableField field : fields) {
            JdbcTableField jdbcField = (JdbcTableField)field;
            dbFieldNames.add(jdbcField.externalName());
            if (!jdbcField.isPrimaryKey()) continue;
            primaryKeyFieldNames.add(jdbcField.getName());
        }
        this.dbFieldNames = Collections.unmodifiableList(dbFieldNames);
        this.primaryKeyFieldNames = Collections.unmodifiableList(primaryKeyFieldNames);
        this.externalName = externalResource.externalName();
        this.externalNameList = Arrays.asList(this.externalName);
        this.dataConnectionName = externalResource.dataConnection();
        this.options = externalResource.options();
        this.batchLimit = Integer.parseInt(this.options.getOrDefault(OPTION_JDBC_BATCH_LIMIT, JDBC_BATCH_LIMIT_DEFAULT_VALUE));
    }

    public List<String> dbFieldNames() {
        return this.dbFieldNames;
    }

    public String[] getExternalName() {
        return this.externalName;
    }

    public List<String> getExternalNameList() {
        return this.externalNameList;
    }

    public String getDataConnectionName() {
        return this.dataConnectionName;
    }

    public int getBatchLimit() {
        return this.batchLimit;
    }

    public JdbcTableField getField(String fieldName) {
        List<TableField> fields = this.getFields();
        for (TableField field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            return (JdbcTableField)field;
        }
        throw new IllegalArgumentException("Unknown field with name " + fieldName);
    }

    public JdbcTableField getFieldByExternalName(String externalName) {
        List<TableField> fields = this.getFields();
        for (TableField field0 : fields) {
            JdbcTableField field = (JdbcTableField)field0;
            if (!field.externalName().equals(externalName)) continue;
            return field;
        }
        throw new IllegalArgumentException("Unknown field with name " + externalName);
    }

    public List<String> getPrimaryKeyList() {
        return this.primaryKeyFieldNames;
    }

    @Override
    public PlanObjectKey getObjectKey() {
        return new JdbcPlanObjectKey(this.getSchemaName(), this.getSqlName(), this.externalName, this.dataConnectionName, this.getFields(), this.options);
    }

    static final class JdbcPlanObjectKey
    implements PlanObjectKey {
        private final String schemaName;
        private final String tableName;
        private final String[] externalName;
        private final String dataConnectionName;
        private final List<TableField> fields;
        private final Map<String, String> options;

        JdbcPlanObjectKey(String schemaName, String tableName, String[] externalName, String dataConnectionName, List<TableField> fields, Map<String, String> options) {
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.externalName = externalName;
            this.dataConnectionName = dataConnectionName;
            this.fields = fields;
            this.options = options;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JdbcPlanObjectKey that = (JdbcPlanObjectKey)o;
            return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Arrays.equals(this.externalName, that.externalName) && Objects.equals(this.dataConnectionName, that.dataConnectionName) && Objects.equals(this.fields, that.fields) && Objects.equals(this.options, that.options);
        }

        public int hashCode() {
            int result = Objects.hash(this.schemaName, this.tableName, this.dataConnectionName, this.fields, this.options);
            result = 31 * result + Arrays.hashCode(this.externalName);
            return result;
        }
    }
}

