/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nonnull;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlReturnTypeInference;

public final class HazelcastReturnTypeInference
implements SqlReturnTypeInference {
    private static final ThreadLocal<Deque<RelDataType>> QUEUE = ThreadLocal.withInitial(() -> new ArrayDeque(2));
    private final SqlReturnTypeInference delegate;

    private HazelcastReturnTypeInference(SqlReturnTypeInference delegate) {
        this.delegate = delegate;
    }

    @Nonnull
    public static HazelcastReturnTypeInference wrap(@Nonnull SqlReturnTypeInference delegate) {
        return new HazelcastReturnTypeInference(delegate);
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType type = HazelcastReturnTypeInference.peek();
        if (type != null) {
            return type;
        }
        return this.delegate.inferReturnType(opBinding);
    }

    public static void push(RelDataType callType) {
        QUEUE.get().push(callType);
    }

    public static void pop() {
        Deque<RelDataType> queue = QUEUE.get();
        assert (queue != null);
        RelDataType type = queue.poll();
        assert (type != null);
        if (queue.isEmpty()) {
            QUEUE.remove();
        }
    }

    private static RelDataType peek() {
        Deque<RelDataType> queue = QUEUE.get();
        return queue != null ? queue.peek() : null;
    }
}

