/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators;

import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;

public final class BinaryOperatorOperandTypeInference
implements SqlOperandTypeInference {
    public static final BinaryOperatorOperandTypeInference INSTANCE = new BinaryOperatorOperandTypeInference();

    private BinaryOperatorOperandTypeInference() {
    }

    public void inferOperandTypes(SqlCallBinding binding, RelDataType returnType, RelDataType[] operandTypes) {
        assert (operandTypes.length == 2);
        assert (binding.getOperandCount() == 2);
        boolean hasParameters = binding.operands().stream().anyMatch(operand -> operand.getKind() == SqlKind.DYNAMIC_PARAM);
        int unknownTypeOperandIndex = -1;
        RelDataType knownType = null;
        for (int i = 0; i < binding.getOperandCount(); ++i) {
            RelDataType operandType = binding.getOperandType(i);
            if (operandType.getSqlTypeName() == SqlTypeName.NULL) {
                unknownTypeOperandIndex = i;
                continue;
            }
            if (hasParameters && HazelcastTypeUtils.toHazelcastType(operandType.getSqlTypeName()).getTypeFamily().isNumericInteger()) {
                RelDataType newOperandType;
                operandType = newOperandType = HazelcastTypeUtils.createType(binding.getTypeFactory(), SqlTypeName.BIGINT, operandType.isNullable());
            }
            operandTypes[i] = operandType;
            if (knownType != null) continue;
            knownType = operandType;
        }
        if (knownType == null) {
            throw new HazelcastCallBinding(binding).newValidationSignatureError();
        }
        if (unknownTypeOperandIndex != -1) {
            operandTypes[unknownTypeOperandIndex] = knownType;
        }
    }
}

