/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.literal;

import com.hazelcast.sql.impl.calcite.validate.literal.Literal;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.type.converter.BigDecimalConverter;
import java.math.BigDecimal;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.type.SqlTypeName;

public final class NumericLiteral
extends Literal {
    private final Mode mode;
    private final int bitWidth;

    private NumericLiteral(SqlLiteral original, Object value, SqlTypeName typeName, Mode mode, int bitWidth) {
        super(original, value, typeName);
        this.mode = mode;
        this.bitWidth = bitWidth;
    }

    public static NumericLiteral create(SqlNumericLiteral original) {
        BigDecimal valueDecimal = (BigDecimal)original.getValue();
        if (original.isExact()) {
            if (original.getScale() == 0) {
                try {
                    Number adjustedValue;
                    long value = BigDecimalConverter.INSTANCE.asBigint((Object)valueDecimal);
                    int bitWidth = HazelcastIntegerType.bitWidthOf(value);
                    HazelcastIntegerType type = HazelcastIntegerType.create(bitWidth, false);
                    switch (type.getSqlTypeName()) {
                        case TINYINT: {
                            adjustedValue = (byte)value;
                            break;
                        }
                        case SMALLINT: {
                            adjustedValue = (short)value;
                            break;
                        }
                        case INTEGER: {
                            adjustedValue = (int)value;
                            break;
                        }
                        default: {
                            assert (type.getSqlTypeName() == SqlTypeName.BIGINT);
                            adjustedValue = value;
                        }
                    }
                    return new NumericLiteral((SqlLiteral)original, adjustedValue, type.getSqlTypeName(), Mode.INTEGER, bitWidth);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new NumericLiteral((SqlLiteral)original, valueDecimal, SqlTypeName.DECIMAL, Mode.FRACTIONAL_EXACT, 0);
        }
        return new NumericLiteral((SqlLiteral)original, valueDecimal.doubleValue(), SqlTypeName.DOUBLE, Mode.FRACTIONAL_INEXACT, 0);
    }

    @Override
    public RelDataType getType(HazelcastTypeFactory typeFactory) {
        switch (this.mode) {
            case INTEGER: {
                return HazelcastIntegerType.create(this.bitWidth, false);
            }
            case FRACTIONAL_EXACT: {
                return typeFactory.createSqlType(SqlTypeName.DECIMAL);
            }
        }
        assert (this.mode == Mode.FRACTIONAL_INEXACT);
        return typeFactory.createSqlType(SqlTypeName.DOUBLE);
    }

    private static enum Mode {
        INTEGER,
        FRACTIONAL_EXACT,
        FRACTIONAL_INEXACT;

    }
}

