/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators;

import com.google.common.collect.ImmutableList;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastOperandTypes;
import com.hazelcast.sql.impl.calcite.validate.types.ReplaceUnknownOperandTypeInference;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;

public class HazelcastSqlSubstringFunction
extends SqlFunction {
    public HazelcastSqlSubstringFunction() {
        super("SUBSTRING", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, (SqlOperandTypeInference)new ReplaceUnknownOperandTypeInference(new SqlTypeName[]{SqlTypeName.VARCHAR, SqlTypeName.INTEGER, SqlTypeName.INTEGER}), null, SqlFunctionCategory.STRING);
    }

    public String getSignatureTemplate(int operandsCount) {
        switch (operandsCount) {
            case 2: {
                return "{0}({1} FROM {2})";
            }
            case 3: {
                return "{0}({1} FROM {2} FOR {3})";
            }
        }
        throw new AssertionError();
    }

    public String getAllowedSignatures(String opName) {
        StringBuilder ret = new StringBuilder();
        for (Ord typeName : Ord.zip((List)SqlTypeName.CHAR_TYPES)) {
            if (typeName.i > 0) {
                ret.append(NL);
            }
            ret.append(SqlUtil.getAliasedSignature((SqlOperator)this, (String)opName, (List)ImmutableList.of((Object)typeName.e, (Object)SqlTypeName.INTEGER)));
            ret.append(NL);
            ret.append(SqlUtil.getAliasedSignature((SqlOperator)this, (String)opName, (List)ImmutableList.of((Object)typeName.e, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER)));
        }
        return ret.toString();
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List operands = callBinding.operands();
        assert (operands.size() == 2 || operands.size() == 3);
        FamilyOperandTypeChecker checker = operands.size() == 2 ? OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER}) : OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER});
        checker = HazelcastOperandTypes.notAny((SqlOperandTypeChecker)checker);
        return checker.checkOperandTypes(callBinding, throwOnFailure);
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between((int)2, (int)3);
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        call.operand(0).unparse(writer, leftPrec, rightPrec);
        writer.sep("FROM");
        call.operand(1).unparse(writer, leftPrec, rightPrec);
        if (call.operandCount() == 3) {
            writer.sep("FOR");
            call.operand(2).unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(frame);
    }
}

