/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.schema;

import com.hazelcast.sql.impl.calcite.SqlToQueryType;
import com.hazelcast.sql.impl.calcite.schema.HazelcastSchema;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTableStatistic;
import com.hazelcast.sql.impl.schema.SqlCatalog;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastSchemaUtils {
    private HazelcastSchemaUtils() {
    }

    public static HazelcastSchema createCatalog(Schema schema) {
        return new HazelcastSchema(Collections.singletonMap("hazelcast", schema), Collections.emptyMap());
    }

    public static HazelcastSchema createRootSchema(SqlCatalog catalog) {
        HashMap<String, Schema> schemaMap = new HashMap<String, Schema>();
        for (Map.Entry currentSchemaEntry : catalog.getSchemas().entrySet()) {
            String schemaName = (String)currentSchemaEntry.getKey();
            HashMap<String, Table> schemaTables = new HashMap<String, Table>();
            for (Map.Entry tableEntry : ((Map)currentSchemaEntry.getValue()).entrySet()) {
                String tableName = (String)tableEntry.getKey();
                com.hazelcast.sql.impl.schema.Table table = (com.hazelcast.sql.impl.schema.Table)tableEntry.getValue();
                HazelcastTable convertedTable = new HazelcastTable(table, HazelcastSchemaUtils.createTableStatistic(table));
                schemaTables.put(tableName, (Table)convertedTable);
            }
            HazelcastSchema currentSchema = new HazelcastSchema(Collections.emptyMap(), schemaTables);
            schemaMap.put(schemaName, (Schema)currentSchema);
        }
        HazelcastSchema rootSchema = new HazelcastSchema(schemaMap, Collections.emptyMap());
        return HazelcastSchemaUtils.createCatalog((Schema)rootSchema);
    }

    private static Statistic createTableStatistic(com.hazelcast.sql.impl.schema.Table table) {
        return new HazelcastTableStatistic(table.getStatistics().getRowCount());
    }

    public static RelDataType convert(TableField field, RelDataTypeFactory typeFactory) {
        QueryDataType fieldType = field.getType();
        QueryDataTypeFamily fieldTypeFamily = fieldType.getTypeFamily();
        SqlTypeName sqlTypeName = SqlToQueryType.map(fieldTypeFamily);
        if (sqlTypeName == null) {
            throw new IllegalStateException("Unexpected type family: " + fieldTypeFamily);
        }
        RelDataType relType = typeFactory.createSqlType(sqlTypeName);
        return typeFactory.createTypeWithNullability(relType, true);
    }
}

