/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.types;

import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.ComparableOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastOperandTypes {
    public static final SqlOperandTypeChecker COMPARABLE_ORDERED_COMPARABLE_ORDERED = new ComparableOperandTypeChecker(2, RelDataTypeComparability.ALL, SqlOperandTypeChecker.Consistency.LEAST_RESTRICTIVE);

    private HazelcastOperandTypes() {
    }

    public static SqlSingleOperandTypeChecker notAny(SqlOperandTypeChecker base) {
        return new NotAny(base);
    }

    public static SqlOperandTypeChecker notAllNull(SqlOperandTypeChecker base) {
        return new NotAllNull(base);
    }

    private static final class NotAllNull
    implements SqlOperandTypeChecker {
        private final SqlOperandTypeChecker base;

        NotAllNull(SqlOperandTypeChecker base) {
            this.base = base;
        }

        public boolean checkOperandTypes(SqlCallBinding binding, boolean throwOnFailure) {
            boolean seenNonNull = false;
            for (int i = 0; i < binding.getOperandCount(); ++i) {
                if (HazelcastTypeSystem.typeName(binding.getOperandType(i)) == SqlTypeName.NULL) continue;
                seenNonNull = true;
                break;
            }
            if (!seenNonNull) {
                if (throwOnFailure) {
                    throw binding.newValidationSignatureError();
                }
                return false;
            }
            return this.base.checkOperandTypes(binding, throwOnFailure);
        }

        public SqlOperandCountRange getOperandCountRange() {
            return this.base.getOperandCountRange();
        }

        public String getAllowedSignatures(SqlOperator op, String opName) {
            return this.base.getAllowedSignatures(op, opName);
        }

        public SqlOperandTypeChecker.Consistency getConsistency() {
            return this.base.getConsistency();
        }

        public boolean isOptional(int i) {
            return this.base.isOptional(i);
        }
    }

    private static final class NotAny
    implements SqlSingleOperandTypeChecker {
        private final SqlOperandTypeChecker base;

        NotAny(SqlOperandTypeChecker base) {
            this.base = base;
        }

        public boolean checkOperandTypes(SqlCallBinding binding, boolean throwOnFailure) {
            if (!this.base.checkOperandTypes(binding, throwOnFailure)) {
                return false;
            }
            for (int i = 0; i < binding.getOperandCount(); ++i) {
                if (this.checkSingleOperandType(binding, binding.operand(i), i, throwOnFailure)) continue;
                return false;
            }
            return true;
        }

        public SqlOperandCountRange getOperandCountRange() {
            return this.base.getOperandCountRange();
        }

        public String getAllowedSignatures(SqlOperator op, String opName) {
            return this.base.getAllowedSignatures(op, opName);
        }

        public SqlOperandTypeChecker.Consistency getConsistency() {
            return this.base.getConsistency();
        }

        public boolean isOptional(int i) {
            return this.base.isOptional(i);
        }

        public boolean checkSingleOperandType(SqlCallBinding binding, SqlNode operand, int index, boolean throwOnFailure) {
            if (HazelcastTypeSystem.typeName(binding.getOperandType(index)) == SqlTypeName.ANY) {
                if (throwOnFailure) {
                    throw binding.newValidationSignatureError();
                }
                return false;
            }
            return true;
        }
    }
}

