/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators;

import com.hazelcast.sql.impl.calcite.validate.types.HazelcastOperandTypes;
import com.hazelcast.sql.impl.calcite.validate.types.ReplaceUnknownOperandTypeInference;
import java.util.Arrays;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;

public class HazelcastSqlTrimFunction
extends SqlFunction {
    public HazelcastSqlTrimFunction() {
        super("TRIM", SqlKind.TRIM, ReturnTypes.ARG2_NULLABLE, (SqlOperandTypeInference)new ReplaceUnknownOperandTypeInference(SqlTypeName.VARCHAR), (SqlOperandTypeChecker)HazelcastOperandTypes.notAny((SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.STRING, SqlTypeFamily.STRING})), SqlFunctionCategory.STRING);
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        assert (call.operand(0) instanceof SqlLiteral) : call.operand(0);
        call.operand(0).unparse(writer, leftPrec, rightPrec);
        call.operand(1).unparse(writer, leftPrec, rightPrec);
        writer.sep("FROM");
        call.operand(2).unparse(writer, leftPrec, rightPrec);
        writer.endFunCall(frame);
    }

    public String getSignatureTemplate(int operandsCount) {
        assert (operandsCount == 3);
        return "{0}([BOTH|LEADING|TRAILING] {1} FROM {2})";
    }

    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        switch (operands.length) {
            case 1: {
                operands = new SqlNode[]{SqlTrimFunction.Flag.BOTH.symbol(SqlParserPos.ZERO), SqlLiteral.createCharString((String)" ", (SqlParserPos)pos), operands[0]};
                break;
            }
            case 3: {
                assert (operands[0] instanceof SqlLiteral && ((SqlLiteral)operands[0]).getValue() instanceof SqlTrimFunction.Flag);
                if (operands[1] != null) break;
                operands[1] = SqlLiteral.createCharString((String)" ", (SqlParserPos)pos);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid operand count " + Arrays.toString(operands));
            }
        }
        return super.createCall(functionQualifier, pos, operands);
    }
}

