/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.converter.StringConverter;
import java.math.BigDecimal;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Static;

public final class SqlNodeUtil {
    private SqlNodeUtil() {
    }

    public static boolean isParameter(SqlNode node) {
        return node.getKind() == SqlKind.DYNAMIC_PARAM;
    }

    public static boolean isLiteral(SqlNode node) {
        return node.getKind() == SqlKind.LITERAL;
    }

    public static Number numericValue(SqlNode node) {
        if (node.getKind() != SqlKind.LITERAL) {
            return null;
        }
        SqlLiteral literal = (SqlLiteral)node;
        SqlTypeName typeName = literal.getTypeName();
        if (SqlTypeName.CHAR_TYPES.contains(typeName)) {
            String value = (String)literal.getValueAs(String.class);
            if (value == null) {
                return null;
            }
            if (value.contains("e") || value.contains("E")) {
                try {
                    return StringConverter.INSTANCE.asDouble((Object)value);
                }
                catch (QueryException e) {
                    assert (e.getCode() == 2000);
                    throw SqlUtil.newContextException((SqlParserPos)literal.getParserPosition(), (Resources.ExInst)Static.RESOURCE.invalidLiteral(literal.toString(), SqlTypeName.DOUBLE.getName()));
                }
            }
            try {
                return StringConverter.INSTANCE.asDecimal((Object)value);
            }
            catch (QueryException e) {
                assert (e.getCode() == 2000);
                throw SqlUtil.newContextException((SqlParserPos)literal.getParserPosition(), (Resources.ExInst)Static.RESOURCE.invalidLiteral(literal.toString(), SqlTypeName.DECIMAL.getName()));
            }
        }
        if (SqlTypeName.APPROX_TYPES.contains(typeName)) {
            return (Number)literal.getValueAs(Double.class);
        }
        return SqlTypeName.EXACT_TYPES.contains(typeName) ? (Number)((Number)literal.getValueAs(BigDecimal.class)) : (Number)null;
    }
}

