/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.physical;

import com.hazelcast.sql.impl.calcite.opt.HazelcastConventions;
import com.hazelcast.sql.impl.calcite.opt.OptUtils;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionTrait;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionType;
import com.hazelcast.sql.impl.calcite.opt.logical.ProjectLogicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.ProjectPhysicalRel;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;

public final class ProjectPhysicalRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new ProjectPhysicalRule();

    private ProjectPhysicalRule() {
        super(OptUtils.parentChild(ProjectLogicalRel.class, RelNode.class, HazelcastConventions.LOGICAL), ProjectPhysicalRule.class.getSimpleName());
    }

    public void onMatch(RelOptRuleCall call) {
        ProjectLogicalRel logicalProject = (ProjectLogicalRel)call.rel(0);
        RelNode input = logicalProject.getInput();
        RelNode convertedInput = OptUtils.toPhysicalInput(input);
        Collection<InputAndTraitSet> transforms = ProjectPhysicalRule.getTransforms(convertedInput);
        for (InputAndTraitSet transform : transforms) {
            ProjectPhysicalRel newProject = new ProjectPhysicalRel(logicalProject.getCluster(), transform.getTraitSet(), transform.getInput(), logicalProject.getProjects(), logicalProject.getRowType());
            call.transformTo((RelNode)newProject);
        }
    }

    private static Collection<InputAndTraitSet> getTransforms(RelNode convertedInput) {
        ArrayList<InputAndTraitSet> res = new ArrayList<InputAndTraitSet>(1);
        Collection<RelNode> physicalInputs = OptUtils.getPhysicalRelsFromSubset(convertedInput);
        for (RelNode physicalInput : physicalInputs) {
            RelTraitSet finalTraitSet = ProjectPhysicalRule.createPhysicalTraitSet(physicalInput);
            res.add(new InputAndTraitSet(physicalInput, finalTraitSet));
        }
        return res;
    }

    private static RelTraitSet createPhysicalTraitSet(RelNode physicalInput) {
        return OptUtils.traitPlus(physicalInput.getTraitSet(), ProjectPhysicalRule.deriveDistribution(physicalInput));
    }

    private static DistributionTrait deriveDistribution(RelNode physicalInput) {
        DistributionTrait physicalInputDist = OptUtils.getDistribution(physicalInput);
        DistributionType type = physicalInputDist.getType();
        switch (type) {
            case ROOT: {
                return physicalInputDist;
            }
            case REPLICATED: {
                return physicalInputDist;
            }
        }
        assert (type == DistributionType.PARTITIONED);
        return physicalInputDist;
    }

    private static final class InputAndTraitSet {
        private final RelNode input;
        private final RelTraitSet traitSet;

        private InputAndTraitSet(RelNode input, RelTraitSet traitSet) {
            this.input = input;
            this.traitSet = traitSet;
        }

        public RelNode getInput() {
            return this.input;
        }

        public RelTraitSet getTraitSet() {
            return this.traitSet;
        }
    }
}

