/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt;

import com.hazelcast.sql.impl.calcite.opt.HazelcastConventions;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionTrait;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionTraitDef;
import com.hazelcast.sql.impl.calcite.schema.HazelcastRelOptTable;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.HazelcastRelOptCluster;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Table;

public final class OptUtils {
    private OptUtils() {
    }

    public static <R extends RelNode> RelOptRuleOperand single(Class<R> cls, Convention convention) {
        return RelOptRule.operand(cls, (RelTrait)convention, (RelOptRuleOperandChildren)RelOptRule.any());
    }

    public static <R1 extends RelNode, R2 extends RelNode> RelOptRuleOperand parentChild(Class<R1> cls, Class<R2> childCls, Convention convention) {
        RelOptRuleOperand childOperand = RelOptRule.operand(childCls, (RelOptRuleOperandChildren)RelOptRule.any());
        return RelOptRule.operand(cls, (RelTrait)convention, (RelOptRuleOperandChildren)RelOptRule.some((RelOptRuleOperand)childOperand, (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public static RelTraitSet traitPlus(RelTraitSet traitSet, RelTrait trait) {
        return traitSet.plus(trait).simplify();
    }

    public static RelTraitSet traitPlus(RelTraitSet traitSet, RelTrait trait1, RelTrait trait2) {
        return traitSet.plus(trait1).plus(trait2).simplify();
    }

    public static RelTraitSet toLogicalConvention(RelTraitSet traitSet) {
        return OptUtils.traitPlus(traitSet, (RelTrait)HazelcastConventions.LOGICAL);
    }

    public static RelNode toLogicalInput(RelNode input) {
        return RelOptRule.convert((RelNode)input, (RelTraitSet)OptUtils.toLogicalConvention(input.getTraitSet()));
    }

    public static RelTraitSet toPhysicalConvention(RelTraitSet traitSet) {
        return OptUtils.traitPlus(traitSet, (RelTrait)HazelcastConventions.PHYSICAL);
    }

    public static RelTraitSet toPhysicalConvention(RelTraitSet traitSet, DistributionTrait distribution) {
        return OptUtils.traitPlus(traitSet, (RelTrait)HazelcastConventions.PHYSICAL, distribution);
    }

    public static RelNode toPhysicalInput(RelNode input) {
        return RelOptRule.convert((RelNode)input, (RelTraitSet)OptUtils.toPhysicalConvention(input.getTraitSet()));
    }

    public static RelNode toPhysicalInput(RelNode input, DistributionTrait distribution) {
        return RelOptRule.convert((RelNode)input, (RelTraitSet)OptUtils.toPhysicalConvention(input.getTraitSet(), distribution));
    }

    public static boolean isPhysical(RelNode rel) {
        return ((Convention)rel.getTraitSet().getTrait((RelTraitDef)ConventionTraitDef.INSTANCE)).equals(HazelcastConventions.PHYSICAL);
    }

    public static Collection<RelNode> getPhysicalRelsFromSubset(RelNode subset) {
        if (subset instanceof RelSubset) {
            RelSubset subset0 = (RelSubset)subset;
            HashSet<RelTraitSet> traitSets = new HashSet<RelTraitSet>();
            Set<RelNode> res = Collections.newSetFromMap(new IdentityHashMap());
            for (RelNode rel : subset0.getRelList()) {
                if (!OptUtils.isPhysical(rel) || !traitSets.add(rel.getTraitSet())) continue;
                res.add(RelOptRule.convert((RelNode)subset, (RelTraitSet)rel.getTraitSet()));
            }
            return res;
        }
        return Collections.emptyList();
    }

    public static boolean isHazelcastTable(TableScan scan) {
        HazelcastTable table = (HazelcastTable)((Object)scan.getTable().unwrap(HazelcastTable.class));
        return table != null;
    }

    public static HazelcastTable getHazelcastTable(TableScan scan) {
        HazelcastTable table = (HazelcastTable)((Object)scan.getTable().unwrap(HazelcastTable.class));
        assert (table != null);
        return table;
    }

    public static HazelcastRelOptCluster getCluster(RelNode rel) {
        assert (rel.getCluster() instanceof HazelcastRelOptCluster);
        return (HazelcastRelOptCluster)rel.getCluster();
    }

    public static DistributionTraitDef getDistributionDef(RelNode rel) {
        return OptUtils.getCluster(rel).getDistributionTraitDef();
    }

    public static DistributionTrait getDistribution(RelNode rel) {
        return (DistributionTrait)rel.getTraitSet().getTrait((RelTraitDef)OptUtils.getDistributionDef(rel));
    }

    public static HazelcastRelOptTable createRelTable(HazelcastRelOptTable originalRelTable, HazelcastTable newHazelcastTable, RelDataTypeFactory typeFactory) {
        RelOptTableImpl newTable = RelOptTableImpl.create((RelOptSchema)originalRelTable.getRelOptSchema(), (RelDataType)newHazelcastTable.getRowType(typeFactory), (List)originalRelTable.getDelegate().getQualifiedName(), (Table)newHazelcastTable, null);
        return new HazelcastRelOptTable((Prepare.PreparingTable)newTable);
    }

    public static LogicalTableScan createLogicalScanWithNewTable(TableScan originalScan, HazelcastTable newHazelcastTable) {
        HazelcastRelOptTable originalRelTable = (HazelcastRelOptTable)originalScan.getTable();
        HazelcastRelOptTable newTable = OptUtils.createRelTable(originalRelTable, newHazelcastTable, originalScan.getCluster().getTypeFactory());
        return LogicalTableScan.create((RelOptCluster)originalScan.getCluster(), (RelOptTable)newTable, (List)originalScan.getHints());
    }
}

